/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdUUID;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.UUID;

@JsonPropertyOrder(value={"length", "status", "activityId"})
final class RntbdResponseStatus {
    static final int LENGTH = 24;
    @JsonProperty(value="activityId")
    private final UUID activityId;
    @JsonProperty(value="length")
    private final int length;
    private final HttpResponseStatus status;

    RntbdResponseStatus(int length, HttpResponseStatus status, UUID activityId) {
        this.length = length;
        this.status = status;
        this.activityId = activityId;
    }

    public UUID getActivityId() {
        return this.activityId;
    }

    int getHeadersLength() {
        return this.length - 24;
    }

    public int getLength() {
        return this.length;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public int getStatusCode() {
        return this.status.code();
    }

    static RntbdResponseStatus decode(ByteBuf in) {
        long length = in.readUnsignedIntLE();
        if (24L > length || length > Integer.MAX_VALUE) {
            String reason = Strings.lenientFormat((String)"frame length: %s", (Object[])new Object[]{length});
            throw new CorruptedFrameException(reason);
        }
        int code = in.readIntLE();
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)code);
        if (status == null) {
            String reason = Strings.lenientFormat((String)"status code: %s", (Object[])new Object[]{code});
            throw new CorruptedFrameException(reason);
        }
        UUID activityId = RntbdUUID.decode(in);
        return new RntbdResponseStatus((int)length, status, activityId);
    }

    void encode(ByteBuf out) {
        out.writeIntLE(this.getLength());
        out.writeIntLE(this.getStatusCode());
        RntbdUUID.encode(this.getActivityId(), out);
    }

    public String toString() {
        ObjectWriter writer = RntbdObjectMapper.writer();
        try {
            return writer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException error) {
            throw new CorruptedFrameException((Throwable)error);
        }
    }
}

