/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.GoneException;
import com.azure.data.cosmos.internal.directconnectivity.RntbdTransportClient;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdClientChannelPool;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdMetrics;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdRequestTimer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.micrometer.core.instrument.Tag;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=JsonSerializer.class)
public final class RntbdServiceEndpoint
implements RntbdEndpoint {
    private static final String TAG_NAME = RntbdServiceEndpoint.class.getSimpleName();
    private static final long QUIET_PERIOD = 2000000000L;
    private static final AtomicLong instanceCount = new AtomicLong();
    private static final Logger logger = LoggerFactory.getLogger(RntbdServiceEndpoint.class);
    private static final AdaptiveRecvByteBufAllocator receiveBufferAllocator = new AdaptiveRecvByteBufAllocator();
    private final RntbdClientChannelPool channelPool;
    private final AtomicBoolean closed;
    private final AtomicInteger concurrentRequests;
    private final long id;
    private final AtomicLong lastRequestTime;
    private final RntbdMetrics metrics;
    private final Provider provider;
    private final SocketAddress remoteAddress;
    private final RntbdRequestTimer requestTimer;
    private final Tag tag;

    private RntbdServiceEndpoint(Provider provider, RntbdEndpoint.Config config, NioEventLoopGroup group, RntbdRequestTimer timer, URI physicalAddress) {
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group((EventLoopGroup)group)).option(ChannelOption.ALLOCATOR, (Object)config.allocator())).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.connectionTimeoutInMillis())).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)receiveBufferAllocator)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).remoteAddress(physicalAddress.getHost(), physicalAddress.getPort());
        this.channelPool = new RntbdClientChannelPool(this, bootstrap, config);
        this.remoteAddress = bootstrap.config().remoteAddress();
        this.concurrentRequests = new AtomicInteger();
        this.lastRequestTime = new AtomicLong();
        this.closed = new AtomicBoolean();
        this.requestTimer = timer;
        this.tag = Tag.of((String)TAG_NAME, (String)RntbdMetrics.escape(this.remoteAddress.toString()));
        this.id = instanceCount.incrementAndGet();
        this.provider = provider;
        this.metrics = new RntbdMetrics(provider.transportClient, this);
    }

    @Override
    public int channelsAcquired() {
        return this.channelPool.channelsAcquired();
    }

    @Override
    public int channelsAvailable() {
        return this.channelPool.channelsAvailable();
    }

    @Override
    public int concurrentRequests() {
        return this.concurrentRequests.get();
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    public long lastRequestTime() {
        return this.lastRequestTime.get();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public int requestQueueLength() {
        return this.channelPool.requestQueueLength();
    }

    @Override
    public Tag tag() {
        return this.tag;
    }

    @Override
    public long usedDirectMemory() {
        return this.channelPool.usedDirectMemory();
    }

    @Override
    public long usedHeapMemory() {
        return this.channelPool.usedHeapMemory();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.provider.evict(this);
            this.channelPool.close();
        }
    }

    @Override
    public RntbdRequestRecord request(RntbdRequestArgs args) {
        this.throwIfClosed();
        this.concurrentRequests.incrementAndGet();
        this.lastRequestTime.set(args.creationTime());
        if (logger.isDebugEnabled()) {
            args.traceOperation(logger, null, "request", new Object[0]);
            logger.debug("\n  {}\n  {}\n  REQUEST", (Object)this, (Object)args);
        }
        RntbdRequestRecord record = this.write(args);
        record.whenComplete((response, error) -> {
            args.traceOperation(logger, null, "requestComplete", response, error);
            if (error == null) {
                logger.debug("\n  [{}]\n  {}\n  request succeeded with response status: {}", new Object[]{this, args, response.getStatus()});
            } else {
                logger.debug("\n  [{}]\n  {}\n  request failed due to ", new Object[]{this, args, error});
            }
            this.concurrentRequests.decrementAndGet();
            this.metrics.markComplete(record);
        });
        return record;
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    private void releaseToPool(Channel channel) {
        logger.debug("\n  [{}]\n  {}\n  RELEASE", (Object)this, (Object)channel);
        this.channelPool.release(channel).addListener(future -> {
            if (logger.isDebugEnabled()) {
                if (future.isSuccess()) {
                    logger.debug("\n  [{}]\n  {}\n  release succeeded", (Object)this, (Object)channel);
                } else {
                    logger.debug("\n  [{}]\n  {}\n  release failed due to {}", new Object[]{this, channel, future.cause()});
                }
            }
        });
    }

    private void throwIfClosed() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (String)"%s is closed", (Object)this);
    }

    private RntbdRequestRecord write(RntbdRequestArgs requestArgs) {
        RntbdRequestRecord requestRecord = new RntbdRequestRecord(requestArgs, this.requestTimer);
        logger.debug("\n  [{}]\n  {}\n  WRITE", (Object)this, (Object)requestArgs);
        this.channelPool.acquire().addListener(connected -> {
            if (connected.isSuccess()) {
                requestArgs.traceOperation(logger, null, "write", new Object[0]);
                Channel channel = (Channel)connected.get();
                this.releaseToPool(channel);
                channel.write((Object)requestRecord).addListener(future -> requestArgs.traceOperation(logger, null, "writeComplete", channel));
                return;
            }
            UUID activityId = requestArgs.activityId();
            Throwable cause = connected.cause();
            if (connected.isCancelled()) {
                logger.debug("\n  [{}]\n  {}\n  write cancelled: {}", new Object[]{this, requestArgs, cause});
                requestRecord.cancel(true);
            } else {
                logger.debug("\n  [{}]\n  {}\n  write failed due to {} ", new Object[]{this, requestArgs, cause});
                String reason = cause.getMessage();
                GoneException goneException = new GoneException(Strings.lenientFormat((String)"failed to establish connection to %s: %s", (Object[])new Object[]{this.remoteAddress, reason}), cause instanceof Exception ? (Exception)cause : new IOException(reason, cause), (Map<String, String>)ImmutableMap.of((Object)"x-ms-activity-id", (Object)activityId.toString()), requestArgs.replicaPath());
                BridgeInternal.setRequestHeaders(goneException, requestArgs.serviceRequest().getHeaders());
                requestRecord.completeExceptionally(goneException);
            }
        });
        return requestRecord;
    }

    public static final class Provider
    implements RntbdEndpoint.Provider {
        private static final Logger logger = LoggerFactory.getLogger(Provider.class);
        private final AtomicBoolean closed;
        private final RntbdEndpoint.Config config;
        private final ConcurrentHashMap<String, RntbdEndpoint> endpoints;
        private final NioEventLoopGroup eventLoopGroup;
        private final AtomicInteger evictions;
        private final RntbdRequestTimer requestTimer;
        private final RntbdTransportClient transportClient;

        public Provider(RntbdTransportClient transportClient, RntbdTransportClient.Options options, SslContext sslContext) {
            Preconditions.checkNotNull((Object)transportClient, (Object)"expected non-null provider");
            Preconditions.checkNotNull((Object)options, (Object)"expected non-null options");
            Preconditions.checkNotNull((Object)sslContext, (Object)"expected non-null sslContext");
            DefaultThreadFactory threadFactory = new DefaultThreadFactory("cosmos-rntbd-nio", true);
            int threadCount = Runtime.getRuntime().availableProcessors();
            Object wireLogLevel = logger.isTraceEnabled() ? LogLevel.TRACE : (logger.isDebugEnabled() ? LogLevel.DEBUG : null);
            this.transportClient = transportClient;
            this.config = new RntbdEndpoint.Config(options, sslContext, (LogLevel)wireLogLevel);
            this.requestTimer = new RntbdRequestTimer(this.config.requestTimeoutInNanos(), this.config.requestTimerResolutionInNanos());
            this.eventLoopGroup = new NioEventLoopGroup(threadCount, (ThreadFactory)threadFactory);
            this.endpoints = new ConcurrentHashMap();
            this.evictions = new AtomicInteger();
            this.closed = new AtomicBoolean();
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.requestTimer.close();
                for (RntbdEndpoint endpoint : this.endpoints.values()) {
                    endpoint.close();
                }
                this.eventLoopGroup.shutdownGracefully(2000000000L, this.config.shutdownTimeoutInNanos(), TimeUnit.NANOSECONDS).addListener(future -> {
                    if (future.isSuccess()) {
                        logger.debug("\n  [{}]\n  closed endpoints", (Object)this);
                        return;
                    }
                    logger.error("\n  [{}]\n  failed to close endpoints due to ", (Object)this, (Object)future.cause());
                });
                return;
            }
            logger.debug("\n  [{}]\n  already closed", (Object)this);
        }

        @Override
        public RntbdEndpoint.Config config() {
            return this.config;
        }

        @Override
        public int count() {
            return this.endpoints.size();
        }

        @Override
        public int evictions() {
            return this.evictions.get();
        }

        @Override
        public RntbdEndpoint get(URI physicalAddress) {
            return this.endpoints.computeIfAbsent(physicalAddress.getAuthority(), authority -> new RntbdServiceEndpoint(this, this.config, this.eventLoopGroup, this.requestTimer, physicalAddress));
        }

        @Override
        public Stream<RntbdEndpoint> list() {
            return this.endpoints.values().stream();
        }

        private void evict(RntbdEndpoint endpoint) {
            if (this.endpoints.remove(endpoint.remoteAddress().toString()) != null) {
                this.evictions.incrementAndGet();
            }
        }
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdServiceEndpoint> {
        public JsonSerializer() {
            super(RntbdServiceEndpoint.class);
        }

        public void serialize(RntbdServiceEndpoint value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeNumberField("id", value.id);
            generator.writeBooleanField("isClosed", value.isClosed());
            generator.writeNumberField("concurrentRequests", value.concurrentRequests());
            generator.writeStringField("remoteAddress", value.remoteAddress.toString());
            generator.writeObjectField("channelPool", (Object)value.channelPool);
            generator.writeEndObject();
        }
    }
}

