/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.query;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CommonsBridgeInternal;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.internal.BackoffRetryUtility;
import com.azure.data.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.data.cosmos.internal.InvalidPartitionExceptionRetryPolicy;
import com.azure.data.cosmos.internal.PartitionKeyRange;
import com.azure.data.cosmos.internal.PartitionKeyRangeGoneRetryPolicy;
import com.azure.data.cosmos.internal.PathsHelper;
import com.azure.data.cosmos.internal.QueryMetrics;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.caches.IPartitionKeyRangeCache;
import com.azure.data.cosmos.internal.caches.RxCollectionCache;
import com.azure.data.cosmos.internal.query.CompositeContinuationToken;
import com.azure.data.cosmos.internal.query.DocumentQueryExecutionContextBase;
import com.azure.data.cosmos.internal.query.IDocumentQueryClient;
import com.azure.data.cosmos.internal.query.OrderByContinuationToken;
import com.azure.data.cosmos.internal.query.Paginator;
import com.azure.data.cosmos.internal.query.TakeContinuationToken;
import com.azure.data.cosmos.internal.query.metrics.ClientSideMetrics;
import com.azure.data.cosmos.internal.query.metrics.FetchExecutionRangeAccumulator;
import com.azure.data.cosmos.internal.query.metrics.SchedulingStopwatch;
import com.azure.data.cosmos.internal.routing.PartitionKeyInternal;
import com.azure.data.cosmos.internal.routing.PartitionKeyRangeIdentity;
import com.azure.data.cosmos.internal.routing.Range;
import com.azure.data.cosmos.internal.routing.RoutingMapProviderHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultDocumentQueryExecutionContext<T extends Resource>
extends DocumentQueryExecutionContextBase<T> {
    private boolean isContinuationExpected;
    private volatile int retries = -1;
    private final SchedulingStopwatch fetchSchedulingMetrics;
    private final FetchExecutionRangeAccumulator fetchExecutionRangeAccumulator;
    private static final String DEFAULT_PARTITION_KEY_RANGE_ID = "0";

    public DefaultDocumentQueryExecutionContext(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, UUID correlatedActivityId, boolean isContinuationExpected) {
        super(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, false, correlatedActivityId);
        this.isContinuationExpected = isContinuationExpected;
        this.fetchSchedulingMetrics = new SchedulingStopwatch();
        this.fetchSchedulingMetrics.ready();
        this.fetchExecutionRangeAccumulator = new FetchExecutionRangeAccumulator(DEFAULT_PARTITION_KEY_RANGE_ID);
    }

    protected PartitionKeyInternal getPartitionKeyInternal() {
        return this.feedOptions.partitionKey() == null ? null : this.feedOptions.partitionKey().getInternalPartitionKey();
    }

    @Override
    public Flux<FeedResponse<T>> executeAsync() {
        FeedOptions newFeedOptions;
        String originalContinuation;
        if (this.feedOptions == null) {
            this.feedOptions = new FeedOptions();
        }
        if (DefaultDocumentQueryExecutionContext.isClientSideContinuationToken(originalContinuation = (newFeedOptions = new FeedOptions(this.feedOptions)).requestContinuation())) {
            newFeedOptions.requestContinuation(null);
            newFeedOptions.maxDegreeOfParallelism(Integer.MAX_VALUE);
        }
        int maxPageSize = newFeedOptions.maxItemCount() != null ? newFeedOptions.maxItemCount() : 100;
        BiFunction<String, Integer, RxDocumentServiceRequest> createRequestFunc = (continuationToken, pageSize) -> this.createRequestAsync((String)continuationToken, (Integer)pageSize);
        Function<RxDocumentServiceRequest, Flux<FeedResponse<T>>> executeFunc = this.executeInternalAsyncFunc();
        return Paginator.getPaginatedQueryResultAsObservable(newFeedOptions, createRequestFunc, executeFunc, this.resourceType, maxPageSize);
    }

    public Mono<List<PartitionKeyRange>> getTargetPartitionKeyRanges(String resourceId, List<Range<String>> queryRanges) {
        return RoutingMapProviderHelper.getOverlappingRanges(this.client.getPartitionKeyRangeCache(), resourceId, queryRanges);
    }

    public Mono<List<PartitionKeyRange>> getTargetPartitionKeyRangesById(String resourceId, String partitionKeyRangeIdInternal) {
        return this.client.getPartitionKeyRangeCache().tryGetPartitionKeyRangeByIdAsync(resourceId, partitionKeyRangeIdInternal, false, null).flatMap(partitionKeyRange -> Mono.just(Collections.singletonList((PartitionKeyRange)partitionKeyRange.v)));
    }

    protected Function<RxDocumentServiceRequest, Flux<FeedResponse<T>>> executeInternalAsyncFunc() {
        RxCollectionCache collectionCache = this.client.getCollectionCache();
        IPartitionKeyRangeCache partitionKeyRangeCache = this.client.getPartitionKeyRangeCache();
        IDocumentClientRetryPolicy retryPolicyInstance = this.client.getResetSessionTokenRetryPolicy().getRequestPolicy();
        retryPolicyInstance = new InvalidPartitionExceptionRetryPolicy(collectionCache, retryPolicyInstance, this.resourceLink, this.feedOptions);
        if (this.resourceTypeEnum.isPartitioned()) {
            retryPolicyInstance = new PartitionKeyRangeGoneRetryPolicy(collectionCache, partitionKeyRangeCache, PathsHelper.getCollectionPath(this.resourceLink), retryPolicyInstance, this.feedOptions);
        }
        IDocumentClientRetryPolicy finalRetryPolicyInstance = retryPolicyInstance;
        return req -> {
            finalRetryPolicyInstance.onBeforeSendRequest((RxDocumentServiceRequest)req);
            this.fetchExecutionRangeAccumulator.beginFetchRange();
            this.fetchSchedulingMetrics.start();
            return BackoffRetryUtility.executeRetry(() -> {
                ++this.retries;
                return this.executeRequestAsync((RxDocumentServiceRequest)req);
            }, finalRetryPolicyInstance).flux().map(tFeedResponse -> {
                this.fetchSchedulingMetrics.stop();
                this.fetchExecutionRangeAccumulator.endFetchRange(tFeedResponse.activityId(), tFeedResponse.results().size(), this.retries);
                ImmutablePair schedulingTimeSpanMap = new ImmutablePair((Object)DEFAULT_PARTITION_KEY_RANGE_ID, (Object)this.fetchSchedulingMetrics.getElapsedTime());
                if (!StringUtils.isEmpty((CharSequence)tFeedResponse.responseHeaders().get("x-ms-documentdb-query-metrics"))) {
                    QueryMetrics qm = BridgeInternal.createQueryMetricsFromDelimitedStringAndClientSideMetrics(tFeedResponse.responseHeaders().get("x-ms-documentdb-query-metrics"), new ClientSideMetrics(this.retries, tFeedResponse.requestCharge(), this.fetchExecutionRangeAccumulator.getExecutionRanges(), Arrays.asList(schedulingTimeSpanMap)), tFeedResponse.activityId());
                    BridgeInternal.putQueryMetricsIntoMap(tFeedResponse, DEFAULT_PARTITION_KEY_RANGE_ID, qm);
                }
                return tFeedResponse;
            });
        };
    }

    private Mono<FeedResponse<T>> executeOnceAsync(IDocumentClientRetryPolicy retryPolicyInstance, String continuationToken) {
        RxDocumentServiceRequest request = this.createRequestAsync(continuationToken, this.feedOptions.maxItemCount());
        if (retryPolicyInstance != null) {
            retryPolicyInstance.onBeforeSendRequest(request);
        }
        if (!Strings.isNullOrEmpty(request.getHeaders().get("x-ms-documentdb-partitionkey")) || !request.getResourceType().isPartitioned()) {
            return this.executeRequestAsync(request);
        }
        request.UseGatewayMode = true;
        return this.executeRequestAsync(request);
    }

    public RxDocumentServiceRequest createRequestAsync(String continuationToken, Integer maxPageSize) {
        Map<String, String> requestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(continuationToken, maxPageSize));
        RxDocumentServiceRequest request = this.createDocumentServiceRequest(requestHeaders, this.query, this.getPartitionKeyInternal());
        if (!StringUtils.isEmpty((CharSequence)CommonsBridgeInternal.partitionKeyRangeIdInternal(this.feedOptions))) {
            request.routeTo(new PartitionKeyRangeIdentity(CommonsBridgeInternal.partitionKeyRangeIdInternal(this.feedOptions)));
        }
        return request;
    }

    private static boolean isClientSideContinuationToken(String continuationToken) {
        if (continuationToken != null) {
            Utils.ValueHolder<CompositeContinuationToken> outCompositeContinuationToken = new Utils.ValueHolder<CompositeContinuationToken>();
            if (CompositeContinuationToken.tryParse(continuationToken, outCompositeContinuationToken)) {
                return true;
            }
            Utils.ValueHolder<OrderByContinuationToken> outOrderByContinuationToken = new Utils.ValueHolder<OrderByContinuationToken>();
            if (OrderByContinuationToken.tryParse(continuationToken, outOrderByContinuationToken)) {
                return true;
            }
            Utils.ValueHolder<TakeContinuationToken> outTakeContinuationToken = new Utils.ValueHolder<TakeContinuationToken>();
            if (TakeContinuationToken.tryParse(continuationToken, outTakeContinuationToken)) {
                return true;
            }
        }
        return false;
    }
}

