/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.query;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.JsonSerializable;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.internal.Exceptions;
import com.azure.data.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.data.cosmos.internal.ObservableHelper;
import com.azure.data.cosmos.internal.PartitionKeyRange;
import com.azure.data.cosmos.internal.QueryMetrics;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.query.IDocumentQueryClient;
import com.azure.data.cosmos.internal.query.Paginator;
import com.azure.data.cosmos.internal.query.TriFunction;
import com.azure.data.cosmos.internal.query.metrics.ClientSideMetrics;
import com.azure.data.cosmos.internal.query.metrics.FetchExecutionRangeAccumulator;
import com.azure.data.cosmos.internal.query.metrics.SchedulingStopwatch;
import com.azure.data.cosmos.internal.routing.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DocumentProducer<T extends Resource> {
    private static final Logger logger = LoggerFactory.getLogger(DocumentProducer.class);
    private int retries;
    protected final IDocumentQueryClient client;
    protected final String collectionRid;
    protected final FeedOptions feedOptions;
    protected final Class<T> resourceType;
    protected final PartitionKeyRange targetRange;
    protected final String collectionLink;
    protected final TriFunction<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc;
    protected final Function<RxDocumentServiceRequest, Flux<FeedResponse<T>>> executeRequestFuncWithRetries;
    protected final Callable<IDocumentClientRetryPolicy> createRetryPolicyFunc;
    protected final int pageSize;
    protected final UUID correlatedActivityId;
    public int top;
    private volatile String lastResponseContinuationToken;
    private final SchedulingStopwatch fetchSchedulingMetrics;
    private SchedulingStopwatch moveNextSchedulingMetrics;
    private final FetchExecutionRangeAccumulator fetchExecutionRangeAccumulator;

    public DocumentProducer(IDocumentQueryClient client, String collectionResourceId, FeedOptions feedOptions, TriFunction<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc, Function<RxDocumentServiceRequest, Flux<FeedResponse<T>>> executeRequestFunc, PartitionKeyRange targetRange, String collectionLink, Callable<IDocumentClientRetryPolicy> createRetryPolicyFunc, Class<T> resourceType, UUID correlatedActivityId, int initialPageSize, String initialContinuationToken, int top) {
        this.client = client;
        this.collectionRid = collectionResourceId;
        this.createRequestFunc = createRequestFunc;
        this.fetchSchedulingMetrics = new SchedulingStopwatch();
        this.fetchSchedulingMetrics.ready();
        this.fetchExecutionRangeAccumulator = new FetchExecutionRangeAccumulator(targetRange.id());
        this.executeRequestFuncWithRetries = request -> {
            this.retries = -1;
            this.fetchSchedulingMetrics.start();
            this.fetchExecutionRangeAccumulator.beginFetchRange();
            IDocumentClientRetryPolicy retryPolicy = null;
            if (createRetryPolicyFunc != null) {
                try {
                    retryPolicy = (IDocumentClientRetryPolicy)createRetryPolicyFunc.call();
                }
                catch (Exception e) {
                    return Flux.error((Throwable)e);
                }
                retryPolicy.onBeforeSendRequest((RxDocumentServiceRequest)request);
            }
            return ObservableHelper.inlineIfPossibleAsObs(() -> {
                ++this.retries;
                return (Flux)executeRequestFunc.apply((RxDocumentServiceRequest)request);
            }, retryPolicy);
        };
        this.correlatedActivityId = correlatedActivityId;
        this.feedOptions = feedOptions != null ? feedOptions : new FeedOptions();
        this.feedOptions.requestContinuation(initialContinuationToken);
        this.lastResponseContinuationToken = initialContinuationToken;
        this.resourceType = resourceType;
        this.targetRange = targetRange;
        this.collectionLink = collectionLink;
        this.createRetryPolicyFunc = createRetryPolicyFunc;
        this.pageSize = initialPageSize;
        this.top = top;
    }

    public Flux<DocumentProducerFeedResponse> produceAsync() {
        BiFunction<String, Integer, RxDocumentServiceRequest> sourcePartitionCreateRequestFunc = (token, maxItemCount) -> this.createRequestFunc.apply(this.targetRange, (String)token, (Integer)maxItemCount);
        Flux obs = Paginator.getPaginatedQueryResultAsObservable(this.feedOptions.requestContinuation(), sourcePartitionCreateRequestFunc, this.executeRequestFuncWithRetries, this.resourceType, this.top, this.pageSize).map(rsp -> {
            this.lastResponseContinuationToken = rsp.continuationToken();
            this.fetchExecutionRangeAccumulator.endFetchRange(rsp.activityId(), rsp.results().size(), this.retries);
            this.fetchSchedulingMetrics.stop();
            return rsp;
        });
        return this.splitProof((Flux<DocumentProducerFeedResponse>)obs.map(x$0 -> new DocumentProducerFeedResponse(x$0)));
    }

    private Flux<DocumentProducerFeedResponse> splitProof(Flux<DocumentProducerFeedResponse> sourceFeedResponseObservable) {
        return sourceFeedResponseObservable.onErrorResume(t -> {
            CosmosClientException dce = Utils.as(t, CosmosClientException.class);
            if (dce == null || !this.isSplit(dce)) {
                logger.error("Unexpected failure", t);
                return Flux.error((Throwable)t);
            }
            logger.info("DocumentProducer handling a partition split in [{}], detail:[{}]", (Object)this.targetRange, (Object)dce);
            Mono<Utils.ValueHolder<List<PartitionKeyRange>>> replacementRangesObs = this.getReplacementRanges(this.targetRange.toRange());
            Flux replacementProducers = replacementRangesObs.flux().flatMap(partitionKeyRangesValueHolder -> {
                if (logger.isDebugEnabled()) {
                    logger.info("Cross Partition Query Execution detected partition [{}] split into [{}] partitions, last continuation token is [{}].", new Object[]{this.targetRange.toJson(), ((List)partitionKeyRangesValueHolder.v).stream().map(JsonSerializable::toJson).collect(Collectors.joining(", ")), this.lastResponseContinuationToken});
                }
                return Flux.fromIterable(this.createReplacingDocumentProducersOnSplit((List)partitionKeyRangesValueHolder.v));
            });
            return this.produceOnSplit(replacementProducers);
        });
    }

    protected Flux<DocumentProducerFeedResponse> produceOnSplit(Flux<DocumentProducer<T>> replacingDocumentProducers) {
        return replacingDocumentProducers.flatMap(DocumentProducer::produceAsync, 1);
    }

    private List<DocumentProducer<T>> createReplacingDocumentProducersOnSplit(List<PartitionKeyRange> partitionKeyRanges) {
        ArrayList<DocumentProducer<T>> replacingDocumentProducers = new ArrayList<DocumentProducer<T>>(partitionKeyRanges.size());
        for (PartitionKeyRange pkr : partitionKeyRanges) {
            replacingDocumentProducers.add(this.createChildDocumentProducerOnSplit(pkr, this.lastResponseContinuationToken));
        }
        return replacingDocumentProducers;
    }

    protected DocumentProducer<T> createChildDocumentProducerOnSplit(PartitionKeyRange targetRange, String initialContinuationToken) {
        return new DocumentProducer<T>(this.client, this.collectionRid, this.feedOptions, this.createRequestFunc, this.executeRequestFuncWithRetries, targetRange, this.collectionLink, null, this.resourceType, this.correlatedActivityId, this.pageSize, initialContinuationToken, this.top);
    }

    private Mono<Utils.ValueHolder<List<PartitionKeyRange>>> getReplacementRanges(Range<String> range) {
        return this.client.getPartitionKeyRangeCache().tryGetOverlappingRangesAsync(this.collectionRid, range, true, this.feedOptions.properties());
    }

    private boolean isSplit(CosmosClientException e) {
        return Exceptions.isPartitionSplit(e);
    }

    class DocumentProducerFeedResponse {
        FeedResponse<T> pageResult;
        PartitionKeyRange sourcePartitionKeyRange;

        DocumentProducerFeedResponse(FeedResponse<T> pageResult) {
            this.pageResult = pageResult;
            this.sourcePartitionKeyRange = DocumentProducer.this.targetRange;
            this.populatePartitionedQueryMetrics();
        }

        DocumentProducerFeedResponse(FeedResponse<T> pageResult, PartitionKeyRange pkr) {
            this.pageResult = pageResult;
            this.sourcePartitionKeyRange = pkr;
            this.populatePartitionedQueryMetrics();
        }

        void populatePartitionedQueryMetrics() {
            String queryMetricsDelimitedString = this.pageResult.responseHeaders().get("x-ms-documentdb-query-metrics");
            if (!StringUtils.isEmpty((CharSequence)queryMetricsDelimitedString)) {
                queryMetricsDelimitedString = queryMetricsDelimitedString + String.format(";%s=%.2f", "requestCharge", this.pageResult.requestCharge());
                ImmutablePair schedulingTimeSpanMap = new ImmutablePair((Object)DocumentProducer.this.targetRange.id(), (Object)DocumentProducer.this.fetchSchedulingMetrics.getElapsedTime());
                QueryMetrics qm = BridgeInternal.createQueryMetricsFromDelimitedStringAndClientSideMetrics(queryMetricsDelimitedString, new ClientSideMetrics(DocumentProducer.this.retries, this.pageResult.requestCharge(), DocumentProducer.this.fetchExecutionRangeAccumulator.getExecutionRanges(), Arrays.asList(schedulingTimeSpanMap)), this.pageResult.activityId());
                BridgeInternal.putQueryMetricsIntoMap(this.pageResult, DocumentProducer.this.targetRange.id(), qm);
            }
        }
    }
}

