/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.sync;

import com.azure.data.cosmos.ChangeFeedOptions;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosContainerProperties;
import com.azure.data.cosmos.CosmosContainerRequestOptions;
import com.azure.data.cosmos.CosmosItemProperties;
import com.azure.data.cosmos.CosmosItemRequestOptions;
import com.azure.data.cosmos.CosmosItemResponse;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.sync.CosmosSyncContainerResponse;
import com.azure.data.cosmos.sync.CosmosSyncDatabase;
import com.azure.data.cosmos.sync.CosmosSyncItem;
import com.azure.data.cosmos.sync.CosmosSyncItemResponse;
import com.azure.data.cosmos.sync.CosmosSyncScripts;
import java.util.Iterator;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosSyncContainer {
    private final CosmosContainer containerWrapper;
    private final CosmosSyncDatabase database;
    private final String id;
    private CosmosSyncScripts scripts;

    CosmosSyncContainer(String id, CosmosSyncDatabase database, CosmosContainer container) {
        this.id = id;
        this.database = database;
        this.containerWrapper = container;
    }

    public String id() {
        return this.id;
    }

    public CosmosSyncContainerResponse read() throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.read());
    }

    public CosmosSyncContainerResponse read(CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.read(options));
    }

    public CosmosSyncContainerResponse delete(CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.delete(options));
    }

    public CosmosSyncContainerResponse delete() throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.delete());
    }

    public CosmosSyncContainerResponse replace(CosmosContainerProperties containerProperties) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.replace(containerProperties));
    }

    public CosmosSyncContainerResponse replace(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.containerWrapper.replace(containerProperties, options));
    }

    public Integer readProvisionedThroughput() throws CosmosClientException {
        return CosmosSyncDatabase.throughputResponseToBlock(this.containerWrapper.readProvisionedThroughput());
    }

    public Integer replaceProvisionedThroughput(int requestUnitsPerSecond) throws CosmosClientException {
        return CosmosSyncDatabase.throughputResponseToBlock(this.containerWrapper.replaceProvisionedThroughput(requestUnitsPerSecond));
    }

    public CosmosSyncItemResponse createItem(Object item) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.containerWrapper.createItem(item));
    }

    public CosmosSyncItemResponse createItem(Object item, CosmosItemRequestOptions options) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.containerWrapper.createItem(item, options));
    }

    public CosmosSyncItemResponse upsertItem(Object item) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.containerWrapper.upsertItem(item));
    }

    public CosmosSyncItemResponse upsertItem(Object item, CosmosItemRequestOptions options) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.containerWrapper.createItem(item, options));
    }

    CosmosSyncItemResponse mapItemResponseAndBlock(Mono<CosmosItemResponse> itemMono) throws CosmosClientException {
        try {
            return (CosmosSyncItemResponse)itemMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    public Iterator<FeedResponse<CosmosItemProperties>> readAllItems(FeedOptions options) {
        return this.getFeedIterator(this.containerWrapper.readAllItems(options));
    }

    public Iterator<FeedResponse<CosmosItemProperties>> queryItems(String query, FeedOptions options) {
        return this.getFeedIterator(this.containerWrapper.queryItems(query, options));
    }

    public Iterator<FeedResponse<CosmosItemProperties>> queryItems(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getFeedIterator(this.containerWrapper.queryItems(querySpec, options));
    }

    public Iterator<FeedResponse<CosmosItemProperties>> queryChangeFeedItems(ChangeFeedOptions changeFeedOptions) {
        return this.getFeedIterator(this.containerWrapper.queryChangeFeedItems(changeFeedOptions));
    }

    public CosmosSyncItem getItem(String id, Object partitionKey) {
        return new CosmosSyncItem(id, partitionKey, this, this.containerWrapper.getItem(id, partitionKey));
    }

    public CosmosSyncScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosSyncScripts(this, this.containerWrapper.getScripts());
        }
        return this.scripts;
    }

    private CosmosSyncItemResponse convertResponse(CosmosItemResponse response) {
        return new CosmosSyncItemResponse(response, null, this);
    }

    private Iterator<FeedResponse<CosmosItemProperties>> getFeedIterator(Flux<FeedResponse<CosmosItemProperties>> itemFlux) {
        return itemFlux.toIterable(1).iterator();
    }
}

