/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosConflict;
import com.azure.data.cosmos.CosmosConflictProperties;
import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosResponse;
import com.azure.data.cosmos.internal.Conflict;
import com.azure.data.cosmos.internal.ResourceResponse;

public class CosmosConflictResponse
extends CosmosResponse<CosmosConflictProperties> {
    private CosmosContainer container;
    private CosmosConflict conflictClient;

    CosmosConflictResponse(ResourceResponse<Conflict> response, CosmosContainer container) {
        super(response);
        this.container = container;
        if (response.getResource() == null) {
            super.resourceSettings(null);
        } else {
            super.resourceSettings(new CosmosConflictProperties(response.getResource().toJson()));
            this.conflictClient = new CosmosConflict(response.getResource().id(), container);
        }
    }

    CosmosContainer getContainer() {
        return this.container;
    }

    public CosmosConflict conflict() {
        return this.conflictClient;
    }

    public CosmosConflictProperties properties() {
        return (CosmosConflictProperties)this.resourceSettings();
    }
}

