/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosResponse;
import com.azure.data.cosmos.CosmosUserDefinedFunctionProperties;
import com.azure.data.cosmos.CosmosUserDefinedFunctionResponse;
import com.azure.data.cosmos.internal.ResourceResponse;
import com.azure.data.cosmos.internal.UserDefinedFunction;
import reactor.core.publisher.Mono;

public class CosmosUserDefinedFunction {
    private CosmosContainer container;
    private String id;

    CosmosUserDefinedFunction(String id, CosmosContainer container) {
        this.id = id;
        this.container = container;
    }

    public String id() {
        return this.id;
    }

    CosmosUserDefinedFunction id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosUserDefinedFunctionResponse> read() {
        return this.container.getDatabase().getDocClientWrapper().readUserDefinedFunction(this.getLink(), null).map(response -> new CosmosUserDefinedFunctionResponse((ResourceResponse<UserDefinedFunction>)response, this.container)).single();
    }

    public Mono<CosmosUserDefinedFunctionResponse> replace(CosmosUserDefinedFunctionProperties udfSettings) {
        return this.container.getDatabase().getDocClientWrapper().replaceUserDefinedFunction(new UserDefinedFunction(udfSettings.toJson()), null).map(response -> new CosmosUserDefinedFunctionResponse((ResourceResponse<UserDefinedFunction>)response, this.container)).single();
    }

    public Mono<CosmosResponse> delete() {
        return this.container.getDatabase().getDocClientWrapper().deleteUserDefinedFunction(this.getLink(), null).map(response -> new CosmosResponse(response.getResource())).single();
    }

    String URIPathSegment() {
        return "udfs";
    }

    String parentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

