/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosError;
import com.azure.data.cosmos.internal.directconnectivity.HttpUtils;
import com.azure.data.cosmos.internal.http.HttpHeaders;
import java.net.URI;
import java.util.Map;

public class MethodNotAllowedException
extends CosmosClientException {
    MethodNotAllowedException() {
        this("The requested verb is not supported.");
    }

    public MethodNotAllowedException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(405, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    MethodNotAllowedException(String message) {
        this(message, null, null, null);
    }

    MethodNotAllowedException(String message, HttpHeaders headers, String requestUriString) {
        this(message, null, headers, requestUriString);
    }

    MethodNotAllowedException(String message, HttpHeaders headers, URI requestUri) {
        this(message, headers, requestUri != null ? requestUri.toString() : null);
    }

    MethodNotAllowedException(Exception innerException) {
        this("The requested verb is not supported.", innerException, null, null);
    }

    public MethodNotAllowedException(String message, Exception innerException, HttpHeaders headers, String requestUriString) {
        super(String.format("%s: %s", "The requested verb is not supported.", message), innerException, HttpUtils.asMap(headers), 405, requestUriString);
    }
}

