/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.query;

import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.internal.BackoffRetryUtility;
import com.azure.data.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.data.cosmos.internal.OperationType;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.query.IDocumentQueryClient;
import com.azure.data.cosmos.internal.query.PartitionedQueryExecutionInfo;
import com.azure.data.cosmos.internal.query.QueryFeature;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Function;
import reactor.core.publisher.Mono;

class QueryPlanRetriever {
    private static final String TRUE = "True";
    private static final String SUPPORTED_QUERY_FEATURES = QueryFeature.Aggregate.name() + ", " + QueryFeature.CompositeAggregate.name() + ", " + QueryFeature.MultipleOrderBy.name() + ", " + QueryFeature.OrderBy.name() + ", " + QueryFeature.OffsetAndLimit.name() + ", " + QueryFeature.Top.name();

    QueryPlanRetriever() {
    }

    static Mono<PartitionedQueryExecutionInfo> getQueryPlanThroughGatewayAsync(IDocumentQueryClient queryClient, SqlQuerySpec sqlQuerySpec, String resourceLink) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "application/json");
        requestHeaders.put("x-ms-cosmos-is-query-plan-request", TRUE);
        requestHeaders.put("x-ms-cosmos-supported-query-features", SUPPORTED_QUERY_FEATURES);
        requestHeaders.put("x-ms-cosmos-query-version", "1.0");
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.QueryPlan, ResourceType.Document, resourceLink, requestHeaders);
        request.UseGatewayMode = true;
        request.setContentBytes(sqlQuerySpec.toJson().getBytes(StandardCharsets.UTF_8));
        IDocumentClientRetryPolicy retryPolicyInstance = queryClient.getResetSessionTokenRetryPolicy().getRequestPolicy();
        Function<RxDocumentServiceRequest, Mono> executeFunc = req -> BackoffRetryUtility.executeRetry(() -> {
            retryPolicyInstance.onBeforeSendRequest((RxDocumentServiceRequest)req);
            return queryClient.executeQueryAsync(request).flatMap(rxDocumentServiceResponse -> {
                PartitionedQueryExecutionInfo partitionedQueryExecutionInfo = new PartitionedQueryExecutionInfo(rxDocumentServiceResponse.getReponseBodyAsString());
                return Mono.just((Object)partitionedQueryExecutionInfo);
            });
        }, retryPolicyInstance);
        return executeFunc.apply(request);
    }
}

