/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.query.metrics;

import com.azure.data.cosmos.internal.query.metrics.QueryMetricsWriter;
import com.azure.data.cosmos.internal.query.metrics.TextTable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class QueryMetricsTextWriter
extends QueryMetricsWriter {
    private final StringBuilder stringBuilder;
    private static final String ActivityIds = "Activity Ids";
    private static final String RetrievedDocumentCount = "Retrieved Document Count";
    private static final String RetrievedDocumentSize = "Retrieved Document Size";
    private static final String OutputDocumentCount = "Output Document Count";
    private static final String OutputDocumentSize = "Output Document Size";
    private static final String IndexUtilizationText = "Index Utilization";
    private static final String TotalQueryExecutionTime = "Total Query Execution Time";
    private static final String QueryPreparationTimes = "Query Preparation Times";
    private static final String QueryCompileTime = "Query Compilation Time";
    private static final String LogicalPlanBuildTime = "Logical Plan Build Time";
    private static final String PhysicalPlanBuildTime = "Physical Plan Build Time";
    private static final String QueryOptimizationTime = "Query Optimization Time";
    private static final String QueryEngineTimes = "Query Engine Times";
    private static final String IndexLookupTime = "Index Lookup Time";
    private static final String DocumentLoadTime = "Document Load Time";
    private static final String DocumentWriteTime = "Document Write Time";
    private static final String RuntimeExecutionTimes = "Runtime Execution Times";
    private static final String TotalExecutionTime = "Query Engine Execution Time";
    private static final String SystemFunctionExecuteTime = "System Function Execution Time";
    private static final String UserDefinedFunctionExecutionTime = "User-defined Function Execution Time";
    private static final String ClientSideQueryMetrics = "Client Side Metrics";
    private static final String Retries = "Retry Count";
    private static final String RequestCharge = "Request Charge";
    private static final String FetchExecutionRanges = "Partition Execution Timeline";
    private static final String SchedulingMetrics = "Scheduling Metrics";
    private static final String StartTimeHeader = "Start Time (UTC)";
    private static final String EndTimeHeader = "End Time (UTC)";
    private static final String DurationHeader = "Duration (ms)";
    private static final String PartitionKeyRangeIdHeader = "Partition Id";
    private static final String NumberOfDocumentsHeader = "NUMBER of Documents";
    private static final String RetryCountHeader = "Retry Count";
    private static final String ActivityIdHeader = "Activity Id";
    private static final String PartitionIdHeader = "Partition Id";
    private static final String ResponseTimeHeader = "Response Time (ms)";
    private static final String RunTimeHeader = "Run Time (ms)";
    private static final String WaitTimeHeader = "Wait Time (ms)";
    private static final String TurnaroundTimeHeader = "Turnaround Time (ms)";
    private static final String NumberOfPreemptionHeader = "NUMBER of Preemptions";
    private static final int MaxDateTimeStringLength = 16;
    private static final int StartTimeHeaderLength = Math.max(16, "Start Time (UTC)".length());
    private static final int EndTimeHeaderLength = Math.max(16, "End Time (UTC)".length());
    private static final int DurationHeaderLength = "Duration (ms)".length();
    private static final int PartitionKeyRangeIdHeaderLength = "Partition Id".length();
    private static final int NumberOfDocumentsHeaderLength = "NUMBER of Documents".length();
    private static final int RetryCountHeaderLength = "Retry Count".length();
    private static final int ActivityIdHeaderLength = UUID.randomUUID().toString().length();
    private static TextTable.Column[] PartitionExecutionTimelineColumns = new TextTable.Column[]{new TextTable.Column("Partition Id", PartitionKeyRangeIdHeaderLength), new TextTable.Column("Activity Id", ActivityIdHeaderLength), new TextTable.Column("Start Time (UTC)", StartTimeHeaderLength), new TextTable.Column("End Time (UTC)", EndTimeHeaderLength), new TextTable.Column("Duration (ms)", DurationHeaderLength), new TextTable.Column("NUMBER of Documents", NumberOfDocumentsHeaderLength), new TextTable.Column("Retry Count", RetryCountHeaderLength)};
    private static TextTable PartitionExecutionTimelineTable = new TextTable(Arrays.asList(PartitionExecutionTimelineColumns));
    private static final int PartitionIdHeaderLength = "Partition Id".length();
    private static final int ResponseTimeHeaderLength = "Response Time (ms)".length();
    private static final int RunTimeHeaderLength = "Run Time (ms)".length();
    private static final int WaitTimeHeaderLength = "Wait Time (ms)".length();
    private static final int TurnaroundTimeHeaderLength = "Turnaround Time (ms)".length();
    private static final int NumberOfPreemptionHeaderLength = "NUMBER of Preemptions".length();
    private static TextTable.Column[] SchedulingMetricsColumns = new TextTable.Column[]{new TextTable.Column("Partition Id", PartitionIdHeaderLength), new TextTable.Column("Response Time (ms)", ResponseTimeHeaderLength), new TextTable.Column("Run Time (ms)", RunTimeHeaderLength), new TextTable.Column("Wait Time (ms)", WaitTimeHeaderLength), new TextTable.Column("Turnaround Time (ms)", TurnaroundTimeHeaderLength), new TextTable.Column("NUMBER of Preemptions", NumberOfPreemptionHeaderLength)};
    private static TextTable SchedulingMetricsTable = new TextTable(Arrays.asList(SchedulingMetricsColumns));
    private String lastFetchPartitionId;
    private String lastActivityId;
    private Instant lastStartTime;
    private Instant lastEndTime;
    private long lastFetchDocumentCount;
    private long lastFetchRetryCount;
    private String lastSchedulingPartitionId;
    private long lastResponseTime;
    private long lastRunTime;
    private long lastWaitTime;
    private long lastTurnaroundTime;
    private long lastNumberOfPreemptions;
    static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss:SSSS").withZone(ZoneOffset.UTC);
    private static final int NANOS_TO_MILLIS = 1000000;

    public QueryMetricsTextWriter(StringBuilder stringBuilder) {
        assert (stringBuilder != null);
        this.stringBuilder = stringBuilder;
    }

    @Override
    protected void writeBeforeQueryMetrics() {
    }

    @Override
    protected void writeRetrievedDocumentCount(long retrievedDocumentCount) {
        QueryMetricsTextWriter.appendCountToStringBuilder(this.stringBuilder, RetrievedDocumentCount, retrievedDocumentCount, 0);
    }

    @Override
    protected void writeRetrievedDocumentSize(long retrievedDocumentSize) {
        QueryMetricsTextWriter.appendBytesToStringBuilder(this.stringBuilder, RetrievedDocumentSize, retrievedDocumentSize, 0);
    }

    @Override
    protected void writeOutputDocumentCount(long outputDocumentCount) {
        QueryMetricsTextWriter.appendCountToStringBuilder(this.stringBuilder, OutputDocumentCount, outputDocumentCount, 0);
    }

    @Override
    protected void writeOutputDocumentSize(long outputDocumentSize) {
        QueryMetricsTextWriter.appendBytesToStringBuilder(this.stringBuilder, OutputDocumentSize, outputDocumentSize, 0);
    }

    @Override
    protected void writeIndexHitRatio(double indexHitRatio) {
        QueryMetricsTextWriter.appendPercentageToStringBuilder(this.stringBuilder, IndexUtilizationText, indexHitRatio, 0);
    }

    @Override
    protected void writeTotalQueryExecutionTime(Duration totalQueryExecutionTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, TotalQueryExecutionTime, QueryMetricsTextWriter.durationToMilliseconds(totalQueryExecutionTime), 0);
    }

    @Override
    protected void writeBeforeQueryPreparationTimes() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, QueryPreparationTimes, 1);
    }

    @Override
    protected void writeQueryCompilationTime(Duration queryCompilationTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, QueryCompileTime, QueryMetricsTextWriter.durationToMilliseconds(queryCompilationTime), 2);
    }

    @Override
    protected void writeLogicalPlanBuildTime(Duration logicalPlanBuildTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, LogicalPlanBuildTime, QueryMetricsTextWriter.durationToMilliseconds(logicalPlanBuildTime), 2);
    }

    @Override
    protected void writePhysicalPlanBuildTime(Duration physicalPlanBuildTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, PhysicalPlanBuildTime, QueryMetricsTextWriter.durationToMilliseconds(physicalPlanBuildTime), 2);
    }

    @Override
    protected void writeQueryOptimizationTime(Duration queryOptimizationTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, QueryOptimizationTime, QueryMetricsTextWriter.durationToMilliseconds(queryOptimizationTime), 2);
    }

    @Override
    protected void writeAfterQueryPreparationTimes() {
    }

    @Override
    protected void writeIndexLookupTime(Duration indexLookupTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, IndexLookupTime, QueryMetricsTextWriter.durationToMilliseconds(indexLookupTime), 1);
    }

    @Override
    protected void writeDocumentLoadTime(Duration documentLoadTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, DocumentLoadTime, QueryMetricsTextWriter.durationToMilliseconds(documentLoadTime), 1);
    }

    @Override
    protected void writeVMExecutionTime(Duration vMExecutionTime) {
    }

    @Override
    protected void writeBeforeRuntimeExecutionTimes() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, RuntimeExecutionTimes, 1);
    }

    @Override
    protected void writeQueryEngineExecutionTime(Duration queryEngineExecutionTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, QueryEngineTimes, QueryMetricsTextWriter.durationToMilliseconds(queryEngineExecutionTime), 2);
    }

    @Override
    protected void writeSystemFunctionExecutionTime(Duration systemFunctionExecutionTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, SystemFunctionExecuteTime, QueryMetricsTextWriter.durationToMilliseconds(systemFunctionExecutionTime), 2);
    }

    @Override
    protected void writeUserDefinedFunctionExecutionTime(Duration userDefinedFunctionExecutionTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, UserDefinedFunctionExecutionTime, QueryMetricsTextWriter.durationToMilliseconds(userDefinedFunctionExecutionTime), 2);
    }

    @Override
    protected void writeAfterRuntimeExecutionTimes() {
    }

    @Override
    protected void writeDocumentWriteTime(Duration documentWriteTime) {
        QueryMetricsTextWriter.appendMillisecondsToStringBuilder(this.stringBuilder, DocumentWriteTime, QueryMetricsTextWriter.durationToMilliseconds(documentWriteTime), 1);
    }

    @Override
    protected void writeBeforeClientSideMetrics() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, ClientSideQueryMetrics, 0);
    }

    @Override
    protected void writeRetries(long retries) {
        QueryMetricsTextWriter.appendCountToStringBuilder(this.stringBuilder, "Retry Count", retries, 1);
    }

    @Override
    protected void writeRequestCharge(double requestCharge) {
        QueryMetricsTextWriter.appendRUToStringBuilder(this.stringBuilder, RequestCharge, requestCharge, 1);
    }

    @Override
    protected void writeBeforePartitionExecutionTimeline() {
        QueryMetricsTextWriter.appendNewlineToStringBuilder(this.stringBuilder);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, FetchExecutionRanges, 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, PartitionExecutionTimelineTable.getTopLine(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, PartitionExecutionTimelineTable.getHeader(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, PartitionExecutionTimelineTable.getMiddleLine(), 1);
    }

    @Override
    protected void writeBeforeFetchExecutionRange() {
    }

    @Override
    protected void writeFetchPartitionKeyRangeId(String partitionId) {
        this.lastFetchPartitionId = partitionId;
    }

    @Override
    protected void writeActivityId(String activityId) {
        this.lastActivityId = activityId;
    }

    @Override
    protected void writeStartTime(Instant startTime) {
        this.lastStartTime = startTime;
    }

    @Override
    protected void writeEndTime(Instant endTime) {
        this.lastEndTime = endTime;
    }

    @Override
    protected void writeFetchDocumentCount(long numberOfDocuments) {
        this.lastFetchDocumentCount = numberOfDocuments;
    }

    @Override
    protected void writeFetchRetryCount(long retryCount) {
        this.lastFetchRetryCount = retryCount;
    }

    @Override
    protected void writeAfterFetchExecutionRange() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, PartitionExecutionTimelineTable.getRow(Arrays.asList(this.lastFetchPartitionId, this.lastActivityId, formatter.format(this.lastStartTime), formatter.format(this.lastEndTime), QueryMetricsTextWriter.nanosToMilliSeconds(this.lastEndTime.minusNanos(this.lastStartTime.getNano()).getNano()), this.lastFetchDocumentCount, this.lastFetchRetryCount)), 1);
    }

    @Override
    protected void writeAfterPartitionExecutionTimeline() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, PartitionExecutionTimelineTable.getBottomLine(), 1);
    }

    @Override
    protected void writeBeforeSchedulingMetrics() {
        QueryMetricsTextWriter.appendNewlineToStringBuilder(this.stringBuilder);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SchedulingMetrics, 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SchedulingMetricsTable.getTopLine(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SchedulingMetricsTable.getHeader(), 1);
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SchedulingMetricsTable.getMiddleLine(), 1);
    }

    @Override
    protected void writeBeforePartitionSchedulingDuration() {
    }

    @Override
    protected void writePartitionSchedulingDurationId(String partitionId) {
        this.lastSchedulingPartitionId = partitionId;
    }

    @Override
    protected void writeResponseTime(long responseTime) {
        this.lastResponseTime = responseTime;
    }

    @Override
    protected void writeRunTime(long runTime) {
        this.lastRunTime = runTime;
    }

    @Override
    protected void writeWaitTime(long waitTime) {
        this.lastWaitTime = waitTime;
    }

    @Override
    protected void writeTurnaroundTime(long turnaroundTime) {
        this.lastTurnaroundTime = turnaroundTime;
    }

    @Override
    protected void writeNumberOfPreemptions(long numPreemptions) {
        this.lastNumberOfPreemptions = numPreemptions;
    }

    @Override
    protected void writeAfterPartitionSchedulingDuration() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SchedulingMetricsTable.getRow(Arrays.asList(this.lastSchedulingPartitionId, this.lastResponseTime, this.lastRunTime, this.lastWaitTime, this.lastTurnaroundTime, this.lastNumberOfPreemptions)), 1);
    }

    @Override
    protected void writeAfterSchedulingMetrics() {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(this.stringBuilder, SchedulingMetricsTable.getBottomLine(), 1);
    }

    @Override
    protected void writeAfterClientSideMetrics() {
    }

    @Override
    protected void writeAfterQueryMetrics() {
    }

    static HashMap<String, Double> parseDelimitedString(String delimitedString) {
        String[] headerAttributes;
        if (delimitedString == null) {
            throw new NullPointerException("delimitedString");
        }
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        boolean key = false;
        boolean value = true;
        for (String attribute : headerAttributes = StringUtils.split((String)delimitedString, (String)";")) {
            String[] attributeKeyValue = StringUtils.split((String)attribute, (String)"=");
            if (attributeKeyValue.length != 2) {
                throw new NullPointerException("recieved a malformed delimited STRING");
            }
            String attributeKey = attributeKeyValue[0];
            double attributeValue = Double.parseDouble(attributeKeyValue[1]);
            metrics.put(attributeKey, attributeValue);
        }
        return metrics;
    }

    static Duration durationFromMetrics(HashMap<String, Double> metrics, String key) {
        Double durationInMilliseconds = metrics.get(key);
        if (durationInMilliseconds == null) {
            return Duration.ZERO;
        }
        long seconds = (long)(durationInMilliseconds / 1000.0);
        long nanoseconds = (long)((durationInMilliseconds - (double)seconds * 1000.0) * 1000000.0);
        return Duration.ofSeconds(seconds, nanoseconds);
    }

    static double durationToMilliseconds(Duration duration) {
        double seconds = duration.getSeconds();
        double nano = duration.getNano();
        return seconds * 1000.0 + nano / 1000000.0;
    }

    static Duration getDurationFromMetrics(HashMap<String, Double> metrics, String key) {
        double timeSpanInMilliseconds = metrics.get(key);
        Duration timeSpanFromMetrics = QueryMetricsTextWriter.doubleMillisecondsToDuration(timeSpanInMilliseconds);
        return timeSpanFromMetrics;
    }

    private static Duration doubleMillisecondsToDuration(double timeSpanInMilliseconds) {
        long timeInNanoSeconds = (long)(timeSpanInMilliseconds * 1000000.0);
        return Duration.ofNanos(timeInNanoSeconds);
    }

    private static void appendToStringBuilder(StringBuilder stringBuilder, String property, String value, String units, int indentLevel) {
        String Indent = "  ";
        String FormatString = "%-40s : %15s %-12s %s";
        stringBuilder.append(String.format(Locale.ROOT, "%-40s : %15s %-12s %s", StringUtils.repeat((String)"  ", (int)indentLevel) + property, value, units, System.lineSeparator()));
    }

    static void appendBytesToStringBuilder(StringBuilder stringBuilder, String property, long bytes, int indentLevel) {
        String BytesFormatString = "%d";
        String BytesUnitString = "bytes";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format("%d", bytes), "bytes", indentLevel);
    }

    static void appendMillisecondsToStringBuilder(StringBuilder stringBuilder, String property, double milliseconds, int indentLevel) {
        String MillisecondsFormatString = "%f";
        String MillisecondsUnitString = "milliseconds";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format("%f", milliseconds), "milliseconds", indentLevel);
    }

    static void appendNanosecondsToStringBuilder(StringBuilder stringBuilder, String property, double nanoSeconds, int indentLevel) {
        String MillisecondsFormatString = "%.2f";
        String MillisecondsUnitString = "milliseconds";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format("%.2f", QueryMetricsTextWriter.nanosToMilliSeconds(nanoSeconds)), "milliseconds", indentLevel);
    }

    static double nanosToMilliSeconds(double nanos) {
        return nanos / 1000000.0;
    }

    static void appendHeaderToStringBuilder(StringBuilder stringBuilder, String headerTitle, int indentLevel) {
        String Indent = "  ";
        String FormatString = "%s %s";
        stringBuilder.append(String.format(Locale.ROOT, "%s %s", String.join((CharSequence)StringUtils.repeat((String)"  ", (int)indentLevel), new CharSequence[0]) + headerTitle, System.lineSeparator()));
    }

    static void appendRUToStringBuilder(StringBuilder stringBuilder, String property, double requestCharge, int indentLevel) {
        String RequestChargeFormatString = "%s";
        String RequestChargeUnitString = "RUs";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format(Locale.ROOT, "%s", requestCharge), "RUs", indentLevel);
    }

    static void appendActivityIdsToStringBuilder(StringBuilder stringBuilder, String activityIdsLabel, List<String> activityIds, int indentLevel) {
        String Indent = "  ";
        stringBuilder.append(activityIdsLabel);
        stringBuilder.append(System.lineSeparator());
        for (String activityId : activityIds) {
            stringBuilder.append("  ");
            stringBuilder.append(activityId);
            stringBuilder.append(System.lineSeparator());
        }
    }

    static void appendPercentageToStringBuilder(StringBuilder stringBuilder, String property, double percentage, int indentLevel) {
        String PercentageFormatString = "%.2f";
        String PercentageUnitString = "%";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format("%.2f", percentage * 100.0), "%", indentLevel);
    }

    static void appendCountToStringBuilder(StringBuilder stringBuilder, String property, long count, int indentLevel) {
        String CountFormatString = "%s";
        String CountUnitString = "";
        QueryMetricsTextWriter.appendToStringBuilder(stringBuilder, property, String.format("%s", count), "", indentLevel);
    }

    static void appendNewlineToStringBuilder(StringBuilder stringBuilder) {
        QueryMetricsTextWriter.appendHeaderToStringBuilder(stringBuilder, "", 0);
    }
}

