/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.routing;

import com.azure.data.cosmos.internal.PartitionKeyRange;
import com.azure.data.cosmos.internal.routing.CollectionRoutingMap;
import com.azure.data.cosmos.internal.routing.IServerIdentity;
import com.azure.data.cosmos.internal.routing.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class InMemoryCollectionRoutingMap
implements CollectionRoutingMap {
    private final Map<String, ImmutablePair<PartitionKeyRange, IServerIdentity>> rangeById;
    private final List<PartitionKeyRange> orderedPartitionKeyRanges;
    private final List<Range<String>> orderedRanges;
    private final Set<String> goneRanges;
    private String collectionUniqueId;

    private InMemoryCollectionRoutingMap(Map<String, ImmutablePair<PartitionKeyRange, IServerIdentity>> rangeById, List<PartitionKeyRange> orderedPartitionKeyRanges, String collectionUniqueId) {
        this.rangeById = rangeById;
        this.orderedPartitionKeyRanges = orderedPartitionKeyRanges;
        this.orderedRanges = orderedPartitionKeyRanges.stream().map(range -> new Range<String>(range.getMinInclusive(), range.getMaxExclusive(), true, false)).collect(Collectors.toList());
        this.collectionUniqueId = collectionUniqueId;
        this.goneRanges = new HashSet<String>(orderedPartitionKeyRanges.stream().flatMap(r -> CollectionUtils.emptyIfNull(r.getParents()).stream()).collect(Collectors.toSet()));
    }

    public static InMemoryCollectionRoutingMap tryCreateCompleteRoutingMap(Iterable<ImmutablePair<PartitionKeyRange, IServerIdentity>> ranges, String collectionUniqueId) {
        HashMap<String, ImmutablePair<PartitionKeyRange, IServerIdentity>> rangeById = new HashMap<String, ImmutablePair<PartitionKeyRange, IServerIdentity>>();
        for (ImmutablePair<PartitionKeyRange, IServerIdentity> range2 : ranges) {
            rangeById.put(((PartitionKeyRange)range2.left).id(), range2);
        }
        ArrayList sortedRanges = new ArrayList(rangeById.values());
        Collections.sort(sortedRanges, new MinPartitionKeyPairComparator());
        List<PartitionKeyRange> orderedRanges = sortedRanges.stream().map(range -> (PartitionKeyRange)range.left).collect(Collectors.toList());
        if (!InMemoryCollectionRoutingMap.isCompleteSetOfRanges(orderedRanges)) {
            return null;
        }
        return new InMemoryCollectionRoutingMap(rangeById, orderedRanges, collectionUniqueId);
    }

    private static boolean isCompleteSetOfRanges(List<PartitionKeyRange> orderedRanges) {
        boolean isComplete = false;
        if (orderedRanges.size() > 0) {
            PartitionKeyRange firstRange = orderedRanges.get(0);
            PartitionKeyRange lastRange = orderedRanges.get(orderedRanges.size() - 1);
            isComplete = firstRange.getMinInclusive().compareTo("") == 0;
            isComplete &= lastRange.getMaxExclusive().compareTo("FF") == 0;
            for (int i = 1; i < orderedRanges.size(); ++i) {
                PartitionKeyRange previousRange = orderedRanges.get(i - 1);
                PartitionKeyRange currentRange = orderedRanges.get(i);
                if (isComplete &= previousRange.getMaxExclusive().compareTo(currentRange.getMinInclusive()) == 0) continue;
                if (previousRange.getMaxExclusive().compareTo(currentRange.getMinInclusive()) <= 0) break;
                throw new IllegalStateException("Ranges overlap");
            }
        }
        return isComplete;
    }

    @Override
    public String getCollectionUniqueId() {
        return this.collectionUniqueId;
    }

    @Override
    public List<PartitionKeyRange> getOrderedPartitionKeyRanges() {
        return this.orderedPartitionKeyRanges;
    }

    @Override
    public PartitionKeyRange getRangeByEffectivePartitionKey(String effectivePartitionKeyValue) {
        if ("".compareTo(effectivePartitionKeyValue) == 0) {
            return this.orderedPartitionKeyRanges.get(0);
        }
        if ("FF".compareTo(effectivePartitionKeyValue) == 0) {
            return null;
        }
        int index = Collections.binarySearch(this.orderedRanges, Range.getPointRange(effectivePartitionKeyValue), new Range.MinComparator());
        if (index < 0) {
            index = Math.max(0, -index - 2);
        }
        return this.orderedPartitionKeyRanges.get(index);
    }

    @Override
    public PartitionKeyRange getRangeByPartitionKeyRangeId(String partitionKeyRangeId) {
        ImmutablePair<PartitionKeyRange, IServerIdentity> pair = this.rangeById.get(partitionKeyRangeId);
        return pair == null ? null : (PartitionKeyRange)pair.left;
    }

    @Override
    public List<PartitionKeyRange> getOverlappingRanges(Range<String> range) {
        return this.getOverlappingRanges(Collections.singletonList(range));
    }

    @Override
    public List<PartitionKeyRange> getOverlappingRanges(Collection<Range<String>> providedPartitionKeyRanges) {
        if (providedPartitionKeyRanges == null) {
            throw new IllegalArgumentException("providedPartitionKeyRanges");
        }
        TreeMap<String, PartitionKeyRange> partitionRanges = new TreeMap<String, PartitionKeyRange>();
        for (Range<String> range : providedPartitionKeyRanges) {
            int maxIndex;
            int minIndex = Collections.binarySearch(this.orderedRanges, range, new Range.MinComparator());
            if (minIndex < 0) {
                minIndex = Math.max(minIndex, -minIndex - 2);
            }
            if ((maxIndex = Collections.binarySearch(this.orderedRanges, range, new Range.MaxComparator())) < 0) {
                maxIndex = Math.min(this.orderedRanges.size() - 1, -maxIndex - 1);
            }
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!Range.checkOverlapping(this.orderedRanges.get(i), range)) continue;
                PartitionKeyRange partitionKeyRange = this.orderedPartitionKeyRanges.get(i);
                partitionRanges.put(partitionKeyRange.getMinInclusive(), partitionKeyRange);
            }
        }
        return new ArrayList<PartitionKeyRange>(partitionRanges.values());
    }

    @Override
    public PartitionKeyRange tryGetRangeByPartitionKeyRangeId(String partitionKeyRangeId) {
        Pair addresses = (Pair)this.rangeById.get(partitionKeyRangeId);
        if (addresses != null) {
            return (PartitionKeyRange)addresses.getLeft();
        }
        return null;
    }

    @Override
    public IServerIdentity tryGetInfoByPartitionKeyRangeId(String partitionKeyRangeId) {
        Pair addresses = (Pair)this.rangeById.get(partitionKeyRangeId);
        if (addresses != null) {
            return (IServerIdentity)addresses.getRight();
        }
        return null;
    }

    @Override
    public boolean IsGone(String partitionKeyRangeId) {
        return this.goneRanges.contains(partitionKeyRangeId);
    }

    @Override
    public CollectionRoutingMap tryCombine(List<ImmutablePair<PartitionKeyRange, IServerIdentity>> ranges) {
        HashSet<String> newGoneRanges = new HashSet<String>(ranges.stream().flatMap(tuple -> CollectionUtils.emptyIfNull(((PartitionKeyRange)tuple.getLeft()).getParents()).stream()).collect(Collectors.toSet()));
        newGoneRanges.addAll(this.goneRanges);
        Map<String, ImmutablePair<PartitionKeyRange, IServerIdentity>> newRangeById = this.rangeById.values().stream().filter(tuple -> !newGoneRanges.contains(((PartitionKeyRange)tuple.left).id())).collect(Collectors.toMap(tuple -> ((PartitionKeyRange)tuple.left).id(), tuple -> tuple));
        for (ImmutablePair tuple2 : ranges.stream().filter(tuple -> !newGoneRanges.contains(((PartitionKeyRange)tuple.getLeft()).id())).collect(Collectors.toList())) {
            newRangeById.put(((PartitionKeyRange)tuple2.getLeft()).id(), (ImmutablePair)tuple2);
        }
        List sortedRanges = newRangeById.values().stream().collect(Collectors.toList());
        Collections.sort(sortedRanges, new MinPartitionKeyPairComparator());
        List<PartitionKeyRange> newOrderedRanges = sortedRanges.stream().map(range -> (PartitionKeyRange)range.left).collect(Collectors.toList());
        if (!InMemoryCollectionRoutingMap.isCompleteSetOfRanges(newOrderedRanges)) {
            return null;
        }
        return new InMemoryCollectionRoutingMap(newRangeById, newOrderedRanges, this.getCollectionUniqueId());
    }

    private static class MinPartitionKeyPairComparator
    implements Comparator<ImmutablePair<PartitionKeyRange, IServerIdentity>> {
        private MinPartitionKeyPairComparator() {
        }

        @Override
        public int compare(ImmutablePair<PartitionKeyRange, IServerIdentity> pair1, ImmutablePair<PartitionKeyRange, IServerIdentity> pair2) {
            return ((PartitionKeyRange)pair1.left).getMinInclusive().compareTo(((PartitionKeyRange)pair2.left).getMinInclusive());
        }
    }
}

