/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.sync;

import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosContainerProperties;
import com.azure.data.cosmos.CosmosContainerRequestOptions;
import com.azure.data.cosmos.CosmosContainerResponse;
import com.azure.data.cosmos.CosmosDatabase;
import com.azure.data.cosmos.CosmosDatabaseRequestOptions;
import com.azure.data.cosmos.CosmosUserProperties;
import com.azure.data.cosmos.CosmosUserResponse;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.sync.CosmosSyncClient;
import com.azure.data.cosmos.sync.CosmosSyncContainer;
import com.azure.data.cosmos.sync.CosmosSyncContainerResponse;
import com.azure.data.cosmos.sync.CosmosSyncDatabaseResponse;
import com.azure.data.cosmos.sync.CosmosSyncUser;
import com.azure.data.cosmos.sync.CosmosSyncUserResponse;
import java.util.Iterator;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosSyncDatabase {
    private final CosmosDatabase databaseWrapper;
    private final CosmosSyncClient client;
    private final String id;

    CosmosSyncDatabase(String id, CosmosSyncClient client, CosmosDatabase database) {
        this.id = id;
        this.client = client;
        this.databaseWrapper = database;
    }

    public String id() {
        return this.id;
    }

    public CosmosSyncDatabaseResponse read() throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.read());
    }

    public CosmosSyncDatabaseResponse read(CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.read(options));
    }

    public CosmosSyncDatabaseResponse delete() throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.delete());
    }

    public CosmosSyncDatabaseResponse delete(CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.delete(options));
    }

    public CosmosSyncContainerResponse createContainer(CosmosContainerProperties containerProperties) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties));
    }

    public CosmosSyncContainerResponse createContainer(CosmosContainerProperties containerProperties, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, throughput));
    }

    public CosmosSyncContainerResponse createContainer(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, options));
    }

    public CosmosSyncContainerResponse createContainer(CosmosContainerProperties containerProperties, int throughput, CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, throughput, options));
    }

    public CosmosSyncContainerResponse createContainer(String id, String partitionKeyPath) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(id, partitionKeyPath));
    }

    public CosmosSyncContainerResponse createContainer(String id, String partitionKeyPath, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(id, partitionKeyPath, throughput));
    }

    public CosmosSyncContainerResponse createContainerIfNotExists(CosmosContainerProperties containerProperties) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(containerProperties));
    }

    public CosmosSyncContainerResponse createContainerIfNotExists(CosmosContainerProperties containerProperties, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(containerProperties, throughput));
    }

    public CosmosSyncContainerResponse createContainerIfNotExists(String id, String partitionKeyPath) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(id, partitionKeyPath));
    }

    public CosmosSyncContainerResponse createContainerIfNotExists(String id, String partitionKeyPath, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(id, partitionKeyPath, throughput));
    }

    CosmosSyncContainerResponse mapContainerResponseAndBlock(Mono<CosmosContainerResponse> containerMono) throws CosmosClientException {
        try {
            return (CosmosSyncContainerResponse)containerMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> readAllContainers(FeedOptions options) {
        return this.databaseWrapper.readAllContainers(options).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> readAllContainers() {
        return this.databaseWrapper.readAllContainers().toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> queryContainers(String query) {
        return this.databaseWrapper.queryContainers(query).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> queryContainers(String query, FeedOptions options) {
        return this.databaseWrapper.queryContainers(query, options).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> queryContainers(SqlQuerySpec querySpec) {
        return this.databaseWrapper.queryContainers(querySpec).toIterable().iterator();
    }

    public Iterator<FeedResponse<CosmosContainerProperties>> queryContainers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.databaseWrapper.queryContainers(querySpec, options).toIterable().iterator();
    }

    public CosmosSyncContainer getContainer(String id) {
        return new CosmosSyncContainer(id, this, this.databaseWrapper.getContainer(id));
    }

    CosmosSyncContainerResponse convertResponse(CosmosContainerResponse response) {
        return new CosmosSyncContainerResponse(response, this, this.client);
    }

    public CosmosSyncUserResponse createUser(CosmosUserProperties settings) throws CosmosClientException {
        return this.mapUserResponseAndBlock(this.databaseWrapper.createUser(settings));
    }

    public CosmosSyncUserResponse upsertUser(CosmosUserProperties settings) throws CosmosClientException {
        return this.mapUserResponseAndBlock(this.databaseWrapper.upsertUser(settings));
    }

    public Iterator<FeedResponse<CosmosUserProperties>> readAllUsers() {
        return this.getFeedIterator(this.databaseWrapper.readAllUsers());
    }

    public Iterator<FeedResponse<CosmosUserProperties>> readAllUsers(FeedOptions options) {
        return this.getFeedIterator(this.databaseWrapper.readAllUsers(options));
    }

    public Iterator<FeedResponse<CosmosUserProperties>> queryUsers(String query) {
        return this.getFeedIterator(this.databaseWrapper.queryUsers(query));
    }

    public Iterator<FeedResponse<CosmosUserProperties>> queryUsers(String query, FeedOptions options) {
        return this.getFeedIterator(this.databaseWrapper.queryUsers(query, options));
    }

    public Iterator<FeedResponse<CosmosUserProperties>> queryUsers(SqlQuerySpec querySpec) {
        return this.getFeedIterator(this.databaseWrapper.queryUsers(querySpec));
    }

    public Iterator<FeedResponse<CosmosUserProperties>> queryUsers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getFeedIterator(this.databaseWrapper.queryUsers(querySpec, options));
    }

    public CosmosSyncUser getUser(String id) {
        return new CosmosSyncUser(this.databaseWrapper.getUser(id), this, id);
    }

    CosmosSyncUserResponse mapUserResponseAndBlock(Mono<CosmosUserResponse> containerMono) throws CosmosClientException {
        try {
            return (CosmosSyncUserResponse)containerMono.map(this::convertUserResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    private CosmosSyncUserResponse convertUserResponse(CosmosUserResponse response) {
        return new CosmosSyncUserResponse(response, this);
    }

    public Integer readProvisionedThroughput() throws CosmosClientException {
        return CosmosSyncDatabase.throughputResponseToBlock(this.databaseWrapper.readProvisionedThroughput());
    }

    public Integer replaceProvisionedThroughput(int requestUnitsPerSecond) throws CosmosClientException {
        return CosmosSyncDatabase.throughputResponseToBlock(this.databaseWrapper.replaceProvisionedThroughput(requestUnitsPerSecond));
    }

    static Integer throughputResponseToBlock(Mono<Integer> throughputResponse) throws CosmosClientException {
        try {
            return (Integer)throughputResponse.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    private <T> Iterator<FeedResponse<T>> getFeedIterator(Flux<FeedResponse<T>> itemFlux) {
        return itemFlux.toIterable(1).iterator();
    }
}

