/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.sync;

import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosTrigger;
import com.azure.data.cosmos.CosmosTriggerProperties;
import com.azure.data.cosmos.sync.CosmosSyncContainer;
import com.azure.data.cosmos.sync.CosmosSyncResponse;
import com.azure.data.cosmos.sync.CosmosSyncTriggerResponse;

public class CosmosSyncTrigger {
    private final String id;
    private final CosmosSyncContainer container;
    private final CosmosTrigger trigger;

    CosmosSyncTrigger(String id, CosmosSyncContainer container, CosmosTrigger trigger) {
        this.id = id;
        this.container = container;
        this.trigger = trigger;
    }

    public String id() {
        return this.id;
    }

    public CosmosSyncTriggerResponse read() throws CosmosClientException {
        return this.container.getScripts().mapTriggerResponseAndBlock(this.trigger.read());
    }

    public CosmosSyncTriggerResponse replace(CosmosTriggerProperties triggerSettings) throws CosmosClientException {
        return this.container.getScripts().mapTriggerResponseAndBlock(this.trigger.replace(triggerSettings));
    }

    public CosmosSyncResponse delete() throws CosmosClientException {
        return this.container.getScripts().mapDeleteResponseAndBlock(this.trigger.delete());
    }
}

