/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CosmosConflictRequestOptions;
import com.azure.data.cosmos.CosmosConflictResponse;
import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.internal.Conflict;
import com.azure.data.cosmos.internal.RequestOptions;
import com.azure.data.cosmos.internal.ResourceResponse;
import reactor.core.publisher.Mono;

public class CosmosConflict {
    private CosmosContainer container;
    private String id;

    CosmosConflict(String id, CosmosContainer container) {
        this.id = id;
        this.container = container;
    }

    public String id() {
        return this.id;
    }

    CosmosConflict id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosConflictResponse> read(CosmosConflictRequestOptions options) {
        if (options == null) {
            options = new CosmosConflictRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.container.getDatabase().getDocClientWrapper().readConflict(this.getLink(), requestOptions).map(response -> new CosmosConflictResponse((ResourceResponse<Conflict>)response, this.container)).single();
    }

    public Mono<CosmosConflictResponse> delete(CosmosConflictRequestOptions options) {
        if (options == null) {
            options = new CosmosConflictRequestOptions();
        }
        RequestOptions requestOptions = options.toRequestOptions();
        return this.container.getDatabase().getDocClientWrapper().deleteConflict(this.getLink(), requestOptions).map(response -> new CosmosConflictResponse((ResourceResponse<Conflict>)response, this.container)).single();
    }

    String URIPathSegment() {
        return "conflicts";
    }

    String parentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

