/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.AccessCondition;
import com.azure.data.cosmos.ConsistencyLevel;
import com.azure.data.cosmos.IndexingDirective;
import com.azure.data.cosmos.PartitionKey;
import com.azure.data.cosmos.internal.RequestOptions;
import java.util.List;

public class CosmosItemRequestOptions {
    private ConsistencyLevel consistencyLevel;
    private IndexingDirective indexingDirective;
    private List<String> preTriggerInclude;
    private List<String> postTriggerInclude;
    private String sessionToken;
    private PartitionKey partitionKey;
    private AccessCondition accessCondition;

    public CosmosItemRequestOptions() {
    }

    public CosmosItemRequestOptions(Object partitionKey) {
        if (partitionKey instanceof PartitionKey) {
            this.partitionKey((PartitionKey)partitionKey);
        } else {
            this.partitionKey(new PartitionKey(partitionKey));
        }
    }

    public AccessCondition accessCondition() {
        return this.accessCondition;
    }

    public CosmosItemRequestOptions accessCondition(AccessCondition accessCondition) {
        this.accessCondition = accessCondition;
        return this;
    }

    public ConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public CosmosItemRequestOptions consistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public IndexingDirective indexingDirective() {
        return this.indexingDirective;
    }

    public CosmosItemRequestOptions indexingDirective(IndexingDirective indexingDirective) {
        this.indexingDirective = indexingDirective;
        return this;
    }

    public List<String> preTriggerInclude() {
        return this.preTriggerInclude;
    }

    public CosmosItemRequestOptions preTriggerInclude(List<String> preTriggerInclude) {
        this.preTriggerInclude = preTriggerInclude;
        return this;
    }

    public List<String> postTriggerInclude() {
        return this.postTriggerInclude;
    }

    public CosmosItemRequestOptions postTriggerInclude(List<String> postTriggerInclude) {
        this.postTriggerInclude = postTriggerInclude;
        return this;
    }

    public String sessionToken() {
        return this.sessionToken;
    }

    public CosmosItemRequestOptions sessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    public CosmosItemRequestOptions partitionKey(PartitionKey partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    public PartitionKey partitionKey() {
        return this.partitionKey;
    }

    RequestOptions toRequestOptions() {
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setAccessCondition(this.accessCondition);
        requestOptions.setAccessCondition(this.accessCondition());
        requestOptions.setConsistencyLevel(this.consistencyLevel());
        requestOptions.setIndexingDirective(this.indexingDirective);
        requestOptions.setPreTriggerInclude(this.preTriggerInclude);
        requestOptions.setPostTriggerInclude(this.postTriggerInclude);
        requestOptions.setSessionToken(this.sessionToken);
        requestOptions.setPartitionKey(this.partitionKey);
        return requestOptions;
    }
}

