/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.CompositePath;
import com.azure.data.cosmos.ExcludedPath;
import com.azure.data.cosmos.IncludedPath;
import com.azure.data.cosmos.Index;
import com.azure.data.cosmos.IndexingMode;
import com.azure.data.cosmos.JsonSerializable;
import com.azure.data.cosmos.SpatialSpec;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class IndexingPolicy
extends JsonSerializable {
    private static final String DEFAULT_PATH = "/*";
    private List<IncludedPath> includedPaths;
    private List<ExcludedPath> excludedPaths;
    private List<List<CompositePath>> compositeIndexes;
    private List<SpatialSpec> spatialIndexes;

    public IndexingPolicy() {
        this.automatic(true);
        this.indexingMode(IndexingMode.CONSISTENT);
    }

    public IndexingPolicy(Index[] defaultIndexOverrides) {
        this();
        if (defaultIndexOverrides == null) {
            throw new IllegalArgumentException("defaultIndexOverrides is null.");
        }
        IncludedPath includedPath = new IncludedPath();
        includedPath.path(DEFAULT_PATH);
        includedPath.indexes(new ArrayList<Index>(Arrays.asList(defaultIndexOverrides)));
        this.includedPaths().add(includedPath);
    }

    IndexingPolicy(String jsonString) {
        super(jsonString);
    }

    public Boolean automatic() {
        return super.getBoolean("automatic");
    }

    public IndexingPolicy automatic(boolean automatic) {
        super.set("automatic", automatic);
        return this;
    }

    public IndexingMode indexingMode() {
        IndexingMode result = IndexingMode.LAZY;
        try {
            result = IndexingMode.valueOf(StringUtils.upperCase((String)super.getString("indexingMode")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("INVALID indexingMode value {}.", (Object)super.getString("indexingMode"));
        }
        return result;
    }

    public IndexingPolicy indexingMode(IndexingMode indexingMode) {
        super.set("indexingMode", indexingMode.toString());
        return this;
    }

    public List<IncludedPath> includedPaths() {
        if (this.includedPaths == null) {
            this.includedPaths = super.getList("includedPaths", IncludedPath.class, new boolean[0]);
            if (this.includedPaths == null) {
                this.includedPaths = new ArrayList<IncludedPath>();
            }
        }
        return this.includedPaths;
    }

    public void setIncludedPaths(List<IncludedPath> includedPaths) {
        this.includedPaths = includedPaths;
    }

    public List<ExcludedPath> excludedPaths() {
        if (this.excludedPaths == null) {
            this.excludedPaths = super.getList("excludedPaths", ExcludedPath.class, new boolean[0]);
            if (this.excludedPaths == null) {
                this.excludedPaths = new ArrayList<ExcludedPath>();
            }
        }
        return this.excludedPaths;
    }

    public IndexingPolicy excludedPaths(List<ExcludedPath> excludedPaths) {
        this.excludedPaths = excludedPaths;
        return this;
    }

    public List<List<CompositePath>> compositeIndexes() {
        if (this.compositeIndexes == null) {
            this.compositeIndexes = new ArrayList<List<CompositePath>>();
            ArrayNode compositeIndexes = (ArrayNode)super.get("compositeIndexes");
            for (int i = 0; i < compositeIndexes.size(); ++i) {
                ArrayNode compositeIndex = (ArrayNode)compositeIndexes.get(i);
                ArrayList<CompositePath> compositePaths = new ArrayList<CompositePath>();
                for (int j = 0; j < compositeIndex.size(); ++j) {
                    CompositePath candidateCompositePath = new CompositePath(compositeIndex.get(j).toString());
                    compositePaths.add(candidateCompositePath);
                }
                this.compositeIndexes.add(compositePaths);
            }
        }
        return this.compositeIndexes;
    }

    public IndexingPolicy compositeIndexes(List<List<CompositePath>> compositeIndexes) {
        this.compositeIndexes = compositeIndexes;
        super.set("compositeIndexes", this.compositeIndexes);
        return this;
    }

    public List<SpatialSpec> spatialIndexes() {
        if (this.spatialIndexes == null) {
            this.spatialIndexes = super.getList("spatialIndexes", SpatialSpec.class, new boolean[0]);
            if (this.spatialIndexes == null) {
                this.spatialIndexes = new ArrayList<SpatialSpec>();
            }
        }
        return this.spatialIndexes;
    }

    public IndexingPolicy spatialIndexes(List<SpatialSpec> spatialIndexes) {
        this.spatialIndexes = spatialIndexes;
        super.set("spatialIndexes", this.spatialIndexes);
        return this;
    }

    @Override
    void populatePropertyBag() {
        if (this.indexingMode() != IndexingMode.NONE && this.includedPaths().size() == 0 && this.excludedPaths().size() == 0) {
            IncludedPath includedPath = new IncludedPath();
            includedPath.path(DEFAULT_PATH);
            this.includedPaths().add(includedPath);
        }
        if (this.includedPaths != null) {
            for (IncludedPath includedPath : this.includedPaths) {
                includedPath.populatePropertyBag();
            }
            super.set("includedPaths", this.includedPaths);
        }
        if (this.excludedPaths != null) {
            for (ExcludedPath excludedPath : this.excludedPaths) {
                excludedPath.populatePropertyBag();
            }
            super.set("excludedPaths", this.excludedPaths);
        }
    }
}

