/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosError;
import com.azure.data.cosmos.internal.directconnectivity.HttpUtils;
import com.azure.data.cosmos.internal.http.HttpHeaders;
import java.util.Map;

public class InvalidPartitionException
extends CosmosClientException {
    private static final long serialVersionUID = 1L;

    public InvalidPartitionException() {
        this("The requested resource is no longer available at the server.");
    }

    public InvalidPartitionException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(410, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    public InvalidPartitionException(String msg) {
        super(410, msg);
        this.setSubStatus();
    }

    public InvalidPartitionException(String msg, String resourceAddress) {
        super(msg, null, null, 410, resourceAddress);
        this.setSubStatus();
    }

    public InvalidPartitionException(String message, HttpHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    InvalidPartitionException(Exception innerException) {
        this("The requested resource is no longer available at the server.", innerException, null, null);
    }

    InvalidPartitionException(String message, Exception innerException, HttpHeaders headers, String requestUri) {
        super(String.format("%s: %s", "The requested resource is no longer available at the server.", message), innerException, HttpUtils.asMap(headers), 410, requestUri);
        this.setSubStatus();
    }

    private void setSubStatus() {
        this.responseHeaders().put("x-ms-substatus", Integer.toString(1000));
    }
}

