/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.changefeed.implementation;

import com.azure.data.cosmos.internal.changefeed.CancellationToken;
import com.azure.data.cosmos.internal.changefeed.Lease;
import com.azure.data.cosmos.internal.changefeed.LeaseManager;
import com.azure.data.cosmos.internal.changefeed.LeaseRenewer;
import com.azure.data.cosmos.internal.changefeed.exceptions.LeaseLostException;
import java.time.Duration;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class LeaseRenewerImpl
implements LeaseRenewer {
    private static final Logger logger = LoggerFactory.getLogger(LeaseRenewerImpl.class);
    private final LeaseManager leaseManager;
    private final Duration leaseRenewInterval;
    private Lease lease;
    private RuntimeException resultException;

    public LeaseRenewerImpl(Lease lease, LeaseManager leaseManager, Duration leaseRenewInterval) {
        this.lease = lease;
        this.leaseManager = leaseManager;
        this.leaseRenewInterval = leaseRenewInterval;
    }

    @Override
    public Mono<Void> run(CancellationToken cancellationToken) {
        logger.info("Partition {}: renewer task started.", (Object)this.lease.getLeaseToken());
        return Mono.just((Object)this).flatMap(value -> {
            if (cancellationToken.isCancellationRequested()) {
                return Mono.empty();
            }
            ZonedDateTime stopTimer = ZonedDateTime.now().plus(this.leaseRenewInterval);
            return Mono.just((Object)value).delayElement(Duration.ofMillis(100L)).repeat(() -> {
                ZonedDateTime currentTime = ZonedDateTime.now();
                return !cancellationToken.isCancellationRequested() && currentTime.isBefore(stopTimer);
            }).last();
        }).flatMap(value -> {
            if (cancellationToken.isCancellationRequested()) {
                return Mono.empty();
            }
            return this.renew(cancellationToken);
        }).repeat(() -> {
            if (cancellationToken.isCancellationRequested()) {
                logger.info("Partition {}: renewer task stopped.", (Object)this.lease.getLeaseToken());
            }
            return !cancellationToken.isCancellationRequested();
        }).then().doOnError(throwable -> {
            if (throwable instanceof LeaseLostException) {
                logger.info("Partition {}: renew lease loop failed.", (Object)this.lease.getLeaseToken(), throwable);
                this.resultException = (LeaseLostException)throwable;
            } else {
                logger.error("Partition {}: renew lease loop failed.", (Object)this.lease.getLeaseToken(), throwable);
                this.resultException = new RuntimeException((Throwable)throwable);
            }
        });
    }

    @Override
    public RuntimeException getResultException() {
        return this.resultException;
    }

    private Mono<Lease> renew(CancellationToken cancellationToken) {
        if (cancellationToken.isCancellationRequested()) {
            return Mono.empty();
        }
        return this.leaseManager.renew(this.lease).map(renewedLease -> {
            if (renewedLease != null) {
                this.lease = renewedLease;
            }
            logger.info("Partition {}: renewed lease with result {}", (Object)this.lease.getLeaseToken(), (Object)(renewedLease != null ? 1 : 0));
            return renewedLease;
        }).onErrorResume(throwable -> {
            if (throwable instanceof LeaseLostException) {
                LeaseLostException lle = (LeaseLostException)throwable;
                this.resultException = lle;
                logger.error("Partition {}: lost lease on renew.", (Object)this.lease.getLeaseToken(), (Object)lle);
                return Mono.error((Throwable)lle);
            }
            logger.error("Partition {}: failed to renew lease.", (Object)this.lease.getLeaseToken(), throwable);
            return Mono.empty();
        });
    }
}

