/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.query;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.internal.IDocumentClientRetryPolicy;
import com.azure.data.cosmos.internal.PartitionKeyRange;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.query.DocumentProducer;
import com.azure.data.cosmos.internal.query.DocumentQueryExecutionContextBase;
import com.azure.data.cosmos.internal.query.IDocumentQueryClient;
import com.azure.data.cosmos.internal.query.IDocumentQueryExecutionComponent;
import com.azure.data.cosmos.internal.query.TriFunction;
import com.azure.data.cosmos.internal.routing.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public abstract class ParallelDocumentQueryExecutionContextBase<T extends Resource>
extends DocumentQueryExecutionContextBase<T>
implements IDocumentQueryExecutionComponent<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final List<DocumentProducer<T>> documentProducers = new ArrayList<DocumentProducer<T>>();
    protected final List<PartitionKeyRange> partitionKeyRanges;
    protected final SqlQuerySpec querySpec;
    protected int pageSize;
    protected int top = -1;

    protected ParallelDocumentQueryExecutionContextBase(IDocumentQueryClient client, List<PartitionKeyRange> partitionKeyRanges, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, String rewrittenQuery, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        super(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, getLazyFeedResponse, correlatedActivityId);
        this.partitionKeyRanges = partitionKeyRanges;
        this.querySpec = !Strings.isNullOrEmpty(rewrittenQuery) ? new SqlQuerySpec(rewrittenQuery, this.query.parameters()) : this.query;
    }

    protected void initialize(String collectionRid, Map<PartitionKeyRange, String> partitionKeyRangeToContinuationTokenMap, int initialPageSize, SqlQuerySpec querySpecForInit) {
        this.pageSize = initialPageSize;
        Map<String, String> commonRequestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(null, null));
        for (PartitionKeyRange targetRange : partitionKeyRangeToContinuationTokenMap.keySet()) {
            TriFunction<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc = (partitionKeyRange, continuationToken, pageSize) -> {
                HashMap<String, String> headers = new HashMap<String, String>(commonRequestHeaders);
                headers.put("x-ms-continuation", (String)continuationToken);
                headers.put("x-ms-max-item-count", Strings.toString(pageSize));
                if (this.feedOptions.partitionKey() != null) {
                    headers.put("x-ms-documentdb-partitionkey", this.feedOptions.partitionKey().getInternalPartitionKey().toJson());
                }
                return this.createDocumentServiceRequest((Map<String, String>)headers, querySpecForInit, (PartitionKeyRange)partitionKeyRange, collectionRid);
            };
            Function<RxDocumentServiceRequest, Flux<FeedResponse<T>>> executeFunc = request -> this.executeRequestAsync((RxDocumentServiceRequest)request).flux();
            DocumentProducer<T> dp = this.createDocumentProducer(collectionRid, targetRange, partitionKeyRangeToContinuationTokenMap.get(targetRange), initialPageSize, this.feedOptions, querySpecForInit, commonRequestHeaders, createRequestFunc, executeFunc, () -> this.client.getResetSessionTokenRetryPolicy().getRequestPolicy());
            this.documentProducers.add(dp);
        }
    }

    protected <TContinuationToken> int FindTargetRangeAndExtractContinuationTokens(List<PartitionKeyRange> partitionKeyRanges, Range<String> range) throws CosmosClientException {
        int minIndex;
        if (partitionKeyRanges == null) {
            throw new IllegalArgumentException("partitionKeyRanges can not be null.");
        }
        if (partitionKeyRanges.size() < 1) {
            throw new IllegalArgumentException("partitionKeyRanges must have atleast one element.");
        }
        for (PartitionKeyRange partitionKeyRange : partitionKeyRanges) {
            if (partitionKeyRange != null) continue;
            throw new IllegalArgumentException("partitionKeyRanges can not have null elements.");
        }
        PartitionKeyRange needle = new PartitionKeyRange(null, range.getMin(), range.getMax());
        for (minIndex = 0; minIndex < partitionKeyRanges.size() && !needle.getMinInclusive().equals(partitionKeyRanges.get(minIndex).getMinInclusive()); ++minIndex) {
        }
        if (minIndex == partitionKeyRanges.size()) {
            throw BridgeInternal.createCosmosClientException(400, String.format("Could not find partition key range for continuation token: {0}", needle));
        }
        return minIndex;
    }

    protected abstract DocumentProducer<T> createDocumentProducer(String var1, PartitionKeyRange var2, String var3, int var4, FeedOptions var5, SqlQuerySpec var6, Map<String, String> var7, TriFunction<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> var8, Function<RxDocumentServiceRequest, Flux<FeedResponse<T>>> var9, Callable<IDocumentClientRetryPolicy> var10);

    @Override
    public abstract Flux<FeedResponse<T>> drainAsync(int var1);

    public void setTop(int newTop) {
        this.top = newTop;
        for (DocumentProducer<T> producer : this.documentProducers) {
            producer.top = newTop;
        }
    }
}

