/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.sync;

import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosItem;
import com.azure.data.cosmos.CosmosItemRequestOptions;
import com.azure.data.cosmos.sync.CosmosSyncContainer;
import com.azure.data.cosmos.sync.CosmosSyncItemResponse;

public class CosmosSyncItem {
    private final CosmosSyncContainer container;
    private final CosmosItem asyncItem;
    private final String id;
    private final Object partitionKey;

    CosmosSyncItem(String id, Object partitionKey, CosmosSyncContainer cosmosSyncContainer, CosmosItem item) {
        this.id = id;
        this.partitionKey = partitionKey;
        this.container = cosmosSyncContainer;
        this.asyncItem = item;
    }

    public String id() {
        return this.id;
    }

    public Object partitionKey() {
        return this.partitionKey;
    }

    public CosmosSyncItemResponse read(CosmosItemRequestOptions options) throws CosmosClientException {
        return this.container.mapItemResponseAndBlock(this.asyncItem.read(options));
    }

    public CosmosSyncItemResponse replace(Object item, CosmosItemRequestOptions options) throws CosmosClientException {
        return this.container.mapItemResponseAndBlock(this.asyncItem.replace(item, options));
    }

    public CosmosSyncItemResponse delete(CosmosItemRequestOptions options) throws CosmosClientException {
        return this.container.mapItemResponseAndBlock(this.asyncItem.delete(options));
    }
}

