/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosClient;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosContainerProperties;
import com.azure.data.cosmos.CosmosContainerRequestOptions;
import com.azure.data.cosmos.CosmosContainerResponse;
import com.azure.data.cosmos.CosmosDatabaseProperties;
import com.azure.data.cosmos.CosmosDatabaseRequestOptions;
import com.azure.data.cosmos.CosmosDatabaseResponse;
import com.azure.data.cosmos.CosmosUser;
import com.azure.data.cosmos.CosmosUserProperties;
import com.azure.data.cosmos.CosmosUserResponse;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.Resource;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.internal.AsyncDocumentClient;
import com.azure.data.cosmos.internal.Database;
import com.azure.data.cosmos.internal.DocumentCollection;
import com.azure.data.cosmos.internal.Offer;
import com.azure.data.cosmos.internal.ResourceResponse;
import com.azure.data.cosmos.internal.User;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosDatabase {
    private CosmosClient client;
    private String id;

    CosmosDatabase(String id, CosmosClient client) {
        this.id = id;
        this.client = client;
    }

    public String id() {
        return this.id;
    }

    CosmosDatabase id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosDatabaseResponse> read() {
        return this.read(new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosDatabaseResponse> read(CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        return this.getDocClientWrapper().readDatabase(this.getLink(), options.toRequestOptions()).map(response -> new CosmosDatabaseResponse((ResourceResponse<Database>)response, this.getClient())).single();
    }

    public Mono<CosmosDatabaseResponse> delete() {
        return this.delete(new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosDatabaseResponse> delete(CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        return this.getDocClientWrapper().deleteDatabase(this.getLink(), options.toRequestOptions()).map(response -> new CosmosDatabaseResponse((ResourceResponse<Database>)response, this.getClient())).single();
    }

    public Mono<CosmosContainerResponse> createContainer(CosmosContainerProperties containerSettings) {
        return this.createContainer(containerSettings, new CosmosContainerRequestOptions());
    }

    public Mono<CosmosContainerResponse> createContainer(CosmosContainerProperties containerProperties, int throughput) {
        if (containerProperties == null) {
            throw new IllegalArgumentException("containerProperties");
        }
        Resource.validateResource(containerProperties);
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        options.offerThroughput(throughput);
        return this.createContainer(containerProperties, options);
    }

    public Mono<CosmosContainerResponse> createContainer(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) {
        if (containerProperties == null) {
            throw new IllegalArgumentException("containerProperties");
        }
        Resource.validateResource(containerProperties);
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        return this.getDocClientWrapper().createCollection(this.getLink(), containerProperties.getV2Collection(), options.toRequestOptions()).map(response -> new CosmosContainerResponse((ResourceResponse<DocumentCollection>)response, this)).single();
    }

    public Mono<CosmosContainerResponse> createContainer(CosmosContainerProperties containerProperties, int throughput, CosmosContainerRequestOptions options) {
        if (options == null) {
            options = new CosmosContainerRequestOptions();
        }
        options.offerThroughput(throughput);
        return this.createContainer(containerProperties, options);
    }

    public Mono<CosmosContainerResponse> createContainer(String id, String partitionKeyPath) {
        return this.createContainer(new CosmosContainerProperties(id, partitionKeyPath));
    }

    public Mono<CosmosContainerResponse> createContainer(String id, String partitionKeyPath, int throughput) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        options.offerThroughput(throughput);
        return this.createContainer(new CosmosContainerProperties(id, partitionKeyPath), options);
    }

    public Mono<CosmosContainerResponse> createContainerIfNotExists(CosmosContainerProperties containerProperties) {
        CosmosContainer container = this.getContainer(containerProperties.id());
        return this.createContainerIfNotExistsInternal(containerProperties, container, null);
    }

    public Mono<CosmosContainerResponse> createContainerIfNotExists(CosmosContainerProperties containerProperties, int throughput) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        options.offerThroughput(throughput);
        CosmosContainer container = this.getContainer(containerProperties.id());
        return this.createContainerIfNotExistsInternal(containerProperties, container, options);
    }

    public Mono<CosmosContainerResponse> createContainerIfNotExists(String id, String partitionKeyPath) {
        CosmosContainer container = this.getContainer(id);
        return this.createContainerIfNotExistsInternal(new CosmosContainerProperties(id, partitionKeyPath), container, null);
    }

    public Mono<CosmosContainerResponse> createContainerIfNotExists(String id, String partitionKeyPath, int throughput) {
        CosmosContainerRequestOptions options = new CosmosContainerRequestOptions();
        options.offerThroughput(throughput);
        CosmosContainer container = this.getContainer(id);
        return this.createContainerIfNotExistsInternal(new CosmosContainerProperties(id, partitionKeyPath), container, options);
    }

    private Mono<CosmosContainerResponse> createContainerIfNotExistsInternal(CosmosContainerProperties containerProperties, CosmosContainer container, CosmosContainerRequestOptions options) {
        return container.read(options).onErrorResume(exception -> {
            CosmosClientException cosmosClientException;
            Throwable unwrappedException = Exceptions.unwrap((Throwable)exception);
            if (unwrappedException instanceof CosmosClientException && (cosmosClientException = (CosmosClientException)unwrappedException).statusCode() == 404) {
                return this.createContainer(containerProperties, options);
            }
            return Mono.error((Throwable)unwrappedException);
        });
    }

    public Flux<FeedResponse<CosmosContainerProperties>> readAllContainers(FeedOptions options) {
        return this.getDocClientWrapper().readCollections(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosContainerProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public Flux<FeedResponse<CosmosContainerProperties>> readAllContainers() {
        return this.readAllContainers(new FeedOptions());
    }

    public Flux<FeedResponse<CosmosContainerProperties>> queryContainers(String query) {
        return this.queryContainers(new SqlQuerySpec(query));
    }

    public Flux<FeedResponse<CosmosContainerProperties>> queryContainers(String query, FeedOptions options) {
        return this.queryContainers(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosContainerProperties>> queryContainers(SqlQuerySpec querySpec) {
        return this.queryContainers(querySpec, null);
    }

    public Flux<FeedResponse<CosmosContainerProperties>> queryContainers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getDocClientWrapper().queryCollections(this.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(CosmosContainerProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public CosmosContainer getContainer(String id) {
        return new CosmosContainer(id, this);
    }

    public Mono<CosmosUserResponse> createUser(CosmosUserProperties settings) {
        return this.getDocClientWrapper().createUser(this.getLink(), settings.getV2User(), null).map(response -> new CosmosUserResponse((ResourceResponse<User>)response, this)).single();
    }

    public Mono<CosmosUserResponse> upsertUser(CosmosUserProperties settings) {
        return this.getDocClientWrapper().upsertUser(this.getLink(), settings.getV2User(), null).map(response -> new CosmosUserResponse((ResourceResponse<User>)response, this)).single();
    }

    public Flux<FeedResponse<CosmosUserProperties>> readAllUsers() {
        return this.readAllUsers(new FeedOptions());
    }

    public Flux<FeedResponse<CosmosUserProperties>> readAllUsers(FeedOptions options) {
        return this.getDocClientWrapper().readUsers(this.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosUserProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public Flux<FeedResponse<CosmosUserProperties>> queryUsers(String query) {
        return this.queryUsers(query, null);
    }

    public Flux<FeedResponse<CosmosUserProperties>> queryUsers(String query, FeedOptions options) {
        return this.queryUsers(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosUserProperties>> queryUsers(SqlQuerySpec querySpec) {
        return this.queryUsers(querySpec, null);
    }

    public Flux<FeedResponse<CosmosUserProperties>> queryUsers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getDocClientWrapper().queryUsers(this.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponseWithQueryMetrics(CosmosUserProperties.getFromV2Results(response.results()), response.responseHeaders(), response.queryMetrics()));
    }

    public CosmosUser getUser(String id) {
        return new CosmosUser(id, this);
    }

    public Mono<Integer> readProvisionedThroughput() {
        return this.read().flatMap(cosmosDatabaseResponse -> this.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + ((CosmosDatabaseProperties)cosmosDatabaseResponse.resourceSettings()).resourceId() + "'", new FeedOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.results().isEmpty()) {
                return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "No offers found for the resource"));
            }
            return this.getDocClientWrapper().readOffer(((Offer)offerFeedResponse.results().get(0)).selfLink()).single();
        }).map(cosmosContainerResponse1 -> ((Offer)cosmosContainerResponse1.getResource()).getThroughput()));
    }

    public Mono<Integer> replaceProvisionedThroughput(int requestUnitsPerSecond) {
        return this.read().flatMap(cosmosDatabaseResponse -> this.getDocClientWrapper().queryOffers("select * from c where c.offerResourceId = '" + ((CosmosDatabaseProperties)cosmosDatabaseResponse.resourceSettings()).resourceId() + "'", new FeedOptions()).single().flatMap(offerFeedResponse -> {
            if (offerFeedResponse.results().isEmpty()) {
                return Mono.error((Throwable)BridgeInternal.createCosmosClientException(400, "No offers found for the resource"));
            }
            Offer offer = (Offer)offerFeedResponse.results().get(0);
            offer.setThroughput(requestUnitsPerSecond);
            return this.getDocClientWrapper().replaceOffer(offer).single();
        }).map(offerResourceResponse -> ((Offer)offerResourceResponse.getResource()).getThroughput()));
    }

    CosmosClient getClient() {
        return this.client;
    }

    AsyncDocumentClient getDocClientWrapper() {
        return this.client.getDocClientWrapper();
    }

    String URIPathSegment() {
        return "dbs";
    }

    String parentLink() {
        return "";
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parentLink());
        builder.append("/");
        builder.append(this.URIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

