/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.CosmosContainer;
import com.azure.data.cosmos.CosmosDatabase;
import com.azure.data.cosmos.CosmosStoredProcedure;
import com.azure.data.cosmos.CosmosStoredProcedureProperties;
import com.azure.data.cosmos.CosmosStoredProcedureRequestOptions;
import com.azure.data.cosmos.CosmosStoredProcedureResponse;
import com.azure.data.cosmos.CosmosTrigger;
import com.azure.data.cosmos.CosmosTriggerProperties;
import com.azure.data.cosmos.CosmosTriggerResponse;
import com.azure.data.cosmos.CosmosUserDefinedFunction;
import com.azure.data.cosmos.CosmosUserDefinedFunctionProperties;
import com.azure.data.cosmos.CosmosUserDefinedFunctionResponse;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.SqlQuerySpec;
import com.azure.data.cosmos.internal.ResourceResponse;
import com.azure.data.cosmos.internal.StoredProcedure;
import com.azure.data.cosmos.internal.Trigger;
import com.azure.data.cosmos.internal.UserDefinedFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosScripts {
    private final CosmosContainer container;
    private final CosmosDatabase database;

    CosmosScripts(CosmosContainer container) {
        this.container = container;
        this.database = container.getDatabase();
    }

    public Mono<CosmosStoredProcedureResponse> createStoredProcedure(CosmosStoredProcedureProperties properties) {
        return this.createStoredProcedure(properties, new CosmosStoredProcedureRequestOptions());
    }

    public Mono<CosmosStoredProcedureResponse> createStoredProcedure(CosmosStoredProcedureProperties properties, CosmosStoredProcedureRequestOptions options) {
        if (options == null) {
            options = new CosmosStoredProcedureRequestOptions();
        }
        StoredProcedure sProc = new StoredProcedure();
        sProc.id(properties.id());
        sProc.setBody(properties.body());
        return this.database.getDocClientWrapper().createStoredProcedure(this.container.getLink(), sProc, options.toRequestOptions()).map(response -> new CosmosStoredProcedureResponse((ResourceResponse<StoredProcedure>)response, this.container)).single();
    }

    public Flux<FeedResponse<CosmosStoredProcedureProperties>> readAllStoredProcedures(FeedOptions options) {
        return this.database.getDocClientWrapper().readStoredProcedures(this.container.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosStoredProcedureProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public Flux<FeedResponse<CosmosStoredProcedureProperties>> queryStoredProcedures(String query, FeedOptions options) {
        return this.queryStoredProcedures(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosStoredProcedureProperties>> queryStoredProcedures(SqlQuerySpec querySpec, FeedOptions options) {
        return this.database.getDocClientWrapper().queryStoredProcedures(this.container.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(CosmosStoredProcedureProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public CosmosStoredProcedure getStoredProcedure(String id) {
        return new CosmosStoredProcedure(id, this.container);
    }

    public Mono<CosmosUserDefinedFunctionResponse> createUserDefinedFunction(CosmosUserDefinedFunctionProperties properties) {
        UserDefinedFunction udf = new UserDefinedFunction();
        udf.id(properties.id());
        udf.setBody(properties.body());
        return this.database.getDocClientWrapper().createUserDefinedFunction(this.container.getLink(), udf, null).map(response -> new CosmosUserDefinedFunctionResponse((ResourceResponse<UserDefinedFunction>)response, this.container)).single();
    }

    public Flux<FeedResponse<CosmosUserDefinedFunctionProperties>> readAllUserDefinedFunctions(FeedOptions options) {
        return this.database.getDocClientWrapper().readUserDefinedFunctions(this.container.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosUserDefinedFunctionProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public Flux<FeedResponse<CosmosUserDefinedFunctionProperties>> queryUserDefinedFunctions(String query, FeedOptions options) {
        return this.queryUserDefinedFunctions(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosUserDefinedFunctionProperties>> queryUserDefinedFunctions(SqlQuerySpec querySpec, FeedOptions options) {
        return this.database.getDocClientWrapper().queryUserDefinedFunctions(this.container.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(CosmosUserDefinedFunctionProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public CosmosUserDefinedFunction getUserDefinedFunction(String id) {
        return new CosmosUserDefinedFunction(id, this.container);
    }

    public Mono<CosmosTriggerResponse> createTrigger(CosmosTriggerProperties properties) {
        Trigger trigger = new Trigger(properties.toJson());
        return this.database.getDocClientWrapper().createTrigger(this.container.getLink(), trigger, null).map(response -> new CosmosTriggerResponse((ResourceResponse<Trigger>)response, this.container)).single();
    }

    public Flux<FeedResponse<CosmosTriggerProperties>> readAllTriggers(FeedOptions options) {
        return this.database.getDocClientWrapper().readTriggers(this.container.getLink(), options).map(response -> BridgeInternal.createFeedResponse(CosmosTriggerProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public Flux<FeedResponse<CosmosTriggerProperties>> queryTriggers(String query, FeedOptions options) {
        return this.queryTriggers(new SqlQuerySpec(query), options);
    }

    public Flux<FeedResponse<CosmosTriggerProperties>> queryTriggers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.database.getDocClientWrapper().queryTriggers(this.container.getLink(), querySpec, options).map(response -> BridgeInternal.createFeedResponse(CosmosTriggerProperties.getFromV2Results(response.results()), response.responseHeaders()));
    }

    public CosmosTrigger getTrigger(String id) {
        return new CosmosTrigger(id, this.container);
    }
}

