/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.DataType;
import com.azure.data.cosmos.HashIndex;
import com.azure.data.cosmos.IndexKind;
import com.azure.data.cosmos.JsonSerializable;
import com.azure.data.cosmos.RangeIndex;
import com.azure.data.cosmos.SpatialIndex;
import org.apache.commons.lang3.StringUtils;

public abstract class Index
extends JsonSerializable {
    Index(IndexKind indexKind) {
        this.kind(indexKind);
    }

    Index(String jsonString, IndexKind indexKind) {
        super(jsonString);
        this.kind(indexKind);
    }

    public static RangeIndex Range(DataType dataType) {
        return new RangeIndex(dataType);
    }

    public static RangeIndex Range(DataType dataType, int precision) {
        return new RangeIndex(dataType, precision);
    }

    public static HashIndex Hash(DataType dataType) {
        return new HashIndex(dataType);
    }

    public static HashIndex Hash(DataType dataType, int precision) {
        return new HashIndex(dataType, precision);
    }

    public static SpatialIndex Spatial(DataType dataType) {
        return new SpatialIndex(dataType);
    }

    public IndexKind kind() {
        IndexKind result = null;
        try {
            result = IndexKind.valueOf(StringUtils.upperCase((String)super.getString("kind")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("INVALID index kind value %s.", (Object)super.getString("kind"));
        }
        return result;
    }

    private Index kind(IndexKind indexKind) {
        super.set("kind", indexKind.toString());
        return this;
    }
}

