/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos;

import com.azure.data.cosmos.JsonSerializable;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.apache.commons.lang3.StringUtils;

public class Resource
extends JsonSerializable {
    private String altLink;

    static void validateResource(Resource resource) {
        if (!StringUtils.isEmpty((CharSequence)resource.id())) {
            if (resource.id().indexOf(47) != -1 || resource.id().indexOf(92) != -1 || resource.id().indexOf(63) != -1 || resource.id().indexOf(35) != -1) {
                throw new IllegalArgumentException("Id contains illegal chars.");
            }
            if (resource.id().endsWith(" ")) {
                throw new IllegalArgumentException("Id ends with a space.");
            }
        }
    }

    protected Resource(Resource resource) {
        this.id(resource.id());
        this.resourceId(resource.resourceId());
        this.selfLink(resource.selfLink());
        this.altLink(resource.altLink());
        this.timestamp(resource.timestamp());
        this.etag(resource.etag());
    }

    protected Resource() {
    }

    Resource(ObjectNode objectNode) {
        super(objectNode);
    }

    Resource(String jsonString, ObjectMapper objectMapper) {
        super(jsonString, objectMapper);
    }

    protected Resource(String jsonString) {
        super(jsonString);
    }

    public String id() {
        return super.getString("id");
    }

    public Resource id(String id) {
        super.set("id", id);
        return this;
    }

    public String resourceId() {
        return super.getString("_rid");
    }

    public Resource resourceId(String resourceId) {
        super.set("_rid", resourceId);
        return this;
    }

    public String selfLink() {
        return super.getString("_self");
    }

    Resource selfLink(String selfLink) {
        super.set("_self", selfLink);
        return this;
    }

    public OffsetDateTime timestamp() {
        Long seconds = super.getLong("_ts");
        if (seconds == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(seconds), ZoneOffset.UTC);
    }

    Resource timestamp(OffsetDateTime timestamp) {
        long seconds = timestamp.toEpochSecond();
        super.set("_ts", seconds);
        return this;
    }

    public String etag() {
        return super.getString("_etag");
    }

    Resource etag(String eTag) {
        super.set("_etag", eTag);
        return this;
    }

    Resource altLink(String altLink) {
        this.altLink = altLink;
        return this;
    }

    String altLink() {
        return this.altLink;
    }
}

