/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.internal.BackoffRetryUtility;
import com.azure.data.cosmos.internal.IRetryPolicy;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ObservableHelper {
    public static <T> Mono<T> inlineIfPossible(Callable<Mono<T>> function, IRetryPolicy retryPolicy) {
        if (retryPolicy == null) {
            try {
                return function.call();
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }
        return BackoffRetryUtility.executeRetry(function, retryPolicy);
    }

    public static <T> Flux<T> inlineIfPossibleAsObs(Callable<Flux<T>> function, IRetryPolicy retryPolicy) {
        if (retryPolicy == null) {
            return Flux.defer(() -> {
                try {
                    return (Publisher)function.call();
                }
                catch (Exception e) {
                    return Flux.error((Throwable)e);
                }
            });
        }
        return BackoffRetryUtility.executeRetry(() -> ((Flux)function.call()).single(), retryPolicy).flux();
    }
}

