/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal;

import com.azure.data.cosmos.internal.BackoffRetryUtility;
import com.azure.data.cosmos.internal.IRetryPolicy;
import com.azure.data.cosmos.internal.Quadruple;
import com.azure.data.cosmos.internal.Utils;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.time.StopWatch;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RetryUtils {
    private static final Logger logger = LoggerFactory.getLogger(BackoffRetryUtility.class);

    static Function<Flux<Throwable>, Flux<Long>> toRetryWhenFunc(IRetryPolicy policy) {
        return throwableFlux -> throwableFlux.flatMap(t -> {
            Exception e = Utils.as(t, Exception.class);
            if (e == null) {
                return Flux.error((Throwable)t);
            }
            Flux shouldRetryResultFlux = policy.shouldRetry(e).flux();
            return shouldRetryResultFlux.flatMap(s -> {
                if (s.backOffTime != null) {
                    return Mono.delay((Duration)Duration.ofMillis(s.backOffTime.toMillis())).flux();
                }
                if (s.exception != null) {
                    return Flux.error((Throwable)s.exception);
                }
                return Flux.error((Throwable)t);
            });
        });
    }

    public static <T> Function<Throwable, Mono<T>> toRetryWithAlternateFunc(Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> callbackMethod, IRetryPolicy retryPolicy, Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> inBackoffAlternateCallbackMethod, Duration minBackoffForInBackoffCallback) {
        return throwable -> {
            Exception e = Utils.as(throwable, Exception.class);
            if (e == null) {
                return Mono.error((Throwable)throwable);
            }
            Flux shouldRetryResultFlux = retryPolicy.shouldRetry(e).flux();
            return shouldRetryResultFlux.flatMap(shouldRetryResult -> {
                if (!shouldRetryResult.shouldRetry) {
                    if (shouldRetryResult.exception == null) {
                        return Mono.error((Throwable)e);
                    }
                    return Mono.error((Throwable)shouldRetryResult.exception);
                }
                if (inBackoffAlternateCallbackMethod != null && shouldRetryResult.backOffTime.compareTo(minBackoffForInBackoffCallback) > 0) {
                    StopWatch stopwatch = new StopWatch();
                    RetryUtils.startStopWatch(stopwatch);
                    return ((Mono)inBackoffAlternateCallbackMethod.apply(shouldRetryResult.policyArg)).onErrorResume(RetryUtils.recurrsiveWithAlternateFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, shouldRetryResult, stopwatch, minBackoffForInBackoffCallback));
                }
                return RetryUtils.recurrsiveFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, shouldRetryResult, minBackoffForInBackoffCallback).delaySubscription(Duration.ofMillis(shouldRetryResult.backOffTime.toMillis()));
            }).single();
        };
    }

    private static <T> Mono<T> recurrsiveFunc(Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> callbackMethod, IRetryPolicy retryPolicy, Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> inBackoffAlternateCallbackMethod, IRetryPolicy.ShouldRetryResult shouldRetryResult, Duration minBackoffForInBackoffCallback) {
        return callbackMethod.apply(shouldRetryResult.policyArg).onErrorResume(RetryUtils.toRetryWithAlternateFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, minBackoffForInBackoffCallback));
    }

    private static <T> Function<Throwable, Mono<T>> recurrsiveWithAlternateFunc(Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> callbackMethod, IRetryPolicy retryPolicy, Function<Quadruple<Boolean, Boolean, Duration, Integer>, Mono<T>> inBackoffAlternateCallbackMethod, IRetryPolicy.ShouldRetryResult shouldRetryResult, StopWatch stopwatch, Duration minBackoffForInBackoffCallback) {
        return throwable -> {
            Exception e = Utils.as(throwable, Exception.class);
            if (e == null) {
                return Mono.error((Throwable)throwable);
            }
            RetryUtils.stopStopWatch(stopwatch);
            logger.info("Failed inBackoffAlternateCallback with {}, proceeding with retry. Time taken: {}ms", (Object)e.toString(), (Object)stopwatch.getTime());
            Duration backoffTime = shouldRetryResult.backOffTime.toMillis() > stopwatch.getTime() ? Duration.ofMillis(shouldRetryResult.backOffTime.toMillis() - stopwatch.getTime()) : Duration.ZERO;
            return RetryUtils.recurrsiveFunc(callbackMethod, retryPolicy, inBackoffAlternateCallbackMethod, shouldRetryResult, minBackoffForInBackoffCallback).delaySubscription((Publisher)Flux.just((Object)0L).delayElements(Duration.ofMillis(backoffTime.toMillis())));
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.start();
        }
    }
}

