/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity;

import com.azure.data.cosmos.BadRequestException;
import com.azure.data.cosmos.BridgeInternal;
import com.azure.data.cosmos.ConflictException;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.ForbiddenException;
import com.azure.data.cosmos.GoneException;
import com.azure.data.cosmos.InternalServerErrorException;
import com.azure.data.cosmos.InvalidPartitionException;
import com.azure.data.cosmos.LockedException;
import com.azure.data.cosmos.MethodNotAllowedException;
import com.azure.data.cosmos.NotFoundException;
import com.azure.data.cosmos.PartitionIsMigratingException;
import com.azure.data.cosmos.PartitionKeyRangeGoneException;
import com.azure.data.cosmos.PartitionKeyRangeIsSplittingException;
import com.azure.data.cosmos.PreconditionFailedException;
import com.azure.data.cosmos.RequestEntityTooLargeException;
import com.azure.data.cosmos.RequestRateTooLargeException;
import com.azure.data.cosmos.RequestTimeoutException;
import com.azure.data.cosmos.RetryWithException;
import com.azure.data.cosmos.ServiceUnavailableException;
import com.azure.data.cosmos.UnauthorizedException;
import com.azure.data.cosmos.internal.Configs;
import com.azure.data.cosmos.internal.Integers;
import com.azure.data.cosmos.internal.Lists;
import com.azure.data.cosmos.internal.Longs;
import com.azure.data.cosmos.internal.MutableVolatile;
import com.azure.data.cosmos.internal.OperationType;
import com.azure.data.cosmos.internal.PathsHelper;
import com.azure.data.cosmos.internal.ResourceType;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.UserAgentContainer;
import com.azure.data.cosmos.internal.Utils;
import com.azure.data.cosmos.internal.directconnectivity.ErrorUtils;
import com.azure.data.cosmos.internal.directconnectivity.HttpUtils;
import com.azure.data.cosmos.internal.directconnectivity.ResourceOperation;
import com.azure.data.cosmos.internal.directconnectivity.ResponseUtils;
import com.azure.data.cosmos.internal.directconnectivity.StoreResponse;
import com.azure.data.cosmos.internal.directconnectivity.TransportClient;
import com.azure.data.cosmos.internal.directconnectivity.WebExceptionUtility;
import com.azure.data.cosmos.internal.http.HttpClient;
import com.azure.data.cosmos.internal.http.HttpClientConfig;
import com.azure.data.cosmos.internal.http.HttpHeaders;
import com.azure.data.cosmos.internal.http.HttpRequest;
import com.azure.data.cosmos.internal.http.HttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class HttpTransportClient
extends TransportClient {
    private final Logger logger = LoggerFactory.getLogger(HttpTransportClient.class);
    private final HttpClient httpClient;
    private final Map<String, String> defaultHeaders;
    private final Configs configs;

    HttpClient createHttpClient(int requestTimeout) {
        HttpClientConfig httpClientConfig = new HttpClientConfig(this.configs);
        httpClientConfig.withRequestTimeoutInMillis(requestTimeout * 1000);
        httpClientConfig.withPoolSize(this.configs.getDirectHttpsMaxConnectionLimit());
        return HttpClient.createFixed(httpClientConfig);
    }

    public HttpTransportClient(Configs configs, int requestTimeout, UserAgentContainer userAgent) {
        this.configs = configs;
        this.httpClient = this.createHttpClient(requestTimeout);
        this.defaultHeaders = new HashMap<String, String>();
        this.defaultHeaders.put("x-ms-version", "2018-12-31");
        this.defaultHeaders.put("Cache-Control", "no-cache");
        if (userAgent == null) {
            userAgent = new UserAgentContainer();
        }
        this.defaultHeaders.put("User-Agent", userAgent.getUserAgent());
        this.defaultHeaders.put("Accept", "application/json");
    }

    @Override
    public void close() {
        this.httpClient.shutdown();
    }

    @Override
    public Mono<StoreResponse> invokeStoreAsync(URI physicalAddress, RxDocumentServiceRequest request) {
        try {
            ResourceOperation resourceOperation = new ResourceOperation(request.getOperationType(), request.getResourceType());
            UUID activityId = UUID.fromString(request.getActivityId());
            if (resourceOperation.operationType == OperationType.Recreate) {
                HashMap<String, String> errorResponseHeaders = new HashMap<String, String>();
                errorResponseHeaders.put("x-ms-request-validation-failure", "1");
                this.logger.error("Received Recreate request on Http client");
                throw new InternalServerErrorException("Unknown server error occurred when processing this request.", null, errorResponseHeaders, null);
            }
            HttpRequest httpRequest = this.prepareHttpMessage(activityId, physicalAddress, resourceOperation, request);
            MutableVolatile sendTimeUtc = new MutableVolatile();
            Mono httpResponseMono = this.httpClient.send(httpRequest).doOnSubscribe(subscription -> {
                sendTimeUtc.v = Instant.now();
                this.beforeRequest(activityId, httpRequest.uri(), request.getResourceType(), httpRequest.headers());
            }).onErrorResume(t -> {
                Exception exception = Utils.as(t, Exception.class);
                if (exception == null) {
                    this.logger.error("critical failure", t);
                    t.printStackTrace();
                    assert (false) : "critical failure";
                    return Mono.error((Throwable)t);
                }
                if (WebExceptionUtility.isWebExceptionRetriable(exception)) {
                    this.logger.debug("Received retriable exception {} sending the request to {}, will re-resolve the address send time UTC: {}", new Object[]{exception, physicalAddress, sendTimeUtc});
                    GoneException goneException = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), exception, null, physicalAddress);
                    return Mono.error((Throwable)goneException);
                }
                if (request.isReadOnlyRequest()) {
                    this.logger.trace("Received exception {} on readonly requestsending the request to {}, will reresolve the address send time UTC: {}", new Object[]{exception, physicalAddress, sendTimeUtc});
                    GoneException goneException = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), exception, null, physicalAddress);
                    return Mono.error((Throwable)goneException);
                }
                ServiceUnavailableException serviceUnavailableException = new ServiceUnavailableException(String.format("Message: %s", "Service is currently unavailable, please retry after a while. If this problem persists please contact support."), exception, null, physicalAddress.toString());
                serviceUnavailableException.responseHeaders().put("x-ms-request-validation-failure", "1");
                serviceUnavailableException.responseHeaders().put("x-ms-write-request-trigger-refresh", "1");
                return Mono.error((Throwable)serviceUnavailableException);
            }).doOnSuccess(httpClientResponse -> {
                Instant receivedTimeUtc = Instant.now();
                double durationInMilliSeconds = receivedTimeUtc.toEpochMilli() - ((Instant)sendTimeUtc.v).toEpochMilli();
                this.afterRequest(activityId, httpClientResponse.statusCode(), durationInMilliSeconds, httpClientResponse.headers());
            }).doOnError(e -> {
                Instant receivedTimeUtc = Instant.now();
                double durationInMilliSeconds = receivedTimeUtc.toEpochMilli() - ((Instant)sendTimeUtc.v).toEpochMilli();
                this.afterRequest(activityId, 0, durationInMilliSeconds, null);
            });
            return httpResponseMono.flatMap(rsp -> this.processHttpResponse(request.getResourceAddress(), httpRequest, activityId.toString(), (HttpResponse)rsp, physicalAddress));
        }
        catch (Exception e2) {
            return Mono.error((Throwable)e2);
        }
    }

    private void beforeRequest(UUID activityId, URI uri, ResourceType resourceType, HttpHeaders requestHeaders) {
    }

    private void afterRequest(UUID activityId, int statusCode, double durationInMilliSeconds, HttpHeaders responseHeaders) {
    }

    private static void addHeader(HttpHeaders requestHeaders, String headerName, RxDocumentServiceRequest request) {
        String headerValue = request.getHeaders().get(headerName);
        if (!Strings.isNullOrEmpty(headerValue)) {
            requestHeaders.set(headerName, headerValue);
        }
    }

    private static void addHeader(HttpHeaders requestHeaders, String headerName, String headerValue) {
        if (!Strings.isNullOrEmpty(headerValue)) {
            requestHeaders.set(headerName, headerValue);
        }
    }

    private String getMatch(RxDocumentServiceRequest request, ResourceOperation resourceOperation) {
        switch (resourceOperation.operationType) {
            case Delete: 
            case ExecuteJavaScript: 
            case Replace: 
            case Update: 
            case Upsert: {
                return request.getHeaders().get("If-Match");
            }
            case Read: 
            case ReadFeed: {
                return request.getHeaders().get("If-NONE-Match");
            }
        }
        return null;
    }

    private HttpRequest prepareHttpMessage(UUID activityId, URI physicalAddress, ResourceOperation resourceOperation, RxDocumentServiceRequest request) throws Exception {
        HttpRequest httpRequestMessage;
        switch (resourceOperation.operationType) {
            case Create: {
                URI requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContent() != null);
                httpRequestMessage = new HttpRequest(method, requestUri.toString(), physicalAddress.getPort());
                httpRequestMessage.withBody(request.getContent());
                break;
            }
            case ExecuteJavaScript: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContent() != null);
                httpRequestMessage = new HttpRequest(method, requestUri.toString(), physicalAddress.getPort());
                httpRequestMessage.withBody(request.getContent());
                break;
            }
            case Delete: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.DELETE;
                httpRequestMessage = new HttpRequest(method, requestUri.toString(), physicalAddress.getPort());
                break;
            }
            case Read: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.GET;
                httpRequestMessage = new HttpRequest(method, requestUri.toString(), physicalAddress.getPort());
                break;
            }
            case ReadFeed: {
                URI requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.GET;
                httpRequestMessage = new HttpRequest(method, requestUri.toString(), physicalAddress.getPort());
                break;
            }
            case Replace: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.PUT;
                assert (request.getContent() != null);
                httpRequestMessage = new HttpRequest(method, requestUri.toString(), physicalAddress.getPort());
                httpRequestMessage.withBody(request.getContent());
                break;
            }
            case Update: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = new HttpMethod("PATCH");
                assert (request.getContent() != null);
                httpRequestMessage = new HttpRequest(method, requestUri.toString(), physicalAddress.getPort());
                httpRequestMessage.withBody(request.getContent());
                break;
            }
            case Query: 
            case SqlQuery: {
                URI requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContent() != null);
                httpRequestMessage = new HttpRequest(method, requestUri.toString(), physicalAddress.getPort());
                httpRequestMessage.withBody(request.getContent());
                HttpTransportClient.addHeader(httpRequestMessage.headers(), "Content-Type", request);
                break;
            }
            case Upsert: {
                URI requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.POST;
                assert (request.getContent() != null);
                httpRequestMessage = new HttpRequest(method, requestUri.toString(), physicalAddress.getPort());
                httpRequestMessage.withBody(request.getContent());
                break;
            }
            case Head: {
                URI requestUri = HttpTransportClient.getResourceEntryUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.HEAD;
                httpRequestMessage = new HttpRequest(method, requestUri.toString(), physicalAddress.getPort());
                break;
            }
            case HeadFeed: {
                URI requestUri = HttpTransportClient.getResourceFeedUri(resourceOperation.resourceType, physicalAddress, request);
                HttpMethod method = HttpMethod.HEAD;
                httpRequestMessage = new HttpRequest(method, requestUri.toString(), physicalAddress.getPort());
                break;
            }
            default: {
                assert (false) : "Unsupported operation type";
                throw new IllegalStateException();
            }
        }
        Map<String, String> documentServiceRequestHeaders = request.getHeaders();
        HttpHeaders httpRequestHeaders = httpRequestMessage.headers();
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            HttpTransportClient.addHeader(httpRequestHeaders, entry.getKey(), entry.getValue());
        }
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-version", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "User-Agent", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-max-item-count", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-pre-trigger-include", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-pre-trigger-exclude", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-post-trigger-include", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-post-trigger-exclude", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "authorization", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-indexing-directive", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-migratecollection-directive", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-consistency-level", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-session-token", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "Prefer", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-expiry-seconds", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query-enable-scan", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query-emit-traces", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-cancharge", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-canthrottle", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query-enable-low-precision-order-by", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-script-enable-logging", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-is-readonly-script", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-content-serialization-format", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-continuation", request.getContinuation());
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-activity-id", activityId.toString());
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-partitionkey", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-partitionkeyrangeid", request);
        String dateHeader = HttpUtils.getDateHeader(documentServiceRequestHeaders);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-date", dateHeader);
        HttpTransportClient.addHeader(httpRequestHeaders, "Match", this.getMatch(request, resourceOperation));
        HttpTransportClient.addHeader(httpRequestHeaders, "If-Modified-Since", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "A-IM", request);
        if (!request.getIsNameBased()) {
            HttpTransportClient.addHeader(httpRequestHeaders, "x-docdb-resource-id", request.getResourceId());
        }
        HttpTransportClient.addHeader(httpRequestHeaders, "x-docdb-entity-id", request.entityId);
        String fanoutRequestHeader = request.getHeaders().get("x-ms-is-fanout-request");
        HttpTransportClient.addHeader(httpRequestMessage.headers(), "x-ms-is-fanout-request", fanoutRequestHeader);
        if (request.getResourceType() == ResourceType.DocumentCollection) {
            HttpTransportClient.addHeader(httpRequestHeaders, "collection-partition-index", documentServiceRequestHeaders.get("collection-partition-index"));
            HttpTransportClient.addHeader(httpRequestHeaders, "collection-service-index", documentServiceRequestHeaders.get("collection-service-index"));
        }
        if (documentServiceRequestHeaders.get("x-ms-bind-replica") != null) {
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-bind-replica", documentServiceRequestHeaders.get("x-ms-bind-replica"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-primary-master-key", documentServiceRequestHeaders.get("x-ms-primary-master-key"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-secondary-master-key", documentServiceRequestHeaders.get("x-ms-secondary-master-key"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-primary-readonly-key", documentServiceRequestHeaders.get("x-ms-primary-readonly-key"));
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-secondary-readonly-key", documentServiceRequestHeaders.get("x-ms-secondary-readonly-key"));
        }
        if (documentServiceRequestHeaders.get("x-ms-can-offer-replace-complete") != null) {
            HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-can-offer-replace-complete", documentServiceRequestHeaders.get("x-ms-can-offer-replace-complete"));
        }
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-isquery", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-query", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-is-upsert", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-supportspatiallegacycoordinates", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-partitioncount", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-collection-rid", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-filterby-schema-rid", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-usepolygonssmallerthanahemisphere", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-gateway-signature", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatequotainfo", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatequerymetrics", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-force-query-scan", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-responsecontinuationtokenlimitinkb", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-remote-storage-type", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-share-throughput", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatepartitionstatistics", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-documentdb-populatecollectionthroughputinfo", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-remaining-time-in-ms-on-client", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-client-retry-attempt-count", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-target-lsn", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-target-global-committed-lsn", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-federation-for-auth", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-fanout-operation-state", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-cosmos-allow-tentative-writes", request);
        HttpTransportClient.addHeader(httpRequestHeaders, "x-ms-exclude-system-properties", request);
        return httpRequestMessage;
    }

    static URI getResourceFeedUri(ResourceType resourceType, URI physicalAddress, RxDocumentServiceRequest request) throws Exception {
        switch (resourceType) {
            case Attachment: {
                return HttpTransportClient.getAttachmentFeedUri(physicalAddress, request);
            }
            case DocumentCollection: {
                return HttpTransportClient.getCollectionFeedUri(physicalAddress, request);
            }
            case Conflict: {
                return HttpTransportClient.getConflictFeedUri(physicalAddress, request);
            }
            case Database: {
                return HttpTransportClient.getDatabaseFeedUri(physicalAddress);
            }
            case Document: {
                return HttpTransportClient.getDocumentFeedUri(physicalAddress, request);
            }
            case Permission: {
                return HttpTransportClient.getPermissionFeedUri(physicalAddress, request);
            }
            case StoredProcedure: {
                return HttpTransportClient.getStoredProcedureFeedUri(physicalAddress, request);
            }
            case Trigger: {
                return HttpTransportClient.getTriggerFeedUri(physicalAddress, request);
            }
            case User: {
                return HttpTransportClient.getUserFeedUri(physicalAddress, request);
            }
            case UserDefinedFunction: {
                return HttpTransportClient.getUserDefinedFunctionFeedUri(physicalAddress, request);
            }
            case Schema: {
                return HttpTransportClient.getSchemaFeedUri(physicalAddress, request);
            }
            case Offer: {
                return HttpTransportClient.getOfferFeedUri(physicalAddress, request);
            }
        }
        assert (false) : "Unexpected resource type: " + (Object)((Object)resourceType);
        throw new NotFoundException();
    }

    private static URI getResourceEntryUri(ResourceType resourceType, URI physicalAddress, RxDocumentServiceRequest request) throws Exception {
        switch (resourceType) {
            case Attachment: {
                return HttpTransportClient.getAttachmentEntryUri(physicalAddress, request);
            }
            case DocumentCollection: {
                return HttpTransportClient.getCollectionEntryUri(physicalAddress, request);
            }
            case Conflict: {
                return HttpTransportClient.getConflictEntryUri(physicalAddress, request);
            }
            case Database: {
                return HttpTransportClient.getDatabaseEntryUri(physicalAddress, request);
            }
            case Document: {
                return HttpTransportClient.getDocumentEntryUri(physicalAddress, request);
            }
            case Permission: {
                return HttpTransportClient.getPermissionEntryUri(physicalAddress, request);
            }
            case StoredProcedure: {
                return HttpTransportClient.getStoredProcedureEntryUri(physicalAddress, request);
            }
            case Trigger: {
                return HttpTransportClient.getTriggerEntryUri(physicalAddress, request);
            }
            case User: {
                return HttpTransportClient.getUserEntryUri(physicalAddress, request);
            }
            case UserDefinedFunction: {
                return HttpTransportClient.getUserDefinedFunctionEntryUri(physicalAddress, request);
            }
            case Schema: {
                return HttpTransportClient.getSchemaEntryUri(physicalAddress, request);
            }
            case Offer: {
                return HttpTransportClient.getOfferEntryUri(physicalAddress, request);
            }
        }
        assert (false) : "Unexpected resource type: " + (Object)((Object)resourceType);
        throw new IllegalStateException();
    }

    private static URI createURI(URI baseAddress, String resourcePath) {
        return baseAddress.resolve(HttpUtils.urlEncode(Utils.trimBeginningAndEndingSlashes(resourcePath)));
    }

    static URI getRootFeedUri(URI baseAddress) {
        return baseAddress;
    }

    private static URI getDatabaseFeedUri(URI baseAddress) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Database, "", true));
    }

    private static URI getDatabaseEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Database, request, false));
    }

    private static URI getCollectionFeedUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.DocumentCollection, request, true));
    }

    private static URI getStoredProcedureFeedUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.StoredProcedure, request, true));
    }

    private static URI getTriggerFeedUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Trigger, request, true));
    }

    private static URI getUserDefinedFunctionFeedUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.UserDefinedFunction, request, true));
    }

    private static URI getCollectionEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.DocumentCollection, request, false));
    }

    private static URI getStoredProcedureEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.StoredProcedure, request, false));
    }

    private static URI getTriggerEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Trigger, request, false));
    }

    private static URI getUserDefinedFunctionEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.UserDefinedFunction, request, false));
    }

    private static URI getDocumentFeedUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Document, request, true));
    }

    private static URI getDocumentEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Document, request, false));
    }

    private static URI getConflictFeedUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Conflict, request, true));
    }

    private static URI getConflictEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Conflict, request, false));
    }

    private static URI getAttachmentFeedUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Attachment, request, true));
    }

    private static URI getAttachmentEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Attachment, request, false));
    }

    private static URI getUserFeedUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.User, request, true));
    }

    private static URI getUserEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.User, request, false));
    }

    private static URI getPermissionFeedUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Permission, request, true));
    }

    private static URI getPermissionEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Permission, request, false));
    }

    private static URI getOfferFeedUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Offer, request, true));
    }

    private static URI getSchemaFeedUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Schema, request, true));
    }

    private static URI getSchemaEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Schema, request, false));
    }

    private static URI getOfferEntryUri(URI baseAddress, RxDocumentServiceRequest request) {
        return HttpTransportClient.createURI(baseAddress, PathsHelper.generatePath(ResourceType.Offer, request, false));
    }

    static String getHeader(String[] names, String[] values, String name) {
        for (int idx = 0; idx < names.length; ++idx) {
            if (!Strings.areEqual(names[idx], name)) continue;
            return values[idx];
        }
        return null;
    }

    private Mono<StoreResponse> processHttpResponse(String resourceAddress, HttpRequest httpRequest, String activityId, HttpResponse response, URI physicalAddress) {
        if (response == null) {
            InternalServerErrorException exception = new InternalServerErrorException(String.format("Message: %s", "The backend response was not in the correct format."), null, physicalAddress);
            exception.responseHeaders().put("x-ms-activity-id", activityId);
            exception.responseHeaders().put("x-ms-request-validation-failure", "1");
            return Mono.error((Throwable)exception);
        }
        if (response.statusCode() < 400 || response.statusCode() == 304) {
            return ResponseUtils.toStoreResponse(response, httpRequest);
        }
        return this.createErrorResponseFromHttpResponse(resourceAddress, activityId, httpRequest, response);
    }

    private Mono<StoreResponse> createErrorResponseFromHttpResponse(String resourceAddress, String activityId, HttpRequest request, HttpResponse response) {
        int statusCode = response.statusCode();
        Mono<String> errorMessageObs = ErrorUtils.getErrorResponseAsync(response, request);
        return errorMessageObs.flatMap(errorMessage -> {
            CosmosClientException exception;
            long responseLSN = -1L;
            ArrayList lsnValues = null;
            Object[] headerValues = response.headers().values("lsn");
            if (headerValues != null) {
                lsnValues = com.google.common.collect.Lists.newArrayList((Object[])headerValues);
            }
            if (lsnValues != null) {
                String temp = lsnValues.isEmpty() ? null : (String)lsnValues.get(0);
                responseLSN = Longs.tryParse(temp, responseLSN);
            }
            String responsePartitionKeyRangeId = null;
            ArrayList partitionKeyRangeIdValues = null;
            headerValues = response.headers().values("x-ms-documentdb-partitionkeyrangeid");
            if (headerValues != null) {
                partitionKeyRangeIdValues = com.google.common.collect.Lists.newArrayList((Object[])headerValues);
            }
            if (partitionKeyRangeIdValues != null) {
                responsePartitionKeyRangeId = Lists.firstOrDefault(partitionKeyRangeIdValues, null);
            }
            switch (statusCode) {
                case 401: {
                    exception = new UnauthorizedException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Unable to authenticate the request. The request requires valid user authentication." : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 403: {
                    exception = new ForbiddenException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Unable to proceed with the request. Please check the authorization claims to ensure the required permissions to process the request." : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 404: {
                    if (response.body() != null && response.headers() != null && response.headers().value("Content-Type") != null && !Strings.isNullOrEmpty(response.headers().value("Content-Type")) && Strings.containsIgnoreCase(response.headers().value("Content-Type"), "text/html")) {
                        exception = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), request.uri().toString());
                        exception.responseHeaders().put("x-ms-activity-id", activityId);
                        break;
                    }
                    exception = new NotFoundException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Entity with the specified id does not exist in the system." : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 400: {
                    exception = new BadRequestException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "One of the input values is invalid." : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 405: {
                    exception = new MethodNotAllowedException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The requested verb is not supported." : errorMessage), null, response.headers(), request.uri().toString());
                    break;
                }
                case 410: {
                    ErrorUtils.logGoneException(request.uri(), activityId);
                    Integer nSubStatus = 0;
                    String valueSubStatus = response.headers().value("x-ms-substatus");
                    if (!Strings.isNullOrEmpty(valueSubStatus) && (nSubStatus = Integers.tryParse(valueSubStatus)) == null) {
                        exception = new InternalServerErrorException(String.format("Message: %s", "The backend response was not in the correct format."), response.headers(), request.uri());
                        break;
                    }
                    if (nSubStatus == 1000) {
                        exception = new InvalidPartitionException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.headers(), request.uri().toString());
                        break;
                    }
                    if (nSubStatus == 1002) {
                        exception = new PartitionKeyRangeGoneException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.headers(), request.uri().toString());
                        break;
                    }
                    if (nSubStatus == 1007) {
                        exception = new PartitionKeyRangeIsSplittingException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.headers(), request.uri().toString());
                        break;
                    }
                    if (nSubStatus == 1008) {
                        exception = new PartitionIsMigratingException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The requested resource is no longer available at the server." : errorMessage), response.headers(), request.uri().toString());
                        break;
                    }
                    exception = new GoneException(String.format("Message: %s", "The requested resource is no longer available at the server."), response.headers(), request.uri());
                    exception.responseHeaders().put("x-ms-activity-id", activityId);
                    break;
                }
                case 409: {
                    exception = new ConflictException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Entity with the specified id already exists in the system." : errorMessage), response.headers(), request.uri().toString());
                    break;
                }
                case 412: {
                    exception = new PreconditionFailedException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Operation cannot be performed because one of the specified precondition is not met." : errorMessage), response.headers(), request.uri().toString());
                    break;
                }
                case 413: {
                    exception = new RequestEntityTooLargeException(String.format("Message: %s", String.format("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.", "x-ms-max-item-count")), response.headers(), request.uri().toString());
                    break;
                }
                case 423: {
                    exception = new LockedException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "" : errorMessage), response.headers(), request.uri().toString());
                    break;
                }
                case 503: {
                    exception = new ServiceUnavailableException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Service is currently unavailable, please retry after a while. If this problem persists please contact support." : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 408: {
                    exception = new RequestTimeoutException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Request timed out." : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 449: {
                    exception = new RetryWithException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Retry the request." : errorMessage), response.headers(), request.uri());
                    break;
                }
                case 429: {
                    exception = new RequestRateTooLargeException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "The request rate is too large. Please retry after sometime." : errorMessage), response.headers(), request.uri());
                    ArrayList values = null;
                    headerValues = response.headers().values("x-ms-retry-after-ms");
                    if (headerValues != null) {
                        values = com.google.common.collect.Lists.newArrayList((Object[])headerValues);
                    }
                    if (values == null || values.isEmpty()) {
                        this.logger.warn("RequestRateTooLargeException being thrown without RetryAfter.");
                        break;
                    }
                    exception.responseHeaders().put("x-ms-retry-after-ms", (String)values.get(0));
                    break;
                }
                case 500: {
                    exception = new InternalServerErrorException(String.format("Message: %s", Strings.isNullOrEmpty(errorMessage) ? "Unknown server error occurred when processing this request." : errorMessage), response.headers(), request.uri());
                    break;
                }
                default: {
                    this.logger.error("Unrecognized status code {} returned by backend. ActivityId {}", (Object)statusCode, (Object)activityId);
                    ErrorUtils.logException(request.uri(), activityId);
                    exception = new InternalServerErrorException(String.format("Message: %s", "The backend response was not in the correct format."), response.headers(), request.uri());
                }
            }
            BridgeInternal.setLSN(exception, responseLSN);
            BridgeInternal.setPartitionKeyRangeId(exception, responsePartitionKeyRangeId);
            BridgeInternal.setResourceAddress(exception, resourceAddress);
            BridgeInternal.setRequestHeaders(exception, HttpUtils.asMap(request.headers()));
            return Mono.error((Throwable)exception);
        });
    }
}

