/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity;

import com.azure.data.cosmos.BadRequestException;
import com.azure.data.cosmos.ConsistencyLevel;
import com.azure.data.cosmos.CosmosClientException;
import com.azure.data.cosmos.internal.RxDocumentServiceRequest;
import com.azure.data.cosmos.internal.Strings;
import com.azure.data.cosmos.internal.directconnectivity.GatewayServiceConfigurationReader;
import org.apache.commons.lang3.EnumUtils;

public class RequestHelper {
    public static ConsistencyLevel GetConsistencyLevelToUse(GatewayServiceConfigurationReader serviceConfigReader, RxDocumentServiceRequest request) throws CosmosClientException {
        ConsistencyLevel consistencyLevelToUse = serviceConfigReader.getDefaultConsistencyLevel();
        String requestConsistencyLevelHeaderValue = request.getHeaders().get("x-ms-consistency-level");
        if (!Strings.isNullOrEmpty(requestConsistencyLevelHeaderValue)) {
            ConsistencyLevel requestConsistencyLevel = (ConsistencyLevel)EnumUtils.getEnum(ConsistencyLevel.class, (String)Strings.fromCamelCaseToUpperCase(requestConsistencyLevelHeaderValue));
            if (requestConsistencyLevel == null) {
                throw new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid.", requestConsistencyLevelHeaderValue, "x-ms-consistency-level"));
            }
            consistencyLevelToUse = requestConsistencyLevel;
        }
        return consistencyLevelToUse;
    }
}

