/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdContext;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdContextException;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdFramer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RntbdContextDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(RntbdContextDecoder.class);

    RntbdContextDecoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        if (RntbdFramer.canDecodeHead(in)) {
            Object result;
            try {
                RntbdContext rntbdContext = RntbdContext.decode(in);
                context.fireUserEventTriggered((Object)rntbdContext);
                result = rntbdContext;
            }
            catch (RntbdContextException error) {
                context.fireUserEventTriggered((Object)error);
                result = error;
            }
            finally {
                in.discardReadBytes();
            }
            logger.debug("{} DECODE COMPLETE: {}", (Object)context.channel(), result);
        }
    }
}

