/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdConstants;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdContext;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdToken;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdTokenStream;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.CorruptedFrameException;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;

@JsonFilter(value="RntbdToken")
class RntbdResponseHeaders
extends RntbdTokenStream<RntbdConstants.RntbdResponseHeader> {
    @JsonProperty
    private final RntbdToken LSN = this.get(RntbdConstants.RntbdResponseHeader.LSN);
    @JsonProperty
    private final RntbdToken collectionLazyIndexProgress = this.get(RntbdConstants.RntbdResponseHeader.CollectionLazyIndexProgress);
    @JsonProperty
    private final RntbdToken collectionPartitionIndex = this.get(RntbdConstants.RntbdResponseHeader.CollectionPartitionIndex);
    @JsonProperty
    private final RntbdToken collectionSecurityIdentifier = this.get(RntbdConstants.RntbdResponseHeader.CollectionSecurityIdentifier);
    @JsonProperty
    private final RntbdToken collectionServiceIndex = this.get(RntbdConstants.RntbdResponseHeader.CollectionServiceIndex);
    @JsonProperty
    private final RntbdToken collectionUpdateProgress = this.get(RntbdConstants.RntbdResponseHeader.CollectionUpdateProgress);
    @JsonProperty
    private final RntbdToken continuationToken = this.get(RntbdConstants.RntbdResponseHeader.ContinuationToken);
    @JsonProperty
    private final RntbdToken currentReplicaSetSize = this.get(RntbdConstants.RntbdResponseHeader.CurrentReplicaSetSize);
    @JsonProperty
    private final RntbdToken currentWriteQuorum = this.get(RntbdConstants.RntbdResponseHeader.CurrentWriteQuorum);
    @JsonProperty
    private final RntbdToken databaseAccountId = this.get(RntbdConstants.RntbdResponseHeader.DatabaseAccountId);
    @JsonProperty
    private final RntbdToken disableRntbdChannel = this.get(RntbdConstants.RntbdResponseHeader.DisableRntbdChannel);
    @JsonProperty
    private final RntbdToken eTag = this.get(RntbdConstants.RntbdResponseHeader.ETag);
    @JsonProperty
    private final RntbdToken globalCommittedLSN = this.get(RntbdConstants.RntbdResponseHeader.GlobalCommittedLSN);
    @JsonProperty
    private final RntbdToken hasTentativeWrites = this.get(RntbdConstants.RntbdResponseHeader.HasTentativeWrites);
    @JsonProperty
    private final RntbdToken indexTermsGenerated = this.get(RntbdConstants.RntbdResponseHeader.IndexTermsGenerated);
    @JsonProperty
    private final RntbdToken indexingDirective = this.get(RntbdConstants.RntbdResponseHeader.IndexingDirective);
    @JsonProperty
    private final RntbdToken isRUPerMinuteUsed = this.get(RntbdConstants.RntbdResponseHeader.IsRUPerMinuteUsed);
    @JsonProperty
    private final RntbdToken itemCount = this.get(RntbdConstants.RntbdResponseHeader.ItemCount);
    @JsonProperty
    private final RntbdToken itemLSN = this.get(RntbdConstants.RntbdResponseHeader.ItemLSN);
    @JsonProperty
    private final RntbdToken itemLocalLSN = this.get(RntbdConstants.RntbdResponseHeader.ItemLocalLSN);
    @JsonProperty
    private final RntbdToken lastStateChangeDateTime = this.get(RntbdConstants.RntbdResponseHeader.LastStateChangeDateTime);
    @JsonProperty
    private final RntbdToken localLSN = this.get(RntbdConstants.RntbdResponseHeader.LocalLSN);
    @JsonProperty
    private final RntbdToken logResults = this.get(RntbdConstants.RntbdResponseHeader.LogResults);
    @JsonProperty
    private final RntbdToken numberOfReadRegions = this.get(RntbdConstants.RntbdResponseHeader.NumberOfReadRegions);
    @JsonProperty
    private final RntbdToken offerReplacePending = this.get(RntbdConstants.RntbdResponseHeader.OfferReplacePending);
    @JsonProperty
    private final RntbdToken ownerFullName = this.get(RntbdConstants.RntbdResponseHeader.OwnerFullName);
    @JsonProperty
    private final RntbdToken ownerId = this.get(RntbdConstants.RntbdResponseHeader.OwnerId);
    @JsonProperty
    private final RntbdToken partitionKeyRangeId = this.get(RntbdConstants.RntbdResponseHeader.PartitionKeyRangeId);
    @JsonProperty
    private final RntbdToken payloadPresent = this.get(RntbdConstants.RntbdResponseHeader.PayloadPresent);
    @JsonProperty
    private final RntbdToken queriesPerformed = this.get(RntbdConstants.RntbdResponseHeader.QueriesPerformed);
    @JsonProperty
    private final RntbdToken queryMetrics = this.get(RntbdConstants.RntbdResponseHeader.QueryMetrics);
    @JsonProperty
    private final RntbdToken quorumAckedLSN = this.get(RntbdConstants.RntbdResponseHeader.QuorumAckedLSN);
    @JsonProperty
    private final RntbdToken quorumAckedLocalLSN = this.get(RntbdConstants.RntbdResponseHeader.QuorumAckedLocalLSN);
    @JsonProperty
    private final RntbdToken readsPerformed = this.get(RntbdConstants.RntbdResponseHeader.ReadsPerformed);
    @JsonProperty
    private final RntbdToken requestCharge = this.get(RntbdConstants.RntbdResponseHeader.RequestCharge);
    @JsonProperty
    private final RntbdToken requestValidationFailure = this.get(RntbdConstants.RntbdResponseHeader.RequestValidationFailure);
    @JsonProperty
    private final RntbdToken restoreState = this.get(RntbdConstants.RntbdResponseHeader.RestoreState);
    @JsonProperty
    private final RntbdToken retryAfterMilliseconds = this.get(RntbdConstants.RntbdResponseHeader.RetryAfterMilliseconds);
    @JsonProperty
    private final RntbdToken schemaVersion = this.get(RntbdConstants.RntbdResponseHeader.SchemaVersion);
    @JsonProperty
    private final RntbdToken scriptsExecuted = this.get(RntbdConstants.RntbdResponseHeader.ScriptsExecuted);
    @JsonProperty
    private final RntbdToken serverDateTimeUtc = this.get(RntbdConstants.RntbdResponseHeader.ServerDateTimeUtc);
    @JsonProperty
    private final RntbdToken sessionToken = this.get(RntbdConstants.RntbdResponseHeader.SessionToken);
    @JsonProperty
    private final RntbdToken shareThroughput = this.get(RntbdConstants.RntbdResponseHeader.ShareThroughput);
    @JsonProperty
    private final RntbdToken storageMaxResoureQuota = this.get(RntbdConstants.RntbdResponseHeader.StorageMaxResoureQuota);
    @JsonProperty
    private final RntbdToken storageResourceQuotaUsage = this.get(RntbdConstants.RntbdResponseHeader.StorageResourceQuotaUsage);
    @JsonProperty
    private final RntbdToken subStatus = this.get(RntbdConstants.RntbdResponseHeader.SubStatus);
    @JsonProperty
    private final RntbdToken transportRequestID = this.get(RntbdConstants.RntbdResponseHeader.TransportRequestID);
    @JsonProperty
    private final RntbdToken writesPerformed = this.get(RntbdConstants.RntbdResponseHeader.WritesPerformed);
    @JsonProperty
    private final RntbdToken xpRole = this.get(RntbdConstants.RntbdResponseHeader.XPRole);

    private RntbdResponseHeaders(ByteBuf in) {
        super(RntbdConstants.RntbdResponseHeader.set, RntbdConstants.RntbdResponseHeader.map, in);
    }

    boolean isPayloadPresent() {
        return this.payloadPresent.isPresent() && this.payloadPresent.getValue(Byte.class) != 0;
    }

    List<Map.Entry<String, String>> asList(RntbdContext context, UUID activityId) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.computeCount() + 2));
        builder.add((Object)new Entry("x-ms-serviceversion", context.serverVersion()));
        builder.add((Object)new Entry("x-ms-activity-id", activityId.toString()));
        this.collectEntries((token, toEntry) -> {
            if (token.isPresent()) {
                builder.add((Object)((Map.Entry)toEntry.apply(token)));
            }
        });
        return builder.build();
    }

    public Map<String, String> asMap(RntbdContext context, UUID activityId) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)(this.computeCount() + 2));
        builder.put((Map.Entry)new Entry("x-ms-serviceversion", context.serverVersion()));
        builder.put((Map.Entry)new Entry("x-ms-activity-id", activityId.toString()));
        this.collectEntries((token, toEntry) -> {
            if (token.isPresent()) {
                builder.put((Map.Entry)toEntry.apply(token));
            }
        });
        return builder.build();
    }

    static RntbdResponseHeaders decode(ByteBuf in) {
        RntbdResponseHeaders headers = new RntbdResponseHeaders(in);
        RntbdTokenStream.decode(headers);
        return headers;
    }

    public static RntbdResponseHeaders fromMap(Map<String, String> map, boolean payloadPresent) {
        RntbdResponseHeaders headers = new RntbdResponseHeaders(Unpooled.EMPTY_BUFFER);
        headers.payloadPresent.setValue(payloadPresent);
        headers.setValues(map);
        return headers;
    }

    public void setValues(Map<String, String> headers) {
        this.mapValue(this.LSN, "lsn", Long::parseLong, headers);
        this.mapValue(this.collectionLazyIndexProgress, "x-ms-documentdb-collection-lazy-indexing-progress", Integer::parseInt, headers);
        this.mapValue(this.collectionLazyIndexProgress, "collection-partition-index", Integer::parseInt, headers);
        this.mapValue(this.collectionSecurityIdentifier, "x-ms-collection-security-identifier", String::toString, headers);
        this.mapValue(this.collectionServiceIndex, "collection-service-index", Integer::parseInt, headers);
        this.mapValue(this.collectionUpdateProgress, "x-ms-documentdb-collection-index-transformation-progress", Integer::parseInt, headers);
        this.mapValue(this.continuationToken, "x-ms-continuation", String::toString, headers);
        this.mapValue(this.currentReplicaSetSize, "x-ms-current-replica-set-size", Integer::parseInt, headers);
        this.mapValue(this.currentWriteQuorum, "x-ms-current-write-quorum", Integer::parseInt, headers);
        this.mapValue(this.databaseAccountId, "x-ms-database-account-id", String::toString, headers);
        this.mapValue(this.disableRntbdChannel, "x-ms-disable-rntbd-channel", Boolean::parseBoolean, headers);
        this.mapValue(this.eTag, "etag", String::toString, headers);
        this.mapValue(this.globalCommittedLSN, "x-ms-global-Committed-lsn", Long::parseLong, headers);
        this.mapValue(this.hasTentativeWrites, "x-ms-cosmosdb-has-tentative-writes", Boolean::parseBoolean, headers);
        this.mapValue(this.indexingDirective, "x-ms-indexing-directive", RntbdConstants.RntbdIndexingDirective::valueOf, headers);
        this.mapValue(this.isRUPerMinuteUsed, "x-ms-documentdb-is-ru-per-minute-used", Byte::parseByte, headers);
        this.mapValue(this.itemCount, "x-ms-item-count", Integer::parseInt, headers);
        this.mapValue(this.itemLSN, "x-ms-item-lsn", Long::parseLong, headers);
        this.mapValue(this.itemLocalLSN, "x-ms-cosmos-item-llsn", Long::parseLong, headers);
        this.mapValue(this.lastStateChangeDateTime, "x-ms-last-state-change-utc", String::toString, headers);
        this.mapValue(this.lastStateChangeDateTime, "x-ms-last-state-change-utc", String::toString, headers);
        this.mapValue(this.localLSN, "x-ms-cosmos-llsn", Long::parseLong, headers);
        this.mapValue(this.logResults, "x-ms-documentdb-script-log-results", String::toString, headers);
        this.mapValue(this.numberOfReadRegions, "x-ms-number-of-read-regions", Integer::parseInt, headers);
        this.mapValue(this.offerReplacePending, "x-ms-offer-replace-pending", Boolean::parseBoolean, headers);
        this.mapValue(this.ownerFullName, "x-ms-alt-content-path", String::toString, headers);
        this.mapValue(this.ownerId, "x-ms-content-path", String::toString, headers);
        this.mapValue(this.partitionKeyRangeId, "x-ms-documentdb-partitionkeyrangeid", String::toString, headers);
        this.mapValue(this.queryMetrics, "x-ms-documentdb-query-metrics", String::toString, headers);
        this.mapValue(this.quorumAckedLSN, "x-ms-quorum-acked-lsn", Long::parseLong, headers);
        this.mapValue(this.quorumAckedLocalLSN, "x-ms-cosmos-quorum-acked-llsn", Long::parseLong, headers);
        this.mapValue(this.requestCharge, "x-ms-request-charge", Double::parseDouble, headers);
        this.mapValue(this.requestValidationFailure, "x-ms-request-validation-failure", Byte::parseByte, headers);
        this.mapValue(this.restoreState, "x-ms-restore-state", String::toString, headers);
        this.mapValue(this.retryAfterMilliseconds, "x-ms-retry-after-ms", Integer::parseInt, headers);
        this.mapValue(this.schemaVersion, "x-ms-schemaversion", String::toString, headers);
        this.mapValue(this.serverDateTimeUtc, "x-ms-date", String::toString, headers);
        this.mapValue(this.sessionToken, "x-ms-session-token", String::toString, headers);
        this.mapValue(this.shareThroughput, "x-ms-share-throughput", Boolean::parseBoolean, headers);
        this.mapValue(this.storageMaxResoureQuota, "x-ms-resource-quota", String::toString, headers);
        this.mapValue(this.storageResourceQuotaUsage, "x-ms-resource-usage", String::toString, headers);
        this.mapValue(this.subStatus, "x-ms-substatus", Integer::parseInt, headers);
        this.mapValue(this.transportRequestID, "x-ms-transport-request-id", Integer::parseInt, headers);
        this.mapValue(this.xpRole, "x-ms-xp-role", Integer::parseInt, headers);
    }

    public String toString() {
        ObjectWriter writer = RntbdObjectMapper.writer();
        try {
            return writer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException error) {
            throw new CorruptedFrameException((Throwable)error);
        }
    }

    private void collectEntries(BiConsumer<RntbdToken, Function<RntbdToken, Map.Entry<String, String>>> collector) {
        collector.accept(this.LSN, token -> RntbdResponseHeaders.toLongEntry("lsn", token));
        collector.accept(this.collectionLazyIndexProgress, token -> RntbdResponseHeaders.toIntegerEntry("x-ms-documentdb-collection-lazy-indexing-progress", token));
        collector.accept(this.collectionPartitionIndex, token -> RntbdResponseHeaders.toIntegerEntry("collection-partition-index", token));
        collector.accept(this.collectionSecurityIdentifier, token -> RntbdResponseHeaders.toStringEntry("x-ms-collection-security-identifier", token));
        collector.accept(this.collectionServiceIndex, token -> RntbdResponseHeaders.toIntegerEntry("collection-service-index", token));
        collector.accept(this.collectionUpdateProgress, token -> RntbdResponseHeaders.toIntegerEntry("x-ms-documentdb-collection-index-transformation-progress", token));
        collector.accept(this.continuationToken, token -> RntbdResponseHeaders.toStringEntry("x-ms-continuation", token));
        collector.accept(this.currentReplicaSetSize, token -> RntbdResponseHeaders.toIntegerEntry("x-ms-current-replica-set-size", token));
        collector.accept(this.currentWriteQuorum, token -> RntbdResponseHeaders.toIntegerEntry("x-ms-current-write-quorum", token));
        collector.accept(this.databaseAccountId, token -> RntbdResponseHeaders.toStringEntry("x-ms-database-account-id", token));
        collector.accept(this.disableRntbdChannel, token -> RntbdResponseHeaders.toBooleanEntry("x-ms-disable-rntbd-channel", token));
        collector.accept(this.eTag, token -> RntbdResponseHeaders.toStringEntry("etag", token));
        collector.accept(this.globalCommittedLSN, token -> RntbdResponseHeaders.toLongEntry("x-ms-global-Committed-lsn", token));
        collector.accept(this.hasTentativeWrites, token -> RntbdResponseHeaders.toBooleanEntry("x-ms-cosmosdb-has-tentative-writes", token));
        collector.accept(this.indexingDirective, token -> new Entry("x-ms-indexing-directive", RntbdConstants.RntbdIndexingDirective.fromId(token.getValue(Byte.class)).name()));
        collector.accept(this.isRUPerMinuteUsed, token -> RntbdResponseHeaders.toByteEntry("x-ms-documentdb-is-ru-per-minute-used", token));
        collector.accept(this.itemCount, token -> RntbdResponseHeaders.toIntegerEntry("x-ms-item-count", token));
        collector.accept(this.itemLSN, token -> RntbdResponseHeaders.toLongEntry("x-ms-item-lsn", token));
        collector.accept(this.itemLocalLSN, token -> RntbdResponseHeaders.toLongEntry("x-ms-cosmos-item-llsn", token));
        collector.accept(this.lastStateChangeDateTime, token -> RntbdResponseHeaders.toStringEntry("x-ms-last-state-change-utc", token));
        collector.accept(this.localLSN, token -> RntbdResponseHeaders.toLongEntry("x-ms-cosmos-llsn", token));
        collector.accept(this.logResults, token -> RntbdResponseHeaders.toStringEntry("x-ms-documentdb-script-log-results", token));
        collector.accept(this.numberOfReadRegions, token -> RntbdResponseHeaders.toIntegerEntry("x-ms-number-of-read-regions", token));
        collector.accept(this.offerReplacePending, token -> RntbdResponseHeaders.toBooleanEntry("x-ms-offer-replace-pending", token));
        collector.accept(this.ownerFullName, token -> RntbdResponseHeaders.toStringEntry("x-ms-alt-content-path", token));
        collector.accept(this.ownerId, token -> RntbdResponseHeaders.toStringEntry("x-ms-content-path", token));
        collector.accept(this.partitionKeyRangeId, token -> RntbdResponseHeaders.toStringEntry("x-ms-documentdb-partitionkeyrangeid", token));
        collector.accept(this.queryMetrics, token -> RntbdResponseHeaders.toStringEntry("x-ms-documentdb-query-metrics", token));
        collector.accept(this.quorumAckedLSN, token -> RntbdResponseHeaders.toLongEntry("x-ms-quorum-acked-lsn", token));
        collector.accept(this.quorumAckedLocalLSN, token -> RntbdResponseHeaders.toLongEntry("x-ms-cosmos-quorum-acked-llsn", token));
        collector.accept(this.requestCharge, token -> RntbdResponseHeaders.toCurrencyEntry("x-ms-request-charge", token));
        collector.accept(this.requestValidationFailure, token -> RntbdResponseHeaders.toByteEntry("x-ms-request-validation-failure", token));
        collector.accept(this.restoreState, token -> RntbdResponseHeaders.toStringEntry("x-ms-restore-state", token));
        collector.accept(this.retryAfterMilliseconds, token -> RntbdResponseHeaders.toIntegerEntry("x-ms-retry-after-ms", token));
        collector.accept(this.schemaVersion, token -> RntbdResponseHeaders.toStringEntry("x-ms-schemaversion", token));
        collector.accept(this.serverDateTimeUtc, token -> RntbdResponseHeaders.toStringEntry("x-ms-date", token));
        collector.accept(this.sessionToken, token -> this.toSessionTokenEntry("x-ms-session-token", (RntbdToken)token));
        collector.accept(this.shareThroughput, token -> RntbdResponseHeaders.toBooleanEntry("x-ms-share-throughput", token));
        collector.accept(this.storageMaxResoureQuota, token -> RntbdResponseHeaders.toStringEntry("x-ms-resource-quota", token));
        collector.accept(this.storageResourceQuotaUsage, token -> RntbdResponseHeaders.toStringEntry("x-ms-resource-usage", token));
        collector.accept(this.subStatus, token -> RntbdResponseHeaders.toIntegerEntry("x-ms-substatus", token));
        collector.accept(this.transportRequestID, token -> RntbdResponseHeaders.toIntegerEntry("x-ms-transport-request-id", token));
        collector.accept(this.xpRole, token -> RntbdResponseHeaders.toIntegerEntry("x-ms-xp-role", token));
    }

    private void mapValue(RntbdToken token, String name, Function<String, Object> parse, Map<String, String> headers) {
        String value = headers.get(name);
        if (value != null) {
            token.setValue(parse.apply(value));
        }
    }

    private static Map.Entry<String, String> toBooleanEntry(String name, RntbdToken token) {
        return new Entry(name, String.valueOf(token.getValue(Byte.class) != 0));
    }

    private static Map.Entry<String, String> toByteEntry(String name, RntbdToken token) {
        return new Entry(name, Byte.toString(token.getValue(Byte.class)));
    }

    private static Map.Entry<String, String> toCurrencyEntry(String name, RntbdToken token) {
        BigDecimal value = new BigDecimal(Math.round(token.getValue(Double.class) * 100.0)).scaleByPowerOfTen(-2);
        return new Entry(name, value.toString());
    }

    private static Map.Entry<String, String> toIntegerEntry(String name, RntbdToken token) {
        return new Entry(name, Long.toString(token.getValue(Long.class)));
    }

    private static Map.Entry<String, String> toLongEntry(String name, RntbdToken token) {
        return new Entry(name, Long.toString(token.getValue(Long.class)));
    }

    private Map.Entry<String, String> toSessionTokenEntry(String name, RntbdToken token) {
        return new Entry(name, this.partitionKeyRangeId.getValue(String.class) + ":" + this.sessionToken.getValue(String.class));
    }

    private static Map.Entry<String, String> toStringEntry(String name, RntbdToken token) {
        return new Entry(name, token.getValue(String.class));
    }

    private static final class Entry
    extends AbstractMap.SimpleImmutableEntry<String, String> {
        Entry(String name, String value) {
            super(name, value);
        }
    }
}

