/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.cosmos.internal.directconnectivity.rntbd;

import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdConstants;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdToken;
import com.azure.data.cosmos.internal.directconnectivity.rntbd.RntbdTokenType;
import com.azure.data.cosmos.internal.guava27.Strings;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.ReferenceCounted;
import java.util.stream.Collector;

abstract class RntbdTokenStream<T extends Enum<T>>
implements ReferenceCounted {
    final ByteBuf in;
    final ImmutableMap<Short, T> headers;
    final ImmutableMap<T, RntbdToken> tokens;

    RntbdTokenStream(ImmutableSet<T> headers, ImmutableMap<Short, T> ids, ByteBuf in) {
        Preconditions.checkNotNull(headers, (Object)"expected non-null headers");
        Preconditions.checkNotNull(ids, (Object)"expected non-null ids");
        Preconditions.checkNotNull((Object)in, (Object)"expected non-null in");
        Collector collector = Maps.toImmutableEnumMap(h -> h, x$0 -> RntbdToken.create((RntbdConstants.RntbdHeader)x$0));
        this.tokens = (ImmutableMap)headers.stream().collect(collector);
        this.headers = ids;
        this.in = in;
    }

    final int computeCount() {
        int count = 0;
        for (RntbdToken token : this.tokens.values()) {
            if (!token.isPresent()) continue;
            ++count;
        }
        return count;
    }

    final int computeLength() {
        int total = 0;
        for (RntbdToken token : this.tokens.values()) {
            total += token.computeLength();
        }
        return total;
    }

    static <T extends RntbdTokenStream<?>> T decode(T stream) {
        ByteBuf in = stream.in;
        while (in.readableBytes() > 0) {
            short id = in.readShortLE();
            RntbdTokenType type = RntbdTokenType.fromId(in.readByte());
            RntbdToken token = (RntbdToken)stream.tokens.get(stream.headers.get((Object)id));
            if (token == null) {
                token = RntbdToken.create(new UndefinedHeader(id, type));
            }
            token.decode(in);
        }
        for (RntbdToken token : stream.tokens.values()) {
            if (token.isPresent() || !token.isRequired()) continue;
            String message = Strings.lenientFormat("Required header not found on token stream: %s", token);
            throw new CorruptedFrameException(message);
        }
        return stream;
    }

    final void encode(ByteBuf out) {
        for (RntbdToken token : this.tokens.values()) {
            token.encode(out);
        }
    }

    final RntbdToken get(T header) {
        return (RntbdToken)this.tokens.get(header);
    }

    public final int refCnt() {
        return this.in.refCnt();
    }

    public final boolean release() {
        return this.release(1);
    }

    public final boolean release(int count) {
        return this.in.release(count);
    }

    public final RntbdTokenStream<T> retain() {
        return this.retain(1);
    }

    public final RntbdTokenStream<T> retain(int count) {
        this.in.retain(count);
        return this;
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    public ReferenceCounted touch() {
        return this;
    }

    private static final class UndefinedHeader
    implements RntbdConstants.RntbdHeader {
        private final short id;
        private final RntbdTokenType type;

        UndefinedHeader(short id, RntbdTokenType type) {
            this.id = id;
            this.type = type;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public short id() {
            return this.id;
        }

        @Override
        public String name() {
            return "Undefined";
        }

        @Override
        public RntbdTokenType type() {
            return this.type;
        }
    }
}

