/*
 * The MIT License (MIT)
 * Copyright (c) 2018 Microsoft Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.microsoft.azure.cosmosdb.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

public class JavaStreamUtils {
    private static <T> String safeToString(T t) {
        return t != null ? t.toString() : "null";
    }

    public static <T> String info(Collection<T> collection) {
        return collection == null ? "null collection" :
                "collection size: " + collection.size();
    }

    public static <T> String info(T[] collection) {
        return collection == null ? "null collection" :
                "collection size: " + collection.length;
    }

    public static <T> String toString(Collection<T> collection, String delimiter) {
        return collection == null ? "null collection" :
                collection.isEmpty() ? "empty collection" :
                collection.stream()
                        .map(t -> safeToString(t))
                        .collect(Collectors.joining(delimiter));
    }

    public static <T> String toString(T[] array, String delimiter) {
        return array == null ? "null array" :
                toString(Arrays.asList(array), delimiter);
    }

}
