/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.cosmosdb.ChangeFeedOptions;
import com.microsoft.azure.cosmosdb.ConnectionPolicy;
import com.microsoft.azure.cosmosdb.ConsistencyPolicy;
import com.microsoft.azure.cosmosdb.DatabaseAccount;
import com.microsoft.azure.cosmosdb.Document;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedOptionsBase;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.MediaResponse;
import com.microsoft.azure.cosmosdb.QueryMetrics;
import com.microsoft.azure.cosmosdb.ReplicationPolicy;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.ResourceResponse;
import com.microsoft.azure.cosmosdb.StoredProcedureResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.Uri;
import com.microsoft.azure.cosmosdb.internal.query.metrics.ClientSideMetrics;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class BridgeInternal {
    public static Error createError(ObjectNode objectNode) {
        return new Error(objectNode);
    }

    public static Document documentFromObject(Object document, ObjectMapper mapper) {
        return Document.FromObject(document, mapper);
    }

    public static <T extends Resource> ResourceResponse<T> toResourceResponse(RxDocumentServiceResponse response, Class<T> cls) {
        return new ResourceResponse<T>(response, cls);
    }

    public static <T extends Resource> MediaResponse toMediaResponse(RxDocumentServiceResponse response, boolean willBuffer) {
        return new MediaResponse(response, willBuffer);
    }

    public static <T extends Resource> FeedResponse<T> toFeedResponsePage(RxDocumentServiceResponse response, Class<T> cls) {
        return new FeedResponse<T>(response.getQueryResponse(cls), response.getResponseHeaders());
    }

    public static <T extends Resource> FeedResponse<T> toChaneFeedResponsePage(RxDocumentServiceResponse response, Class<T> cls) {
        return new FeedResponse(BridgeInternal.noChanges(response) ? Collections.emptyList() : response.getQueryResponse(cls), response.getResponseHeaders(), BridgeInternal.noChanges(response));
    }

    public static StoredProcedureResponse toStoredProcedureResponse(RxDocumentServiceResponse response) {
        return new StoredProcedureResponse(response);
    }

    public static DatabaseAccount toDatabaseAccount(RxDocumentServiceResponse response) {
        DatabaseAccount account = response.getResource(DatabaseAccount.class);
        Map<String, String> responseHeader = response.getResponseHeaders();
        account.setMaxMediaStorageUsageInMB(Long.valueOf(responseHeader.get("x-ms-max-media-storage-usage-mb")));
        account.setMediaStorageUsageInMB(Long.valueOf(responseHeader.get("x-ms-media-storage-usage-mb")));
        return account;
    }

    public static Map<String, String> getFeedHeaders(FeedOptionsBase options) {
        FeedOptions feedOptions;
        if (options == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (options.getMaxItemCount() != null) {
            headers.put("x-ms-max-item-count", options.getMaxItemCount().toString());
        }
        if (options instanceof ChangeFeedOptions) {
            ChangeFeedOptions changeFeedOptions = (ChangeFeedOptions)options;
            String ifNoneMatchValue = null;
            if (changeFeedOptions.getRequestContinuation() != null) {
                ifNoneMatchValue = changeFeedOptions.getRequestContinuation();
            } else if (!changeFeedOptions.isStartFromBeginning()) {
                ifNoneMatchValue = "*";
            }
            if (ifNoneMatchValue != null) {
                headers.put("If-None-Match", ifNoneMatchValue);
            }
            headers.put("A-IM", "Incremental feed");
        } else if (options.getRequestContinuation() != null) {
            headers.put("x-ms-continuation", options.getRequestContinuation());
        }
        FeedOptions feedOptions2 = feedOptions = options instanceof FeedOptions ? (FeedOptions)options : null;
        if (feedOptions != null) {
            if (feedOptions.getSessionToken() != null) {
                headers.put("x-ms-session-token", feedOptions.getSessionToken());
            }
            if (feedOptions.getEnableScanInQuery() != null) {
                headers.put("x-ms-documentdb-query-enable-scan", feedOptions.getEnableScanInQuery().toString());
            }
            if (feedOptions.getEmitVerboseTracesInQuery() != null) {
                headers.put("x-ms-documentdb-query-emit-traces", feedOptions.getEmitVerboseTracesInQuery().toString());
            }
            if (feedOptions.getEnableCrossPartitionQuery() != null) {
                headers.put("x-ms-documentdb-query-enablecrosspartition", feedOptions.getEnableCrossPartitionQuery().toString());
            }
            if (feedOptions.getMaxDegreeOfParallelism() != 0) {
                headers.put("x-ms-documentdb-query-parallelizecrosspartitionquery", Boolean.TRUE.toString());
            }
            if (feedOptions.getResponseContinuationTokenLimitInKb() > 0) {
                headers.put("x-ms-documentdb-responsecontinuationtokenlimitinkb", Strings.toString(feedOptions.getResponseContinuationTokenLimitInKb()));
            }
            if (feedOptions.getPopulateQueryMetrics()) {
                headers.put("x-ms-documentdb-populatequerymetrics", String.valueOf(feedOptions.getPopulateQueryMetrics()));
            }
        }
        return headers;
    }

    public static <T extends Resource> boolean noChanges(FeedResponse<T> page) {
        return page.nochanges;
    }

    public static <T extends Resource> boolean noChanges(RxDocumentServiceResponse rsp) {
        return rsp.getStatusCode() == 304;
    }

    public static <T extends Resource> FeedResponse<T> createFeedResponse(List<T> results, Map<String, String> headers) {
        return new FeedResponse<T>(results, headers);
    }

    public static <T extends Resource> FeedResponse<T> createFeedResponseWithQueryMetrics(List<T> results, Map<String, String> headers, ConcurrentMap<String, QueryMetrics> queryMetricsMap) {
        return new FeedResponse<T>(results, headers, queryMetricsMap);
    }

    public static <E extends DocumentClientException> E setResourceAddress(E e, String resourceAddress) {
        e.setResourceAddress(resourceAddress);
        return e;
    }

    public static <E extends DocumentClientException> long getLSN(E e) {
        return e.getLsn();
    }

    public static <E extends DocumentClientException> String getPartitionKeyRangeId(E e) {
        return e.getPartitionKeyRangeId();
    }

    public static <E extends DocumentClientException> String getResourceAddress(E e) {
        return e.getResourceAddress();
    }

    public static <E extends DocumentClientException> E setLSN(E e, long lsn) {
        e.setLsn(lsn);
        return e;
    }

    public static <E extends DocumentClientException> E setPartitionKeyRangeId(E e, String partitionKeyRangeId) {
        e.setPartitionKeyRangeId(partitionKeyRangeId);
        return e;
    }

    public static boolean isEnableMultipleWriteLocations(DatabaseAccount account) {
        return account.isEnableMultipleWriteLocations();
    }

    public static boolean getUseMultipleWriteLocations(ConnectionPolicy policy) {
        return policy.isUsingMultipleWriteLocations();
    }

    public static void setUseMultipleWriteLocations(ConnectionPolicy policy, boolean value) {
        policy.setUsingMultipleWriteLocations(value);
    }

    public static <E extends DocumentClientException> Uri getRequestUri(DocumentClientException documentClientException) {
        return documentClientException.getRequestUri();
    }

    public static <E extends DocumentClientException> void setRequestHeaders(DocumentClientException documentClientException, Map<String, String> requestHeaders) {
        documentClientException.setRequestHeaders(requestHeaders);
    }

    public static <E extends DocumentClientException> Map<String, String> getRequestHeaders(DocumentClientException documentClientException) {
        return documentClientException.getRequestHeaders();
    }

    public static Map<String, Object> getQueryEngineConfiuration(DatabaseAccount databaseAccount) {
        return databaseAccount.getQueryEngineConfiuration();
    }

    public static ReplicationPolicy getReplicationPolicy(DatabaseAccount databaseAccount) {
        return databaseAccount.getReplicationPolicy();
    }

    public static ReplicationPolicy getSystemReplicationPolicy(DatabaseAccount databaseAccount) {
        return databaseAccount.getSystemReplicationPolicy();
    }

    public static ConsistencyPolicy getConsistencyPolicy(DatabaseAccount databaseAccount) {
        return databaseAccount.getConsistencyPolicy();
    }

    public static String getAltLink(Resource resource) {
        return resource.getAltLink();
    }

    public static void setAltLink(Resource resource, String altLink) {
        resource.setAltLink(altLink);
    }

    public static void setMaxReplicaSetSize(ReplicationPolicy replicationPolicy, int value) {
        replicationPolicy.setMaxReplicaSetSize(value);
    }

    public static <T extends Resource> void putQueryMetricsIntoMap(FeedResponse<T> response, String partitionKeyRangeId, QueryMetrics queryMetrics) {
        response.getQueryMetricsMap().put(partitionKeyRangeId, queryMetrics);
    }

    public static QueryMetrics createQueryMetricsFromDelimitedStringAndClientSideMetrics(String queryMetricsDelimitedString, ClientSideMetrics clientSideMetrics, String activityId) {
        return QueryMetrics.createFromDelimitedStringAndClientSideMetrics(queryMetricsDelimitedString, clientSideMetrics, activityId);
    }

    public static QueryMetrics createQueryMetricsFromCollection(Collection<QueryMetrics> queryMetricsCollection) {
        return QueryMetrics.createFromCollection(queryMetricsCollection);
    }

    public static ClientSideMetrics getClientSideMetrics(QueryMetrics queryMetrics) {
        return queryMetrics.getClientSideMetrics();
    }

    public static String getInnerErrorMessage(DocumentClientException documentClientException) {
        if (documentClientException == null) {
            return null;
        }
        return documentClientException.getInnerErrorMessage();
    }
}

