/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb;

import com.microsoft.azure.cosmosdb.ClientSideRequestStatistics;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.Uri;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class DocumentClientException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> requestHeaders = new ConcurrentHashMap<String, String>();
    private final Map<String, String> responseHeaders;
    private final int statusCode;
    private volatile ClientSideRequestStatistics clientSideRequestStatistics;
    private volatile Error error;
    private volatile long lsn;
    private volatile String partitionKeyRangeId;
    private volatile Uri requestUri;
    private volatile String resourceAddress;

    public DocumentClientException(int statusCode) {
        this(statusCode, null, null, null);
    }

    public DocumentClientException(int statusCode, String errorMessage) {
        this(statusCode, errorMessage, null, null);
        this.error = new Error();
        this.error.set("message", errorMessage);
    }

    public DocumentClientException(int statusCode, Exception innerException) {
        this(statusCode, null, null, innerException);
    }

    public DocumentClientException(int statusCode, Error errorResource, Map<String, String> responseHeaders) {
        this(null, statusCode, errorResource, responseHeaders);
    }

    public DocumentClientException(String resourceAddress, int statusCode, Error errorResource, Map<String, String> responseHeaders) {
        this(statusCode, errorResource == null ? null : errorResource.getMessage(), responseHeaders, null);
        this.resourceAddress = resourceAddress;
        this.error = errorResource;
    }

    public DocumentClientException(String message, Exception exception, Map<String, String> responseHeaders, int statusCode, String resourceAddress) {
        this(statusCode, message, responseHeaders, exception);
        this.resourceAddress = resourceAddress;
    }

    private DocumentClientException(int statusCode, String message, Map<String, String> responseHeaders, Throwable cause) {
        super(message, cause);
        this.responseHeaders = responseHeaders == null ? new ConcurrentHashMap<String, String>() : new ConcurrentHashMap<String, String>(responseHeaders);
        this.statusCode = statusCode;
    }

    public String getActivityId() {
        if (this.responseHeaders != null) {
            return this.responseHeaders.get("x-ms-activity-id");
        }
        return null;
    }

    public ClientSideRequestStatistics getClientSideRequestStatistics() {
        return this.clientSideRequestStatistics;
    }

    public void setClientSideRequestStatistics(ClientSideRequestStatistics clientSideRequestStatistics) {
        this.clientSideRequestStatistics = clientSideRequestStatistics;
    }

    public Error getError() {
        return this.error;
    }

    public long getLsn() {
        return this.lsn;
    }

    void setLsn(long lsn) {
        this.lsn = lsn;
    }

    @Override
    public String getMessage() {
        if (this.clientSideRequestStatistics == null) {
            return this.getInnerErrorMessage();
        }
        return this.getInnerErrorMessage() + ", " + this.clientSideRequestStatistics.toString();
    }

    public String getPartitionKeyRangeId() {
        return this.partitionKeyRangeId;
    }

    void setPartitionKeyRangeId(String partitionKeyRangeId) {
        this.partitionKeyRangeId = partitionKeyRangeId;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    void setRequestHeaders(Map<String, String> values) {
        this.requestHeaders.clear();
        if (values != null) {
            for (Map.Entry<String, String> entry : values.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null) continue;
                this.requestHeaders.put(key, value);
            }
        }
    }

    public Uri getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(Uri requestUri) {
        this.requestUri = requestUri;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public long getRetryAfterInMilliseconds() {
        String header;
        long retryIntervalInMilliseconds = 0L;
        if (this.responseHeaders != null && StringUtils.isNotEmpty((CharSequence)(header = this.responseHeaders.get("x-ms-retry-after-ms")))) {
            try {
                retryIntervalInMilliseconds = Long.parseLong(header);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retryIntervalInMilliseconds;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getSubStatusCode() {
        String subStatusString;
        int code = 0;
        if (this.responseHeaders != null && StringUtils.isNotEmpty((CharSequence)(subStatusString = this.responseHeaders.get("x-ms-substatus")))) {
            try {
                code = Integer.parseInt(subStatusString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return code;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{error=" + this.error + ", resourceAddress='" + this.resourceAddress + '\'' + ", statusCode=" + this.statusCode + ", message=" + this.getMessage() + ", getCauseInfo=" + this.getCauseInfo() + ", responseHeaders=" + this.responseHeaders + ", requestHeaders=" + this.requestHeaders + '}';
    }

    String getInnerErrorMessage() {
        String innerErrorMessage = super.getMessage();
        if (this.error != null && (innerErrorMessage = this.error.getMessage()) == null) {
            innerErrorMessage = String.valueOf(this.error.get("Errors"));
        }
        return innerErrorMessage;
    }

    String getResourceAddress() {
        return this.resourceAddress;
    }

    void setResourceAddress(String resourceAddress) {
        this.resourceAddress = resourceAddress;
    }

    private String getCauseInfo() {
        Throwable cause = this.getCause();
        if (cause != null) {
            return String.format("[class: %s, message: %s]", cause.getClass(), cause.getMessage());
        }
        return null;
    }
}

