/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufferPool {
    private final ArrayList<PoolSegment> poolSegmentList = new ArrayList();
    private static final ByteBufferPool instant = new ByteBufferPool();
    private final Logger logger = LoggerFactory.getLogger(ByteBufferPool.class);

    public static ByteBufferPool getInstant() {
        return instant;
    }

    private ByteBufferPool() {
        this.logger.debug("Initializing ByteBuffer Pool");
        long totalSize = 0L;
        int byteBufferSize = 1024;
        for (int segmentSize = 1024; segmentSize > 0; segmentSize /= 2) {
            this.logger.debug("Creating pool segment: ByteBuffer size {}, pool segment size {}", (Object)byteBufferSize, (Object)segmentSize);
            this.poolSegmentList.add(this.createByteBufferPoolSegment(byteBufferSize, segmentSize));
            totalSize += (long)(byteBufferSize * segmentSize);
            byteBufferSize *= 2;
        }
        this.logger.debug("Total ByteBuffer Pool Size {}", (Object)totalSize);
    }

    private PoolSegment createByteBufferPoolSegment(int byteBufferSize, int count) {
        ConcurrentLinkedDeque<ByteBufferWrapper> deq = new ConcurrentLinkedDeque<ByteBufferWrapper>();
        PoolSegment poolSegment = new PoolSegment(count, deq);
        for (int i = 0; i < count; ++i) {
            deq.add(new ByteBufferWrapper(ByteBuffer.allocate(byteBufferSize), poolSegment));
        }
        return new PoolSegment(byteBufferSize, deq);
    }

    private int findLowestIndex(int size) {
        for (int i = 0; i < this.poolSegmentList.size(); ++i) {
            if (this.poolSegmentList.get(i).byteBufferSize < size) continue;
            return i;
        }
        return -1;
    }

    public ByteBufferWrapper lease(int size) {
        int poolIndex = this.findLowestIndex(size);
        if (poolIndex == -1) {
            this.logger.info("Requested byte buffer size {} is greater than the max the pool supports, creating a garbage collectable instance.", (Object)size);
            return new ByteBufferWrapper(ByteBuffer.allocate(size), null);
        }
        for (int i = poolIndex; i < this.poolSegmentList.size(); ++i) {
            ByteBufferWrapper byteBuffer = (ByteBufferWrapper)this.poolSegmentList.get(i).byteBuffersPool.poll();
            if (byteBuffer == null) continue;
            return byteBuffer;
        }
        this.logger.warn("Configured Byte Buffer Pool is not sufficient, creating new garbage collectable instance");
        return new ByteBufferWrapper(ByteBuffer.allocate(size), null);
    }

    public void release(ByteBufferWrapper byteBufferWrapper) {
        PoolSegment parentPoolSegment = byteBufferWrapper.poolSegment;
        if (parentPoolSegment != null) {
            parentPoolSegment.byteBuffersPool.add(byteBufferWrapper);
            return;
        }
    }

    private class PoolSegment {
        private final int byteBufferSize;
        private final ConcurrentLinkedDeque<ByteBufferWrapper> byteBuffersPool;

        public PoolSegment(int byteBufferSize, ConcurrentLinkedDeque<ByteBufferWrapper> byteBuffersPool) {
            this.byteBufferSize = byteBufferSize;
            this.byteBuffersPool = byteBuffersPool;
        }
    }

    public class ByteBufferWrapper {
        private final PoolSegment poolSegment;
        private final ByteBuffer byteBuffer;

        private ByteBufferWrapper(ByteBuffer byteBuffer, PoolSegment poolSegment) {
            this.byteBuffer = byteBuffer;
            this.poolSegment = poolSegment;
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }
    }
}

