/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.internal.directconnectivity.Protocol;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.Uri;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AddressInformation {
    private Protocol protocol;
    private boolean isPublic;
    private boolean isPrimary;
    private Uri physicalUri;

    public AddressInformation(boolean isPublic, boolean isPrimary, String physicalUri, Protocol protocol) {
        Objects.requireNonNull(protocol);
        this.protocol = protocol;
        this.isPublic = isPublic;
        this.isPrimary = isPrimary;
        this.physicalUri = new Uri(AddressInformation.normalizePhysicalUri(physicalUri));
    }

    private static String normalizePhysicalUri(String physicalUri) {
        int i;
        if (StringUtils.isEmpty((CharSequence)physicalUri)) {
            return physicalUri;
        }
        for (i = physicalUri.length() - 1; i >= 0 && physicalUri.charAt(i) == '/'; --i) {
        }
        return physicalUri.substring(0, i + 1) + '/';
    }

    public AddressInformation(boolean isPublic, boolean isPrimary, String physicalUri, String protocolScheme) {
        this(isPublic, isPrimary, physicalUri, AddressInformation.scheme2protocol(protocolScheme));
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public Uri getPhysicalUri() {
        return this.physicalUri;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getProtocolName() {
        return this.protocol.name();
    }

    public String getProtocolScheme() {
        return this.protocol.scheme();
    }

    public String toString() {
        return "AddressInformation{protocol='" + (Object)((Object)this.protocol) + '\'' + ", isPublic=" + this.isPublic + ", isPrimary=" + this.isPrimary + ", physicalUri='" + this.physicalUri + '\'' + '}';
    }

    private static Protocol scheme2protocol(String scheme) {
        Objects.requireNonNull(scheme, "scheme");
        switch (scheme.toLowerCase()) {
            case "https": {
                return Protocol.Https;
            }
            case "rntbd": {
                return Protocol.Tcp;
            }
        }
        throw new IllegalArgumentException(String.format("scheme: %s", scheme));
    }
}

