/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.internal.ISessionToken;
import com.microsoft.azure.cosmosdb.internal.InternalServerErrorException;
import com.microsoft.azure.cosmosdb.internal.RequestChargeTracker;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.Uri;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResult {
    private static final Logger logger = LoggerFactory.getLogger(StoreResult.class);
    private final StoreResponse storeResponse;
    private final DocumentClientException exception;
    public final long lsn;
    public final String partitionKeyRangeId;
    public final long quorumAckedLSN;
    public final long globalCommittedLSN;
    public final long numberOfReadRegions;
    public final long itemLSN;
    public final ISessionToken sessionToken;
    public final double requestCharge;
    public final int currentReplicaSetSize;
    public final int currentWriteQuorum;
    public final boolean isValid;
    public final boolean isGoneException;
    public final boolean isNotFoundException;
    public final boolean isInvalidPartitionException;
    public final Uri storePhysicalAddress;

    public StoreResult(StoreResponse storeResponse, DocumentClientException exception, String partitionKeyRangeId, long lsn, long quorumAckedLsn, double requestCharge, int currentReplicaSetSize, int currentWriteQuorum, boolean isValid, Uri storePhysicalAddress, long globalCommittedLSN, int numberOfReadRegions, long itemLSN, ISessionToken sessionToken) {
        this.storeResponse = storeResponse;
        this.exception = exception;
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.lsn = lsn;
        this.quorumAckedLSN = quorumAckedLsn;
        this.requestCharge = requestCharge;
        this.currentReplicaSetSize = currentReplicaSetSize;
        this.currentWriteQuorum = currentWriteQuorum;
        this.isValid = isValid;
        this.isGoneException = this.exception != null && this.exception.getStatusCode() == 410;
        this.isNotFoundException = this.exception != null && this.exception.getStatusCode() == 404;
        this.isInvalidPartitionException = this.exception != null && Exceptions.isNameCacheStale(this.exception);
        this.storePhysicalAddress = storePhysicalAddress;
        this.globalCommittedLSN = globalCommittedLSN;
        this.numberOfReadRegions = numberOfReadRegions;
        this.itemLSN = itemLSN;
        this.sessionToken = sessionToken;
    }

    public DocumentClientException getException() throws InternalServerErrorException {
        if (this.exception == null) {
            String message = "Exception should be available but found none";
            assert (false) : message;
            logger.error(message);
            throw new InternalServerErrorException("Unknown server error occurred when processing this request.");
        }
        return this.exception;
    }

    public StoreResponse toResponse() throws DocumentClientException {
        return this.toResponse(null);
    }

    public StoreResponse toResponse(RequestChargeTracker requestChargeTracker) throws DocumentClientException {
        if (!this.isValid) {
            if (this.exception == null) {
                logger.error("Exception not set for invalid response");
                throw new InternalServerErrorException("Unknown server error occurred when processing this request.");
            }
            throw this.exception;
        }
        if (requestChargeTracker != null && this.isValid) {
            StoreResult.setRequestCharge(this.storeResponse, this.exception, requestChargeTracker.getTotalRequestCharge());
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.storeResponse;
    }

    private static void setRequestCharge(StoreResponse response, DocumentClientException documentClientException, double totalRequestCharge) {
        if (documentClientException != null) {
            documentClientException.getResponseHeaders().put("x-ms-request-charge", Double.toString(totalRequestCharge));
        } else if (response.getResponseHeaderNames() != null) {
            for (int i = 0; i < response.getResponseHeaderNames().length; ++i) {
                if (!Strings.areEqualIgnoreCase(response.getResponseHeaderNames()[i], "x-ms-request-charge")) continue;
                response.getResponseHeaderValues()[i] = Double.toString(totalRequestCharge);
                break;
            }
        }
    }

    public String toString() {
        int statusCode = 0;
        int subStatusCode = 0;
        if (this.storeResponse != null) {
            statusCode = this.storeResponse.getStatus();
            subStatusCode = this.storeResponse.getSubStatusCode();
        } else if (this.exception != null) {
            statusCode = this.exception.getStatusCode();
            subStatusCode = this.exception.getSubStatusCode();
        }
        return "storePhysicalAddress: " + this.storePhysicalAddress + ", lsn: " + this.lsn + ", globalCommittedLsn: " + this.globalCommittedLSN + ", partitionKeyRangeId: " + this.partitionKeyRangeId + ", isValid: " + this.isValid + ", statusCode: " + statusCode + ", subStatusCode: " + subStatusCode + ", isGone: " + this.isGoneException + ", isNotFound: " + this.isNotFoundException + ", isInvalidPartition: " + this.isInvalidPartitionException + ", requestCharge: " + this.requestCharge + ", itemLSN: " + this.itemLSN + ", sessionToken: " + (this.sessionToken != null ? this.sessionToken.convertToString() : null) + ", exception: " + BridgeInternal.getInnerErrorMessage(this.exception);
    }
}

