/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import java.net.URI;
import java.util.Objects;

public class Uri {
    private final String uriAsString;
    private final URI uri;

    public static Uri create(String uriAsString) {
        return new Uri(uriAsString);
    }

    public Uri(String uri) {
        this.uriAsString = uri;
        URI uriValue = null;
        try {
            uriValue = URI.create(uri);
        }
        catch (IllegalArgumentException e) {
            uriValue = null;
        }
        this.uri = uriValue;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getURIAsString() {
        return this.uriAsString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Uri uri1 = (Uri)o;
        return this.uriAsString.equals(uri1.uriAsString) && this.uri.equals(uri1.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uriAsString, this.uri);
    }

    public String toString() {
        return this.uriAsString;
    }
}

