/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store;

import com.microsoft.azure.datalake.store.ADLException;
import com.microsoft.azure.datalake.store.ADLFileInputStream;
import com.microsoft.azure.datalake.store.ADLFileOutputStream;
import com.microsoft.azure.datalake.store.ADLStoreOptions;
import com.microsoft.azure.datalake.store.ContentSummary;
import com.microsoft.azure.datalake.store.ContentSummaryProcessor;
import com.microsoft.azure.datalake.store.Core;
import com.microsoft.azure.datalake.store.DirectoryEntry;
import com.microsoft.azure.datalake.store.DirectoryEntryType;
import com.microsoft.azure.datalake.store.ExpiryOption;
import com.microsoft.azure.datalake.store.IfExists;
import com.microsoft.azure.datalake.store.OperationResponse;
import com.microsoft.azure.datalake.store.RequestOptions;
import com.microsoft.azure.datalake.store.SyncFlag;
import com.microsoft.azure.datalake.store.UserGroupRepresentation;
import com.microsoft.azure.datalake.store.acl.AclEntry;
import com.microsoft.azure.datalake.store.acl.AclStatus;
import com.microsoft.azure.datalake.store.oauth2.AccessTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.AzureADToken;
import com.microsoft.azure.datalake.store.oauth2.ClientCredsTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.RefreshTokenBasedTokenProvider;
import com.microsoft.azure.datalake.store.oauth2.UserPasswordTokenProvider;
import com.microsoft.azure.datalake.store.retrypolicies.ExponentialBackoffPolicy;
import com.microsoft.azure.datalake.store.retrypolicies.NoRetryPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADLStoreClient {
    private final String accountFQDN;
    private String accessToken;
    private final AccessTokenProvider tokenProvider;
    private static final Logger log = LoggerFactory.getLogger((String)"com.microsoft.azure.datalake.store");
    private static final AtomicLong clientIdCounter = new AtomicLong(0L);
    private final long clientId;
    private String userAgentString;
    private String tiHeader = null;
    private String proto = "https";
    private boolean enableRemoteExceptions = false;
    private String pathPrefix = null;
    private static String sdkVersion = null;
    private static String userAgent;

    private ADLStoreClient(String accountFQDN, String accessToken, long clientId, AccessTokenProvider tokenProvider) {
        this.accountFQDN = accountFQDN;
        this.accessToken = "Bearer " + accessToken;
        this.tokenProvider = tokenProvider;
        this.clientId = clientId;
        this.userAgentString = userAgent;
    }

    public static ADLStoreClient createClient(String accountFQDN, AzureADToken token) {
        if (accountFQDN == null || accountFQDN.trim().equals("")) {
            throw new IllegalArgumentException("account name is required");
        }
        if (token == null || token.accessToken == null || token.accessToken.equals("")) {
            throw new IllegalArgumentException("token is required");
        }
        long clientId = clientIdCounter.incrementAndGet();
        log.trace("ADLStoreClient {} created for {} using SDK version {}", new Object[]{clientId, accountFQDN, sdkVersion});
        return new ADLStoreClient(accountFQDN, token.accessToken, clientId, null);
    }

    public static ADLStoreClient createClient(String accountFQDN, String accessToken) {
        if (accountFQDN == null || accountFQDN.trim().equals("")) {
            throw new IllegalArgumentException("account name is required");
        }
        if (accessToken == null || accessToken.equals("")) {
            throw new IllegalArgumentException("token is required");
        }
        long clientId = clientIdCounter.incrementAndGet();
        log.trace("ADLStoreClient {} created for {} using SDK version {}", new Object[]{clientId, accountFQDN, sdkVersion});
        return new ADLStoreClient(accountFQDN, accessToken, clientId, null);
    }

    public static ADLStoreClient createClient(String accountFQDN, AccessTokenProvider tokenProvider) {
        if (accountFQDN == null || accountFQDN.trim().equals("")) {
            throw new IllegalArgumentException("account name is required");
        }
        if (tokenProvider == null) {
            throw new IllegalArgumentException("token provider is required");
        }
        long clientId = clientIdCounter.incrementAndGet();
        log.trace("ADLStoreClient {} created for {} using SDK version {}", new Object[]{clientId, accountFQDN, sdkVersion});
        return new ADLStoreClient(accountFQDN, null, clientId, tokenProvider);
    }

    public static ADLStoreClient createClient(String accountFQDN, ClientCredsTokenProvider tokenProvider) {
        return ADLStoreClient.createClient(accountFQDN, (AccessTokenProvider)tokenProvider);
    }

    public static ADLStoreClient createClient(String accountFQDN, RefreshTokenBasedTokenProvider tokenProvider) {
        return ADLStoreClient.createClient(accountFQDN, (AccessTokenProvider)tokenProvider);
    }

    public static ADLStoreClient createClient(String accountFQDN, UserPasswordTokenProvider tokenProvider) {
        return ADLStoreClient.createClient(accountFQDN, (AccessTokenProvider)tokenProvider);
    }

    public ADLFileOutputStream createFile(String path, IfExists mode) throws IOException {
        return this.createFile(path, mode, null, true);
    }

    public ADLFileOutputStream createFile(String path, IfExists mode, String octalPermission, boolean createParent) throws IOException {
        if (octalPermission != null && !octalPermission.equals("") && !Core.isValidOctal(octalPermission)) {
            throw new IllegalArgumentException("Invalid directory permissions specified: " + octalPermission);
        }
        if (log.isTraceEnabled()) {
            log.trace("create file for client {} for file {}", (Object)this.getClientId(), (Object)path);
        }
        String leaseId = UUID.randomUUID().toString();
        boolean overwrite = mode == IfExists.OVERWRITE;
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = overwrite ? new ExponentialBackoffPolicy() : new NoRetryPolicy();
        OperationResponse resp = new OperationResponse();
        Core.create(path, overwrite, octalPermission, null, 0, 0, leaseId, leaseId, createParent, SyncFlag.DATA, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error creating file " + path);
        }
        return new ADLFileOutputStream(path, this, true, leaseId);
    }

    public ADLFileInputStream getReadStream(String path) throws IOException {
        DirectoryEntry de = this.getDirectoryEntry(path);
        if (de.type == DirectoryEntryType.FILE) {
            return new ADLFileInputStream(path, de, this);
        }
        throw new ADLException("Path is not a file: " + path);
    }

    public ADLFileOutputStream getAppendStream(String path) throws IOException {
        String leaseId = UUID.randomUUID().toString();
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new NoRetryPolicy();
        OperationResponse resp = new OperationResponse();
        Core.append(path, -1L, null, 0, 0, leaseId, leaseId, SyncFlag.DATA, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error appending to file " + path);
        }
        return new ADLFileOutputStream(path, this, false, leaseId);
    }

    public boolean concatenateFiles(String path, List<String> fileList) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.concat(path, fileList, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error concatenating files into " + path);
        }
        return true;
    }

    public void setExpiryTime(String path, ExpiryOption expiryOption, long expiryTimeMilliseconds) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.setExpiryTime(path, expiryOption, expiryTimeMilliseconds, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error concatenating files into " + path);
        }
    }

    public List<DirectoryEntry> enumerateDirectory(String path) throws IOException {
        return this.enumerateDirectory(path, (UserGroupRepresentation)null);
    }

    public List<DirectoryEntry> enumerateDirectory(String path, UserGroupRepresentation oidOrUpn) throws IOException {
        return this.enumerateDirectory(path, Integer.MAX_VALUE, null, null, oidOrUpn);
    }

    public List<DirectoryEntry> enumerateDirectory(String path, int maxEntriesToRetrieve) throws IOException {
        return this.enumerateDirectory(path, maxEntriesToRetrieve, null, null);
    }

    public List<DirectoryEntry> enumerateDirectory(String path, String startAfter) throws IOException {
        return this.enumerateDirectory(path, Integer.MAX_VALUE, startAfter, null);
    }

    public List<DirectoryEntry> enumerateDirectory(String path, int maxEntriesToRetrieve, String startAfter) throws IOException {
        return this.enumerateDirectory(path, maxEntriesToRetrieve, startAfter, null);
    }

    public List<DirectoryEntry> enumerateDirectory(String path, String startAfter, String endBefore) throws IOException {
        return this.enumerateDirectory(path, Integer.MAX_VALUE, startAfter, endBefore);
    }

    public List<DirectoryEntry> enumerateDirectory(String path, int maxEntriesToRetrieve, String startAfter, String endBefore) throws IOException {
        return this.enumerateDirectory(path, maxEntriesToRetrieve, startAfter, endBefore, null);
    }

    public List<DirectoryEntry> enumerateDirectory(String path, int maxEntriesToRetrieve, String startAfter, String endBefore, UserGroupRepresentation oidOrUpn) throws IOException {
        int numEntriesToRequest;
        ArrayList list;
        boolean eol;
        ArrayList<DirectoryEntry> deList = new ArrayList<DirectoryEntry>();
        int pagesize = 4000;
        boolean bl = eol = maxEntriesToRetrieve <= 0;
        while (!eol && (list = (ArrayList)this.enumerateDirectoryInternal(path, numEntriesToRequest = Math.min(maxEntriesToRetrieve, pagesize), startAfter, endBefore, oidOrUpn)) != null && list.size() != 0) {
            int size = list.size();
            deList.addAll(list);
            startAfter = ((DirectoryEntry)list.get((int)(size - 1))).name;
            eol = (maxEntriesToRetrieve -= size) <= 0 || size < numEntriesToRequest;
        }
        return deList;
    }

    private List<DirectoryEntry> enumerateDirectoryInternal(String path, int maxEntriesToRetrieve, String startAfter, String endBefore, UserGroupRepresentation oidOrUpn) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        List<DirectoryEntry> dirEnt = Core.listStatus(path, startAfter, endBefore, maxEntriesToRetrieve, oidOrUpn, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error enumerating directory " + path);
        }
        return dirEnt;
    }

    public boolean createDirectory(String path) throws IOException {
        return this.createDirectory(path, null);
    }

    public boolean createDirectory(String path, String octalPermission) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        boolean succeeded = Core.mkdirs(path, octalPermission, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error creating directory " + path);
        }
        return succeeded;
    }

    public boolean deleteRecursive(String path) throws IOException {
        if (path.equals("/")) {
            throw new IllegalArgumentException("Cannot delete root directory tree");
        }
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        boolean succeeded = Core.delete(path, true, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error deleting directory tree " + path);
        }
        return succeeded;
    }

    public void removeDefaultAcls(String path) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.removeDefaultAcl(path, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error removing default ACLs for directory " + path);
        }
    }

    public boolean rename(String path, String newName) throws IOException {
        return this.rename(path, newName, false);
    }

    public boolean rename(String path, String newName, boolean overwrite) throws IOException {
        if (path == null || path.equals("")) {
            throw new IllegalArgumentException("Path cannot be null or empty");
        }
        if (path.equals("/")) {
            throw new IllegalArgumentException("Cannot rename root directory");
        }
        if (path.equals(newName)) {
            return this.getDirectoryEntry((String)path).type == DirectoryEntryType.FILE;
        }
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        boolean succeeded = Core.rename(path, newName, overwrite, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error renaming file " + path);
        }
        return succeeded;
    }

    public boolean delete(String path) throws IOException {
        if (path.equals("/")) {
            throw new IllegalArgumentException("Cannot delete root directory");
        }
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        boolean succeeded = Core.delete(path, false, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error deleting directory " + path);
        }
        return succeeded;
    }

    public DirectoryEntry getDirectoryEntry(String path) throws IOException {
        return this.getDirectoryEntry(path, null);
    }

    public DirectoryEntry getDirectoryEntry(String path, UserGroupRepresentation oidOrUpn) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        DirectoryEntry dirEnt = Core.getFileStatus(path, oidOrUpn, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error getting info for file " + path);
        }
        return dirEnt;
    }

    public ContentSummary getContentSummary(String path) throws IOException {
        return new ContentSummaryProcessor().getContentSummary(this, path);
    }

    public void setOwner(String path, String owner, String group) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.setOwner(path, owner, group, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error setting owner for file " + path);
        }
    }

    public void setTimes(String path, Date atime, Date mtime) throws IOException {
        long atimeLong = atime == null ? -1L : atime.getTime();
        long mtimeLong = mtime == null ? -1L : mtime.getTime();
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.setTimes(path, atimeLong, mtimeLong, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error setting times for file " + path);
        }
    }

    public boolean checkExists(String filename) throws IOException {
        if (filename == null || filename.trim().equals("")) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        try {
            this.getDirectoryEntry(filename);
        }
        catch (ADLException ex) {
            if (ex.httpResponseCode == 404) {
                return false;
            }
            throw ex;
        }
        return true;
    }

    public void createEmptyFile(String filename) throws IOException {
        if (filename == null || filename.trim().equals("")) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        ADLFileOutputStream out = this.createFile(filename, IfExists.FAIL);
        ((OutputStream)out).close();
    }

    public void setPermission(String path, String octalPermissions) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.setPermission(path, octalPermissions, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error setting times for " + path);
        }
    }

    public boolean checkAccess(String path, String rwx) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.checkAccess(path, rwx, this, opts, resp);
        if (!resp.successful) {
            if (resp.httpResponseCode == 401 || resp.httpResponseCode == 403) {
                return false;
            }
            throw this.getExceptionFromResponse(resp, "Error checking access for " + path);
        }
        return true;
    }

    public void modifyAclEntries(String path, List<AclEntry> aclSpec) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.modifyAclEntries(path, aclSpec, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error modifying ACLs for " + path);
        }
    }

    public void setAcl(String path, List<AclEntry> aclSpec) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.setAcl(path, aclSpec, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error setting ACLs for " + path);
        }
    }

    public void removeAclEntries(String path, List<AclEntry> aclSpec) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.removeAclEntries(path, aclSpec, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error removing ACLs for " + path);
        }
    }

    public void removeAllAcls(String path) throws IOException {
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        Core.removeAcl(path, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error removing all ACLs for file " + path);
        }
    }

    public AclStatus getAclStatus(String path) throws IOException {
        return this.getAclStatus(path, null);
    }

    public AclStatus getAclStatus(String path, UserGroupRepresentation oidOrUpn) throws IOException {
        AclStatus status = null;
        RequestOptions opts = new RequestOptions();
        opts.retryPolicy = new ExponentialBackoffPolicy();
        OperationResponse resp = new OperationResponse();
        status = Core.getAclStatus(path, oidOrUpn, this, opts, resp);
        if (!resp.successful) {
            throw this.getExceptionFromResponse(resp, "Error getting  ACL Status for " + path);
        }
        return status;
    }

    public synchronized void setOptions(ADLStoreOptions o) throws IOException {
        if (o.getFilePathPrefix() != null) {
            this.setFilePathPrefix(o.getFilePathPrefix());
        }
        if (o.isUsingInsecureTransport()) {
            this.setInsecureTransport();
        }
        if (o.isThrowingRemoteExceptionsEnabled()) {
            this.enableThrowingRemoteExceptions();
        }
        if (o.getUserAgentSuffix() != null) {
            this.setUserAgentSuffix(o.getUserAgentSuffix());
        }
    }

    public synchronized void updateToken(AzureADToken token) {
        log.trace("AAD Token Updated for client client {} for account {}", (Object)this.clientId, (Object)this.accountFQDN);
        this.accessToken = "Bearer " + token.accessToken;
    }

    public synchronized void updateToken(String accessToken) {
        log.trace("AAD Token Updated for client client {} for account {}", (Object)this.clientId, (Object)this.accountFQDN);
        this.accessToken = "Bearer " + accessToken;
    }

    synchronized String getAccessToken() throws IOException {
        if (this.tokenProvider != null) {
            return "Bearer " + this.tokenProvider.getToken().accessToken;
        }
        return this.accessToken;
    }

    String getAccountName() {
        return this.accountFQDN;
    }

    private synchronized void setUserAgentSuffix(String userAgentSuffix) {
        if (userAgentSuffix != null && !userAgentSuffix.trim().equals("")) {
            int pos;
            this.userAgentString = userAgent + "/" + userAgentSuffix;
            log.trace("ADLStoreClient {} created for {} changed User-Agent to {}", new Object[]{this.clientId, this.accountFQDN, this.userAgentString});
            this.tiHeader = userAgentSuffix.startsWith("hadoop-azure-datalake") ? ((pos = userAgentSuffix.indexOf(47)) > 0 && pos < userAgentSuffix.length() - 1 ? userAgentSuffix.substring(pos + 1) : null) : null;
        }
    }

    synchronized String getTiHeaderValue() {
        return this.tiHeader;
    }

    synchronized String getUserAgent() {
        return this.userAgentString;
    }

    private synchronized void setInsecureTransport() {
        this.proto = "http";
    }

    synchronized String getHttpPrefix() {
        return this.proto;
    }

    long getClientId() {
        return this.clientId;
    }

    private synchronized void enableThrowingRemoteExceptions() {
        this.enableRemoteExceptions = true;
    }

    synchronized boolean remoteExceptionsEnabled() {
        return this.enableRemoteExceptions;
    }

    private synchronized void setFilePathPrefix(String prefix) throws IOException {
        if (prefix == null || prefix.equals("")) {
            throw new IllegalArgumentException("prefix cannot be empty or null");
        }
        if (prefix.equals("/")) {
            return;
        }
        if (prefix.contains("//")) {
            throw new IllegalArgumentException("prefix cannot contain empty path element " + prefix);
        }
        if (prefix.charAt(0) != '/') {
            prefix = "/" + prefix;
        }
        if (prefix.charAt(prefix.length() - 1) == '/') {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        try {
            this.pathPrefix = new URI(null, null, prefix, null).toASCIIString();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid path prefix: " + prefix);
        }
    }

    synchronized String getFilePathPrefix() {
        return this.pathPrefix;
    }

    public IOException getExceptionFromResponse(OperationResponse resp, String defaultMessage) {
        String msg;
        String messageSuffix = " [ServerRequestId:" + resp.requestId + "]";
        if (this.remoteExceptionsEnabled() && resp.remoteExceptionJavaClassName != null && !resp.remoteExceptionJavaClassName.equals("")) {
            return ADLStoreClient.getRemoteException(resp.remoteExceptionJavaClassName, resp.remoteExceptionMessage + messageSuffix);
        }
        String string = msg = resp.message == null ? defaultMessage : defaultMessage + "\n" + resp.message;
        if (resp.ex != null) {
            msg = msg + "\nOperation " + resp.opCode + " failed with exception " + resp.ex.getClass().getName() + " : " + resp.ex.getMessage();
        } else if (resp.httpResponseCode > 0) {
            msg = msg + "\nOperation " + resp.opCode + " failed with HTTP" + resp.httpResponseCode + " : " + resp.remoteExceptionName;
        }
        msg = msg + "\nLast encountered exception thrown after " + (resp.numRetries + 1) + " tries. ";
        if (resp.exceptionHistory != null) {
            msg = msg + "[" + resp.exceptionHistory + "]";
        }
        msg = msg + "\n" + messageSuffix;
        ADLException ex = new ADLException(msg);
        ex.httpResponseCode = resp.httpResponseCode;
        ex.httpResponseMessage = resp.httpResponseMessage;
        ex.requestId = resp.requestId;
        ex.numRetries = resp.numRetries;
        ex.lastCallLatency = resp.lastCallLatency;
        ex.responseContentLength = resp.responseContentLength;
        ex.remoteExceptionName = resp.remoteExceptionName;
        ex.remoteExceptionMessage = resp.remoteExceptionMessage;
        ex.remoteExceptionJavaClassName = resp.remoteExceptionJavaClassName;
        ex.initCause(resp.ex);
        return ex;
    }

    private static IOException getRemoteException(String className, String message) {
        try {
            Class<?> clazz = Class.forName(className);
            if (!IOException.class.isAssignableFrom(clazz)) {
                return new IOException(message);
            }
            Constructor<?> c = clazz.getConstructor(String.class);
            return (IOException)c.newInstance(message);
        }
        catch (Exception ex) {
            return new IOException(message);
        }
    }

    static {
        InputStream is = ADLStoreClient.class.getResourceAsStream("/adlsdkversion.properties");
        if (is == null) {
            sdkVersion = "SDKVersionNotKnown";
        } else {
            Properties prop = new Properties();
            try {
                prop.load(is);
            }
            catch (IOException ex) {
                sdkVersion = "SDKVersionUnknown";
            }
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (sdkVersion == null) {
                sdkVersion = prop.getProperty("sdkversion", "SDKVersionMissing");
            }
        }
        System.setProperty("sun.net.http.retryPost", "false");
        userAgent = String.format("%s-%s/%s-%s/%s/%s-%s", "ADLSJavaSDK", sdkVersion, System.getProperty("os.name").replaceAll(" ", ""), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.vendor").replaceAll(" ", ""), System.getProperty("java.version"));
    }
}

