/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store.oauth2;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.azure.datalake.store.QueryParams;
import com.microsoft.azure.datalake.store.oauth2.AzureADToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureADAuthenticator {
    private static final Logger log = LoggerFactory.getLogger((String)AzureADAuthenticator.class.getName());

    public static AzureADToken getTokenUsingClientCreds(String authEndpoint, String clientId, String clientSecret) throws IOException {
        String resource = "https://management.core.windows.net/";
        QueryParams qp = new QueryParams();
        qp.add("resource", resource);
        qp.add("grant_type", "client_credentials");
        qp.add("client_id", clientId);
        qp.add("client_secret", clientSecret);
        log.debug("AADToken: starting to fetch token using client creds for client ID " + clientId);
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp);
    }

    public static AzureADToken getTokenUsingRefreshToken(String clientId, String refreshToken) throws IOException {
        String authEndpoint = "https://login.microsoftonline.com/Common/oauth2/token";
        QueryParams qp = new QueryParams();
        qp.add("grant_type", "refresh_token");
        qp.add("refresh_token", refreshToken);
        qp.add("client_id", clientId);
        log.debug("AADToken: starting to fetch token using refresh token for client ID " + clientId);
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp);
    }

    public static AzureADToken getTokenUsingUserCreds(String clientId, String username, String password) throws IOException {
        String authEndpoint = "https://login.microsoftonline.com/Common/oauth2/token";
        String resource = "https://management.core.windows.net/";
        QueryParams qp = new QueryParams();
        qp.add("grant_type", "password");
        qp.add("resource", resource);
        qp.add("scope", "openid");
        qp.add("client_id", clientId);
        qp.add("username", username);
        qp.add("password", password);
        log.debug("AADToken: starting to fetch token using username for user " + username);
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp);
    }

    private static AzureADToken getTokenCall(String authEndpoint, QueryParams qp) throws IOException {
        AzureADToken token = new AzureADToken();
        URL url = new URL(authEndpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.getOutputStream().write(qp.serialize().getBytes("UTF-8"));
        int httpResponseCode = conn.getResponseCode();
        if (httpResponseCode == 200) {
            try (InputStream httpResponseStream = conn.getInputStream();){
                int expiryPeriod = 0;
                JsonFactory jf = new JsonFactory();
                JsonParser jp = jf.createParser(httpResponseStream);
                jp.nextToken();
                while (jp.hasCurrentToken()) {
                    if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                        String fieldName = jp.getCurrentName();
                        jp.nextToken();
                        String fieldValue = jp.getText();
                        if (fieldName.equals("access_token")) {
                            token.accessToken = fieldValue;
                        }
                        if (fieldName.equals("expires_in")) {
                            expiryPeriod = Integer.parseInt(fieldValue);
                        }
                    }
                    jp.nextToken();
                }
                jp.close();
                long expiry = System.currentTimeMillis();
                token.expiry = new Date(expiry += (long)expiryPeriod * 1000L);
                log.debug("AADToken: fetched token with expiry " + token.expiry.toString());
            }
        } else {
            log.debug("AADToken: HTTP connection failed for getting token from AzureAD. Http response: " + httpResponseCode + " " + conn.getResponseMessage());
            throw new IOException("Failed to acquire token from AzureAD. Http response: " + httpResponseCode + " " + conn.getResponseMessage());
        }
        return token;
    }
}

