/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.datalake.store.oauth2;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.azure.datalake.store.QueryParams;
import com.microsoft.azure.datalake.store.oauth2.AzureADToken;
import com.microsoft.azure.datalake.store.retrypolicies.ExponentialBackoffPolicy;
import com.microsoft.azure.datalake.store.retrypolicies.ExponentialBackoffPolicyforMSI;
import com.microsoft.azure.datalake.store.retrypolicies.RetryPolicy;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureADAuthenticator {
    private static final Logger log = LoggerFactory.getLogger((String)AzureADAuthenticator.class.getName());
    static final String resource = "https://datalake.azure.net/";

    public static AzureADToken getTokenUsingClientCreds(String authEndpoint, String clientId, String clientSecret) throws IOException {
        QueryParams qp = new QueryParams();
        qp.add("resource", resource);
        qp.add("grant_type", "client_credentials");
        qp.add("client_id", clientId);
        qp.add("client_secret", clientSecret);
        log.debug("AADToken: starting to fetch token using client creds for client ID " + clientId);
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp.serialize(), null, null, null);
    }

    @Deprecated
    public static AzureADToken getTokenFromMsi(int localPort, String tenantGuid) throws IOException {
        return AzureADAuthenticator.getTokenFromMsi(tenantGuid, null, false);
    }

    public static AzureADToken getTokenFromMsi(String tenantGuid, String clientId, boolean bypassCache) throws IOException {
        String authEndpoint = "http://169.254.169.254/metadata/identity/oauth2/token";
        QueryParams qp = new QueryParams();
        qp.add("api-version", "2018-02-01");
        qp.add("resource", resource);
        if (tenantGuid != null && tenantGuid.length() > 0) {
            String authority = "https://login.microsoftonline.com/" + tenantGuid;
            qp.add("authority", authority);
        }
        if (clientId != null && clientId.length() > 0) {
            qp.add("client_id", clientId);
        }
        if (bypassCache) {
            qp.add("bypass_cache", "true");
        }
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("Metadata", "true");
        ExponentialBackoffPolicyforMSI retryPolicy = new ExponentialBackoffPolicyforMSI(3, 1000, 2);
        log.debug("AADToken: starting to fetch token using MSI");
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp.serialize(), headers, "GET", retryPolicy);
    }

    public static AzureADToken getTokenUsingRefreshToken(String clientId, String refreshToken) throws IOException {
        String authEndpoint = "https://login.microsoftonline.com/Common/oauth2/token";
        QueryParams qp = new QueryParams();
        qp.add("grant_type", "refresh_token");
        qp.add("refresh_token", refreshToken);
        if (clientId != null) {
            qp.add("client_id", clientId);
        }
        log.debug("AADToken: starting to fetch token using refresh token for client ID " + clientId);
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp.serialize(), null, null, null);
    }

    @Deprecated
    public static AzureADToken getTokenUsingUserCreds(String clientId, String username, String password) throws IOException {
        String authEndpoint = "https://login.microsoftonline.com/Common/oauth2/token";
        QueryParams qp = new QueryParams();
        qp.add("grant_type", "password");
        qp.add("resource", resource);
        qp.add("scope", "openid");
        qp.add("client_id", clientId);
        qp.add("username", username);
        qp.add("password", password);
        log.debug("AADToken: starting to fetch token using username for user " + username);
        return AzureADAuthenticator.getTokenCall(authEndpoint, qp.serialize(), null, null, null);
    }

    private static AzureADToken getTokenCall(String authEndpoint, String body, Hashtable<String, String> headers, String httpMethod, RetryPolicy retryPolicy) throws IOException {
        AzureADToken token = null;
        RetryPolicy retryPolicyUsed = retryPolicy != null ? retryPolicy : new ExponentialBackoffPolicy(3, 0, 1000, 2);
        int httperror = 0;
        String httpExceptionMessage = null;
        IOException ex = null;
        boolean succeeded = false;
        do {
            httperror = 0;
            String requestId = "";
            ex = null;
            try {
                token = AzureADAuthenticator.getTokenSingleCall(authEndpoint, body, headers, httpMethod);
            }
            catch (HttpException e) {
                httperror = e.httpErrorCode;
                requestId = e.requestId;
                httpExceptionMessage = e.getMessage();
            }
            catch (IOException e) {
                ex = e;
            }
            boolean bl = succeeded = httperror == 0 && ex == null;
        } while (!succeeded && retryPolicyUsed.shouldRetry(httperror, ex));
        if (!succeeded) {
            if (ex != null) {
                throw ex;
            }
            if (httperror != 0) {
                throw new IOException(httpExceptionMessage);
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AzureADToken getTokenSingleCall(String authEndpoint, String payload, Hashtable<String, String> headers, String httpMethod) throws IOException {
        AzureADToken token;
        block10: {
            token = null;
            HttpURLConnection conn = null;
            String urlString = authEndpoint;
            String string = httpMethod = httpMethod == null ? "POST" : httpMethod;
            if (httpMethod.equals("GET")) {
                urlString = urlString + "?" + payload;
            }
            try {
                URL url = new URL(urlString);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod(httpMethod);
                conn.setReadTimeout(30000);
                conn.setConnectTimeout(30000);
                if (headers != null && headers.size() > 0) {
                    for (String name : headers.keySet()) {
                        conn.setRequestProperty(name, headers.get(name));
                    }
                }
                conn.setRequestProperty("Connection", "close");
                if (httpMethod.equals("POST")) {
                    conn.setDoOutput(true);
                    conn.getOutputStream().write(payload.getBytes("UTF-8"));
                }
                int httpResponseCode = conn.getResponseCode();
                String requestId = conn.getHeaderField("x-ms-request-id");
                String responseContentType = conn.getHeaderField("Content-Type");
                long responseContentLength = conn.getHeaderFieldLong("Content-Length", 0L);
                String string2 = requestId = requestId == null ? "" : requestId;
                if (httpResponseCode == 200 && responseContentType.startsWith("application/json") && responseContentLength > 0L) {
                    InputStream httpResponseStream = conn.getInputStream();
                    token = AzureADAuthenticator.parseTokenFromStream(httpResponseStream);
                    break block10;
                }
                String responseBody = AzureADAuthenticator.consumeInputStream(conn.getInputStream(), 1024);
                String proxies = "none";
                String httpProxy = System.getProperty("http.proxy");
                String httpsProxy = System.getProperty("https.proxy");
                if (httpProxy != null || httpsProxy != null) {
                    proxies = "http:" + httpProxy + ";https:" + httpsProxy;
                }
                String logMessage = "AADToken: HTTP connection failed for getting token from AzureAD. Http response: " + httpResponseCode + " " + conn.getResponseMessage() + " Content-Type: " + responseContentType + " Content-Length: " + responseContentLength + " Request ID: " + requestId.toString() + " Proxies: " + proxies + " First 1K of Body: " + responseBody;
                log.debug(logMessage);
                throw new HttpException(httpResponseCode, requestId, logMessage);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return token;
    }

    private static AzureADToken parseTokenFromStream(InputStream httpResponseStream) throws IOException {
        AzureADToken token = new AzureADToken();
        try {
            int expiryPeriod = 0;
            JsonFactory jf = new JsonFactory();
            JsonParser jp = jf.createParser(httpResponseStream);
            jp.nextToken();
            while (jp.hasCurrentToken()) {
                if (jp.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = jp.getCurrentName();
                    jp.nextToken();
                    String fieldValue = jp.getText();
                    if (fieldName.equals("access_token")) {
                        token.accessToken = fieldValue;
                    }
                    if (fieldName.equals("expires_in")) {
                        expiryPeriod = Integer.parseInt(fieldValue);
                    }
                }
                jp.nextToken();
            }
            jp.close();
            long expiry = System.currentTimeMillis();
            token.expiry = new Date(expiry += (long)expiryPeriod * 1000L);
            log.debug("AADToken: fetched token with expiry " + token.expiry.toString());
        }
        catch (Exception ex) {
            log.debug("AADToken: got exception when parsing json token " + ex.toString());
            throw ex;
        }
        finally {
            httpResponseStream.close();
        }
        return token;
    }

    private static String consumeInputStream(InputStream inStream, int length) throws IOException {
        byte[] b = new byte[length];
        int totalBytesRead = 0;
        int bytesRead = 0;
        do {
            if ((bytesRead = inStream.read(b, totalBytesRead, length - totalBytesRead)) <= 0) continue;
            totalBytesRead += bytesRead;
        } while (bytesRead >= 0 && totalBytesRead < length);
        return new String(b, 0, totalBytesRead);
    }

    private static class HttpException
    extends IOException {
        public int httpErrorCode;
        public String requestId;

        public HttpException(int httpErrorCode, String requestId, String message) {
            super(message);
            this.httpErrorCode = httpErrorCode;
            this.requestId = requestId;
        }
    }
}

