/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.HashGenerator;
import com.microsoft.azure.documentdb.Partition;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Deprecated
final class ConsistentHashRing {
    private HashGenerator hashGenerator;
    private Partition[] partitions;
    private ArrayList<String> collectionLinks = new ArrayList();

    public ConsistentHashRing(Iterable<String> collectionLinks, int partitionsPerNode, HashGenerator hashGenerator) {
        if (collectionLinks == null) {
            throw new IllegalArgumentException("collectionLinks");
        }
        for (String collectionLink : collectionLinks) {
            this.collectionLinks.add(collectionLink);
        }
        if (partitionsPerNode <= 0) {
            throw new IllegalArgumentException("The partitions per node must greater than 0.");
        }
        if (hashGenerator == null) {
            throw new IllegalArgumentException("hashGenerator");
        }
        this.hashGenerator = hashGenerator;
        this.partitions = this.constructPartitions(this.collectionLinks, partitionsPerNode);
    }

    private static byte[] getBytes(Object partitionKey) {
        byte[] bytes = null;
        if (partitionKey instanceof String) {
            String str = (String)partitionKey;
            try {
                bytes = str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported type %s for partitionKey.", partitionKey.getClass()));
        }
        return bytes;
    }

    private static int lowerBoundSearch(Partition[] partitions, byte[] hashValue) {
        for (int i = 0; i < partitions.length - 1; ++i) {
            if (partitions[i].compareTo(hashValue) > 0 || partitions[i + 1].compareTo(hashValue) <= 0) continue;
            return i;
        }
        return partitions.length - 1;
    }

    public String getCollectionNode(Object partitionKey) {
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey");
        }
        int partition = this.findPartition(ConsistentHashRing.getBytes(partitionKey));
        return this.partitions[partition].getNode();
    }

    private Partition[] constructPartitions(ArrayList<String> collectionLinks, int partitionsPerNode) {
        int collectionsNodeCount = collectionLinks.size();
        Object[] partitions = new Partition[partitionsPerNode * collectionsNodeCount];
        int index = 0;
        for (String collectionNode : collectionLinks) {
            byte[] hashValue = this.hashGenerator.computeHash(ConsistentHashRing.getBytes(collectionNode));
            for (int i = 0; i < partitionsPerNode; ++i) {
                partitions[index++] = new Partition(hashValue, collectionNode);
                hashValue = this.hashGenerator.computeHash(hashValue);
            }
        }
        Arrays.sort(partitions);
        return partitions;
    }

    private int findPartition(byte[] key) {
        byte[] hashValue = this.hashGenerator.computeHash(key);
        return ConsistentHashRing.lowerBoundSearch(this.partitions, hashValue);
    }

    List<Map.Entry<String, Long>> getSerializedPartitionList() {
        ArrayList<Map.Entry<String, Long>> partitionList = new ArrayList<Map.Entry<String, Long>>();
        for (int i = 0; i < this.partitions.length; ++i) {
            ByteBuffer wrapped = ByteBuffer.wrap(this.partitions[i].getHashValue()).order(ByteOrder.LITTLE_ENDIAN);
            int num = wrapped.getInt();
            partitionList.add(new AbstractMap.SimpleEntry<String, Long>(this.partitions[i].getNode(), (long)num & 0xFFFFFFFFL));
        }
        return partitionList;
    }
}

