/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.documentdb.AccessConditionType;
import com.microsoft.azure.documentdb.Attachment;
import com.microsoft.azure.documentdb.ChangeFeedOptions;
import com.microsoft.azure.documentdb.Conflict;
import com.microsoft.azure.documentdb.ConnectionMode;
import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.ConsistencyLevel;
import com.microsoft.azure.documentdb.Database;
import com.microsoft.azure.documentdb.DatabaseAccount;
import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.DocumentQueryClientInternal;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.FeedResponse;
import com.microsoft.azure.documentdb.GlobalEndpointManager;
import com.microsoft.azure.documentdb.JsonSerializable;
import com.microsoft.azure.documentdb.MediaOptions;
import com.microsoft.azure.documentdb.MediaReadMode;
import com.microsoft.azure.documentdb.MediaResponse;
import com.microsoft.azure.documentdb.Offer;
import com.microsoft.azure.documentdb.PartitionKeyDefinition;
import com.microsoft.azure.documentdb.PartitionKeyRange;
import com.microsoft.azure.documentdb.PartitionResolver;
import com.microsoft.azure.documentdb.Permission;
import com.microsoft.azure.documentdb.QueryIterable;
import com.microsoft.azure.documentdb.RequestOptions;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.ResourceResponse;
import com.microsoft.azure.documentdb.SqlParameterCollection;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.StoredProcedure;
import com.microsoft.azure.documentdb.StoredProcedureResponse;
import com.microsoft.azure.documentdb.Trigger;
import com.microsoft.azure.documentdb.Undefined;
import com.microsoft.azure.documentdb.User;
import com.microsoft.azure.documentdb.UserDefinedFunction;
import com.microsoft.azure.documentdb.internal.AbstractDocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.AuthorizationTokenProvider;
import com.microsoft.azure.documentdb.internal.BaseAuthorizationTokenProvider;
import com.microsoft.azure.documentdb.internal.BaseDatabaseAccountConfigurationProvider;
import com.microsoft.azure.documentdb.internal.CollectionCacheInternal;
import com.microsoft.azure.documentdb.internal.DatabaseAccountConfigurationProvider;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.GatewayProxy;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.PathParser;
import com.microsoft.azure.documentdb.internal.QueryCompatibilityMode;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.RetryCreateDocumentDelegate;
import com.microsoft.azure.documentdb.internal.RetryRequestDelegate;
import com.microsoft.azure.documentdb.internal.RetryUtility;
import com.microsoft.azure.documentdb.internal.ServiceJNIWrapper;
import com.microsoft.azure.documentdb.internal.SessionContainer;
import com.microsoft.azure.documentdb.internal.SessionTokenHelper;
import com.microsoft.azure.documentdb.internal.StoreModel;
import com.microsoft.azure.documentdb.internal.UserAgentContainer;
import com.microsoft.azure.documentdb.internal.Utils;
import com.microsoft.azure.documentdb.internal.directconnectivity.AddressCache;
import com.microsoft.azure.documentdb.internal.directconnectivity.GatewayAddressCache;
import com.microsoft.azure.documentdb.internal.directconnectivity.HttpClientFactory;
import com.microsoft.azure.documentdb.internal.directconnectivity.HttpTransportClient;
import com.microsoft.azure.documentdb.internal.directconnectivity.ServerStoreModel;
import com.microsoft.azure.documentdb.internal.directconnectivity.TransportClient;
import com.microsoft.azure.documentdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.documentdb.internal.query.QueryPartitionProvider;
import com.microsoft.azure.documentdb.internal.routing.ClientCollectionCache;
import com.microsoft.azure.documentdb.internal.routing.CollectionCache;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyRangeCache;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyRangeIdentity;
import com.microsoft.azure.documentdb.internal.routing.RoutingMapProvider;
import com.microsoft.azure.documentdb.internal.routing.RoutingMapProviderHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentClient
implements AutoCloseable,
CollectionCacheInternal {
    @Deprecated
    protected static final String PartitionResolverErrorMessage = "Couldn't find any partition resolvers for the database link provided. Ensure that the link you used when registering the partition resolvers matches the link provided or you need to register both types of database link(self link as well as ID based link).";
    private static final Logger logger = LoggerFactory.getLogger(DocumentClient.class);
    private URI serviceEndpoint;
    private String masterKey;
    private Map<String, String> resourceTokens;
    private ConnectionPolicy connectionPolicy;
    private GatewayProxy gatewayProxy;
    private SessionContainer sessionContainer;
    private ConsistencyLevel desiredConsistencyLevel;
    private EndpointManager globalEndpointManager;
    private ConcurrentHashMap<String, PartitionResolver> partitionResolvers;
    private StoreModel storeModel;
    private AddressCache readAddressCache;
    private AddressCache writeAddressCache;
    private AddressCache alternateWriteAddressCache;
    private TransportClient transportClient;
    private AuthorizationTokenProvider authorizationTokenProvider;
    private DatabaseAccountConfigurationProvider databaseAccountConfigurationProvider;
    private ClientCollectionCache collectionCache;
    private PartitionKeyRangeCache partitionKeyRangeCache;
    private PoolingHttpClientConnectionManager poolingHttpClientConnectionManager;
    private ExecutorService executorService;
    private ObjectMapper objectMapper;
    private QueryCompatibilityMode queryCompatibilityMode = QueryCompatibilityMode.Default;

    public DocumentClient(String serviceEndpoint, String masterKey, ConnectionPolicy connectionPolicy, ConsistencyLevel desiredConsistencyLevel) {
        this(serviceEndpoint, masterKey, null, connectionPolicy, desiredConsistencyLevel, null, null, null, new UserAgentContainer());
    }

    public DocumentClient(String serviceEndpoint, String masterKey, ObjectMapper objectMapper, ConnectionPolicy connectionPolicy, ConsistencyLevel desiredConsistencyLevel) {
        this(serviceEndpoint, masterKey, objectMapper, connectionPolicy, desiredConsistencyLevel, null, null, null, new UserAgentContainer());
    }

    public DocumentClient(String serviceEndpoint, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel desiredConsistencyLevel) {
        this(serviceEndpoint, permissionFeed, null, connectionPolicy, desiredConsistencyLevel, new UserAgentContainer());
    }

    public DocumentClient(String serviceEndpoint, List<Permission> permissionFeed, ObjectMapper objectMapper, ConnectionPolicy connectionPolicy, ConsistencyLevel desiredConsistencyLevel) {
        this(serviceEndpoint, permissionFeed, objectMapper, connectionPolicy, desiredConsistencyLevel, new UserAgentContainer());
    }

    DocumentClient(String serviceEndpoint, List<Permission> permissionFeed, ObjectMapper objectMapper, ConnectionPolicy connectionPolicy, ConsistencyLevel desiredConsistencyLevel, UserAgentContainer userAgentContainer) {
        URI uri = null;
        try {
            uri = new URI(serviceEndpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid serviceEndPoint.", e);
        }
        this.resourceTokens = new HashMap<String, String>();
        this.objectMapper = objectMapper != null ? objectMapper : new ObjectMapper();
        for (Permission permission : permissionFeed) {
            String[] segments = StringUtils.split((String)permission.getResourceLink(), (char)'/');
            if (segments.length <= 0) {
                throw new IllegalArgumentException("link");
            }
            String resourceId = segments[segments.length - 1];
            this.resourceTokens.put(resourceId, permission.getToken());
        }
        this.initialize(uri, connectionPolicy, desiredConsistencyLevel, userAgentContainer);
    }

    DocumentClient(String serviceEndpoint, String masterKey, ObjectMapper objectMapper, ConnectionPolicy connectionPolicy, ConsistencyLevel desiredConsistencyLevel, AddressCache readAddressCache, AddressCache writeAddressCache, TransportClient transportClient, UserAgentContainer userAgentContainer) {
        URI uri = null;
        try {
            uri = new URI(serviceEndpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid serviceEndPoint.", e);
        }
        if (StringUtils.isEmpty((CharSequence)masterKey)) {
            throw new IllegalArgumentException("Invalid authentication key.");
        }
        this.masterKey = masterKey;
        this.objectMapper = objectMapper != null ? objectMapper : new ObjectMapper();
        this.readAddressCache = readAddressCache;
        this.writeAddressCache = writeAddressCache;
        this.transportClient = transportClient;
        this.initialize(uri, connectionPolicy, desiredConsistencyLevel, userAgentContainer);
    }

    private static String serializeProcedureParams(Object[] objectArray, ObjectMapper objectMapper) {
        Object[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof JsonSerializable) {
                stringArray[i] = ((JsonSerializable)object).toJson();
                continue;
            }
            if (object instanceof JSONObject) {
                stringArray[i] = object.toString();
                continue;
            }
            try {
                stringArray[i] = objectMapper.writeValueAsString(object);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
        return String.format("[%s]", StringUtils.join((Object[])stringArray, (String)","));
    }

    static void validateResource(Resource resource) {
        if (!StringUtils.isEmpty((CharSequence)resource.getId())) {
            if (resource.getId().indexOf(47) != -1 || resource.getId().indexOf(92) != -1 || resource.getId().indexOf(63) != -1 || resource.getId().indexOf(35) != -1) {
                throw new IllegalArgumentException("Id contains illegal chars.");
            }
            if (resource.getId().endsWith(" ")) {
                throw new IllegalArgumentException("Id ends with a space.");
            }
        }
    }

    private void initialize(URI serviceEndpoint, ConnectionPolicy connectionPolicy, ConsistencyLevel desiredConsistencyLevel, UserAgentContainer userAgentContainer) {
        logger.info("Initializing DocumentClient with serviceEndpoint [{}], ConnectionPolicy [{}], ConsistencyLevel [{}]", new Object[]{serviceEndpoint, connectionPolicy, desiredConsistencyLevel});
        this.serviceEndpoint = serviceEndpoint;
        this.connectionPolicy = connectionPolicy != null ? connectionPolicy : new ConnectionPolicy();
        this.desiredConsistencyLevel = desiredConsistencyLevel;
        String userAgentSuffix = this.connectionPolicy.getUserAgentSuffix();
        if (userAgentSuffix != null && userAgentSuffix.length() > 0) {
            userAgentContainer.setSuffix(userAgentSuffix);
        }
        this.executorService = new DocumentDBThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.poolingHttpClientConnectionManager = HttpClientFactory.createConnectionManager(this.connectionPolicy.getMaxPoolSize(), this.connectionPolicy.getIdleConnectionTimeout(), this.connectionPolicy.getRequestTimeout());
        HttpClient httpClient = HttpClientFactory.createHttpClient((HttpClientConnectionManager)this.poolingHttpClientConnectionManager, this.connectionPolicy.getRequestTimeout());
        HttpClient mediaHttpClient = HttpClientFactory.createHttpClient((HttpClientConnectionManager)this.poolingHttpClientConnectionManager, this.connectionPolicy.getMediaRequestTimeout());
        this.globalEndpointManager = new GlobalEndpointManager(this);
        this.partitionResolvers = new ConcurrentHashMap();
        this.authorizationTokenProvider = new BaseAuthorizationTokenProvider(this.masterKey);
        this.collectionCache = this.createClientCollectionCache(this, this.executorService);
        this.partitionKeyRangeCache = this.createPartitionKeyRangeCache();
        this.sessionContainer = new SessionContainer(this.serviceEndpoint.getHost(), this.collectionCache, this.partitionKeyRangeCache);
        this.gatewayProxy = this.createGatewayProxy(this.connectionPolicy, desiredConsistencyLevel, this.queryCompatibilityMode, this.masterKey, this.resourceTokens, userAgentContainer, this.globalEndpointManager, httpClient, mediaHttpClient, this.sessionContainer);
        DatabaseAccount databaseAccount = this.globalEndpointManager.getDatabaseAccountFromAnyEndpoint();
        this.databaseAccountConfigurationProvider = new BaseDatabaseAccountConfigurationProvider(databaseAccount, this.desiredConsistencyLevel);
        if (this.connectionPolicy.getConnectionMode() == ConnectionMode.DirectHttps) {
            if (this.readAddressCache == null) {
                this.readAddressCache = new GatewayAddressCache(this.globalEndpointManager.getReadEndpoint().toString(), this.connectionPolicy, this.collectionCache, this.partitionKeyRangeCache, userAgentContainer, this.authorizationTokenProvider, httpClient, this.globalEndpointManager, this, this.executorService);
            }
            if (this.writeAddressCache == null) {
                this.writeAddressCache = new GatewayAddressCache(this.globalEndpointManager.getWriteEndpoint().toString(), this.connectionPolicy, this.collectionCache, this.partitionKeyRangeCache, userAgentContainer, this.authorizationTokenProvider, httpClient, this.globalEndpointManager, this, this.executorService);
            }
            if (this.alternateWriteAddressCache == null) {
                this.alternateWriteAddressCache = new GatewayAddressCache(this.globalEndpointManager.getWriteEndpoint().toString(), this.connectionPolicy, this.collectionCache, this.partitionKeyRangeCache, userAgentContainer, this.authorizationTokenProvider, httpClient, this.globalEndpointManager, this, this.executorService);
            }
            if (this.transportClient == null) {
                this.transportClient = this.createHttpTransportClient(this.connectionPolicy, userAgentContainer);
            }
            this.storeModel = new ServerStoreModel(this.transportClient, this.readAddressCache, this.writeAddressCache, this.alternateWriteAddressCache, this.sessionContainer, this.databaseAccountConfigurationProvider, this.authorizationTokenProvider, this.executorService);
        } else {
            this.storeModel = this.gatewayProxy;
        }
        this.globalEndpointManager.refreshEndpointList();
    }

    ClientCollectionCache createClientCollectionCache(DocumentClient documentClient, ExecutorService executorService) {
        return new ClientCollectionCache(documentClient, executorService);
    }

    GatewayProxy createGatewayProxy(ConnectionPolicy connectionPolicy, ConsistencyLevel desiredConsistencyLevel, QueryCompatibilityMode queryCompatibilityMode, String masterKey, Map<String, String> resourceTokens, UserAgentContainer userAgentContainer, EndpointManager globalEndpointManager, HttpClient httpClient, HttpClient mediaHttpClient, SessionContainer sessionContainer) {
        return new GatewayProxy(connectionPolicy, desiredConsistencyLevel, queryCompatibilityMode, masterKey, resourceTokens, userAgentContainer, globalEndpointManager, httpClient, mediaHttpClient, sessionContainer);
    }

    HttpTransportClient createHttpTransportClient(ConnectionPolicy policy, UserAgentContainer userAgentContainer) {
        return new HttpTransportClient(this.connectionPolicy, userAgentContainer);
    }

    @Deprecated
    public void registerPartitionResolver(String databaseLink, PartitionResolver partitionResolver) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (partitionResolver == null) {
            throw new IllegalArgumentException("partitionResolver");
        }
        this.partitionResolvers.put(Utils.trimBeginingAndEndingSlashes(databaseLink), partitionResolver);
    }

    @Deprecated
    protected PartitionResolver getPartitionResolver(String databaseLink) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.partitionResolvers.get(Utils.trimBeginingAndEndingSlashes(databaseLink));
    }

    QueryCompatibilityMode getQueryCompatiblityMode() {
        return this.queryCompatibilityMode;
    }

    public URI getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public URI getWriteEndpoint() {
        return this.globalEndpointManager.getWriteEndpoint();
    }

    public URI getReadEndpoint() {
        return this.globalEndpointManager.getReadEndpoint();
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    EndpointManager getEndpointManager() {
        return this.globalEndpointManager;
    }

    void setEndpointManager(EndpointManager endpointManager) {
        this.globalEndpointManager = endpointManager;
    }

    RoutingMapProvider getPartitionKeyRangeCache() {
        return this.partitionKeyRangeCache;
    }

    CollectionCache getCollectionCache() {
        return this.collectionCache;
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    String getSessionToken(String collectionLink) {
        return this.sessionContainer.resolveGlobalSessionToken(collectionLink);
    }

    PoolingHttpClientConnectionManager getPoolHttpClientConnectionManager() {
        return this.poolingHttpClientConnectionManager;
    }

    void setGatewayProxyOverride(GatewayProxy proxyOverride) {
        this.gatewayProxy = proxyOverride;
        if (this.connectionPolicy.getConnectionMode() != ConnectionMode.DirectHttps) {
            this.storeModel = proxyOverride;
        }
    }

    void setStoreModel(StoreModel storeModel) {
        if (this.connectionPolicy.getConnectionMode() == ConnectionMode.DirectHttps) {
            this.storeModel = storeModel;
        }
    }

    void setCollectionCache(ClientCollectionCache clientCollectionCache) {
        this.collectionCache = clientCollectionCache;
    }

    public ResourceResponse<Database> createDatabase(Database database, RequestOptions options) throws DocumentClientException {
        if (database == null) {
            throw new IllegalArgumentException("Database");
        }
        logger.debug("Creating a Database. id: [{}]", (Object)database.getId());
        DocumentClient.validateResource(database);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Create, ResourceType.Database, "/dbs", database, requestHeaders);
        return new ResourceResponse<Database>(this.doCreate(request), Database.class);
    }

    public ResourceResponse<Database> deleteDatabase(String databaseLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        logger.debug("Deleting a Database. databaseLink: [{}]", (Object)databaseLink);
        String path = Utils.joinPath(databaseLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Delete, ResourceType.Database, path, requestHeaders);
        return new ResourceResponse<Database>(this.doDelete(request), Database.class);
    }

    public ResourceResponse<Database> readDatabase(String databaseLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        logger.debug("Reading a Database. databaseLink: [{}]", (Object)databaseLink);
        String path = Utils.joinPath(databaseLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.Database, path, requestHeaders);
        return new ResourceResponse<Database>(this.doRead(request), Database.class);
    }

    public FeedResponse<Database> readDatabases(FeedOptions options) {
        logger.debug("Reading Databases.");
        return new FeedResponse<Database>(new QueryIterable<Database>(this, ResourceType.Database, Database.class, "/dbs", options));
    }

    public FeedResponse<Database> queryDatabases(String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        return this.queryDatabases(new SqlQuerySpec(query, null), options);
    }

    public FeedResponse<Database> queryDatabases(SqlQuerySpec querySpec, FeedOptions options) {
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        logger.debug("Querying Databases. querySpec: [{}]", (Object)querySpec);
        return new FeedResponse<Database>(new QueryIterable<Database>(this, ResourceType.Database, Database.class, "/dbs", querySpec, options));
    }

    public ResourceResponse<DocumentCollection> createCollection(String databaseLink, DocumentCollection collection, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (collection == null) {
            throw new IllegalArgumentException("collection");
        }
        logger.debug("Creating a Collection. databaseLink: [{}], Collection id: [{}]", (Object)databaseLink, (Object)collection.getId());
        DocumentClient.validateResource(collection);
        String path = Utils.joinPath(databaseLink, "colls");
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Create, ResourceType.DocumentCollection, path, collection, requestHeaders);
        return new ResourceResponse<DocumentCollection>(this.doCreate(request), DocumentCollection.class);
    }

    public ResourceResponse<DocumentCollection> replaceCollection(DocumentCollection collection, RequestOptions options) throws DocumentClientException {
        if (collection == null) {
            throw new IllegalArgumentException("collection");
        }
        logger.debug("Replacing a Collection. id: [{}]", (Object)collection.getId());
        DocumentClient.validateResource(collection);
        String path = Utils.joinPath(collection.getSelfLink(), null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Replace, ResourceType.DocumentCollection, path, collection, requestHeaders);
        return new ResourceResponse<DocumentCollection>(this.doReplace(request), DocumentCollection.class);
    }

    public ResourceResponse<DocumentCollection> deleteCollection(String collectionLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        logger.debug("Deleting a Collection. collectionLink: [{}]", (Object)collectionLink);
        String path = Utils.joinPath(collectionLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Delete, ResourceType.DocumentCollection, path, requestHeaders);
        return new ResourceResponse<DocumentCollection>(this.doDelete(request), DocumentCollection.class);
    }

    @Override
    public ResourceResponse<DocumentCollection> readCollection(String collectionLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        logger.debug("Reading a Collection. collectionLink: [{}]", (Object)collectionLink);
        String path = Utils.joinPath(collectionLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.DocumentCollection, path, requestHeaders);
        return new ResourceResponse<DocumentCollection>(this.doRead(request), DocumentCollection.class);
    }

    public FeedResponse<DocumentCollection> readCollections(String databaseLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        logger.debug("Reading Collections. databaseLink: [{}]", (Object)databaseLink);
        String path = Utils.joinPath(databaseLink, "colls");
        return new FeedResponse<DocumentCollection>(new QueryIterable<DocumentCollection>(this, ResourceType.DocumentCollection, DocumentCollection.class, path, options));
    }

    public FeedResponse<DocumentCollection> queryCollections(String databaseLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        return this.queryCollections(databaseLink, new SqlQuerySpec(query, null), options);
    }

    public FeedResponse<DocumentCollection> queryCollections(String databaseLink, SqlQuerySpec querySpec, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        logger.debug("Querying Collections. databaseLink: [{}], querySpec [{}]", (Object)databaseLink, (Object)querySpec);
        String path = Utils.joinPath(databaseLink, "colls");
        return new FeedResponse<DocumentCollection>(new QueryIterable<DocumentCollection>(this, ResourceType.DocumentCollection, DocumentCollection.class, path, querySpec, options));
    }

    public ResourceResponse<Document> createDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) throws DocumentClientException {
        logger.debug("Creating a Document. collectionLink: [{}]", (Object)collectionLink);
        final String documentCollectionLink = this.getTargetDocumentCollectionLink(collectionLink, document);
        final Object documentLocal = document;
        final RequestOptions optionsLocal = options;
        final boolean disableAutomaticIdGenerationLocal = disableAutomaticIdGeneration;
        boolean shouldRetry = options == null || options.getPartitionKey() == null;
        RetryCreateDocumentDelegate createDelegate = new RetryCreateDocumentDelegate(){

            @Override
            public ResourceResponse<Document> apply() throws DocumentClientException {
                DocumentServiceRequest request = DocumentClient.this.getCreateDocumentRequest(documentCollectionLink, documentLocal, optionsLocal, disableAutomaticIdGenerationLocal, OperationType.Create);
                return new ResourceResponse<Document>(DocumentClient.this.doCreate(request), Document.class);
            }
        };
        return shouldRetry ? RetryUtility.executeCreateDocument(createDelegate, this.collectionCache, documentCollectionLink) : createDelegate.apply();
    }

    public ResourceResponse<Document> upsertDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) throws DocumentClientException {
        logger.debug("Upserting a Document. collectionLink: [{}]", (Object)collectionLink);
        final String documentCollectionLink = this.getTargetDocumentCollectionLink(collectionLink, document);
        final Object documentLocal = document;
        final RequestOptions optionsLocal = options;
        final boolean disableAutomaticIdGenerationLocal = disableAutomaticIdGeneration;
        boolean shouldRetry = options == null || options.getPartitionKey() == null;
        RetryCreateDocumentDelegate upsertDelegate = new RetryCreateDocumentDelegate(){

            @Override
            public ResourceResponse<Document> apply() throws DocumentClientException {
                DocumentServiceRequest request = DocumentClient.this.getCreateDocumentRequest(documentCollectionLink, documentLocal, optionsLocal, disableAutomaticIdGenerationLocal, OperationType.Upsert);
                return new ResourceResponse<Document>(DocumentClient.this.doUpsert(request), Document.class);
            }
        };
        return shouldRetry ? RetryUtility.executeCreateDocument(upsertDelegate, this.collectionCache, documentCollectionLink) : upsertDelegate.apply();
    }

    private String getTargetDocumentCollectionLink(String collectionLink, Object document) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        String documentCollectionLink = collectionLink;
        if (Utils.isDatabaseLink(collectionLink)) {
            PartitionResolver partitionResolver = this.getPartitionResolver(collectionLink);
            if (partitionResolver != null) {
                documentCollectionLink = partitionResolver.resolveForCreate(document);
            } else {
                throw new IllegalArgumentException(PartitionResolverErrorMessage);
            }
        }
        return documentCollectionLink;
    }

    private DocumentServiceRequest getCreateDocumentRequest(String documentCollectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)documentCollectionLink)) {
            throw new IllegalArgumentException("documentCollectionLink");
        }
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        Document typedDocument = Document.FromObject(document, this.objectMapper);
        DocumentClient.validateResource(typedDocument);
        if (typedDocument.getId() == null && !disableAutomaticIdGeneration) {
            typedDocument.setId(Utils.getSecureRandomUUID().toString());
        }
        String path = Utils.joinPath(documentCollectionLink, "docs");
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(operationType, ResourceType.Document, path, typedDocument, requestHeaders);
        this.addPartitionKeyInformation(request, typedDocument, options);
        return request;
    }

    public ResourceResponse<Document> replaceDocument(String documentLink, Object document, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        Document typedDocument = Document.FromObject(document, this.objectMapper);
        return this.replaceDocumentInternal(documentLink, typedDocument, options);
    }

    public ResourceResponse<Document> replaceDocument(Document document, RequestOptions options) throws DocumentClientException {
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        return this.replaceDocumentInternal(document.getSelfLink(), document, options);
    }

    private ResourceResponse<Document> replaceDocumentInternal(String documentLink, Document document, RequestOptions options) throws DocumentClientException {
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        logger.debug("Replacing a Document. documentLink: [{}]", (Object)documentLink);
        String documentCollectionName = Utils.getCollectionName(documentLink);
        String documentCollectionLink = this.getTargetDocumentCollectionLink(documentCollectionName, document);
        String path = Utils.joinPath(documentLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        final DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Replace, ResourceType.Document, path, document, requestHeaders);
        this.addPartitionKeyInformation(request, document, options);
        boolean shouldRetry = options == null || options.getPartitionKey() == null;
        DocumentClient.validateResource(document);
        RetryCreateDocumentDelegate replaceDelegate = new RetryCreateDocumentDelegate(){

            @Override
            public ResourceResponse<Document> apply() throws DocumentClientException {
                return new ResourceResponse<Document>(DocumentClient.this.doReplace(request), Document.class);
            }
        };
        return shouldRetry ? RetryUtility.executeCreateDocument(replaceDelegate, this.collectionCache, documentCollectionLink) : replaceDelegate.apply();
    }

    public ResourceResponse<Document> deleteDocument(String documentLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        logger.debug("Deleting a Document. documentLink: [{}]", (Object)documentLink);
        String path = Utils.joinPath(documentLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Delete, ResourceType.Document, path, requestHeaders);
        this.addPartitionKeyInformation(request, null, options);
        return new ResourceResponse<Document>(this.doDelete(request), Document.class);
    }

    public ResourceResponse<Document> readDocument(String documentLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        logger.debug("Reading a Document. documentLink: [{}]", (Object)documentLink);
        String path = Utils.joinPath(documentLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.Document, path, requestHeaders);
        this.addPartitionKeyInformation(request, null, options);
        return new ResourceResponse<Document>(this.doRead(request), Document.class);
    }

    public FeedResponse<Document> readDocuments(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        logger.debug("Reading Documents. collectionLink: [{}]", (Object)collectionLink);
        String path = Utils.joinPath(collectionLink, "docs");
        return new FeedResponse<Document>(new QueryIterable<Document>(this, ResourceType.Document, Document.class, path, options));
    }

    public FeedResponse<Document> queryDocuments(String collectionLink, String query, FeedOptions options) {
        return this.queryDocuments(collectionLink, query, options, null);
    }

    public FeedResponse<Document> queryDocuments(String collectionLink, String query, FeedOptions options, Object partitionKey) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        return this.queryDocuments(collectionLink, new SqlQuerySpec(query, null), options, partitionKey);
    }

    public FeedResponse<Document> queryDocuments(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.queryDocuments(collectionLink, querySpec, options, null);
    }

    public FeedResponse<Document> queryDocuments(String collectionLink, SqlQuerySpec querySpec, FeedOptions options, Object partitionKey) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        logger.debug("Querying Documents. collectionLink: [{}], querySpec [{}]", (Object)collectionLink, (Object)querySpec);
        String path = Utils.isDatabaseLink(collectionLink) ? collectionLink : Utils.joinPath(collectionLink, "docs");
        return new FeedResponse<Document>(new QueryIterable<Document>(this, ResourceType.Document, Document.class, path, querySpec, options, partitionKey));
    }

    public List<Object> queryAggregateValues(String collectionLink, String query, FeedOptions feedOptions) {
        return this.queryAggregateValues(collectionLink, new SqlQuerySpec(query, null), feedOptions);
    }

    public List<Object> queryAggregateValues(String collectionLink, String query, FeedOptions feedOptions, String partitionKey) {
        return this.queryAggregateValues(collectionLink, new SqlQuerySpec(query, null), feedOptions, (Object)partitionKey);
    }

    public List<Object> queryAggregateValues(String collectionLink, SqlQuerySpec querySpec, FeedOptions feedOptions) {
        return this.queryAggregateValues(collectionLink, querySpec, feedOptions, null);
    }

    public List<Object> queryAggregateValues(String collectionLink, SqlQuerySpec querySpec, FeedOptions feedOptions, Object partitionKey) {
        List<Document> items = this.queryDocuments(collectionLink, querySpec, feedOptions, partitionKey).getQueryIterable().toList();
        ArrayList<Object> values = new ArrayList<Object>(items.size());
        for (Document item : items) {
            if (item.propertyBag.length() > 0) {
                values.add(item.propertyBag.get(item.propertyBag.keys().next().toString()));
                continue;
            }
            values.add(null);
        }
        return values;
    }

    public FeedResponse<Document> queryDocumentChangeFeed(String collectionLink, ChangeFeedOptions changeFeedOptions) {
        return this.queryChangeFeed(collectionLink, ResourceType.Document, Document.class, changeFeedOptions);
    }

    <T extends Resource> FeedResponse<T> queryChangeFeed(String collectionLink, ResourceType resourceType, Class<T> type, ChangeFeedOptions changeFeedOptions) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (changeFeedOptions == null) {
            changeFeedOptions = new ChangeFeedOptions();
        }
        logger.debug("Querying {} change feed. collectionLink: [{}]", (Object)resourceType, (Object)collectionLink);
        String path = Utils.joinPath(collectionLink, Utils.getResourceSegement(resourceType));
        return new FeedResponse<T>(new QueryIterable<T>(this, resourceType, type, path, changeFeedOptions), true);
    }

    public ResourceResponse<StoredProcedure> createStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) throws DocumentClientException {
        logger.debug("Creating a StoredProcedure. collectionLink: [{}], storedProcedure id [{}]", (Object)collectionLink, (Object)storedProcedure.getId());
        DocumentServiceRequest request = this.getStoredProcedureRequest(collectionLink, storedProcedure, options, OperationType.Create);
        return new ResourceResponse<StoredProcedure>(this.doCreate(request), StoredProcedure.class);
    }

    public ResourceResponse<StoredProcedure> upsertStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) throws DocumentClientException {
        logger.debug("Upserting a StoredProcedure. collectionLink: [{}], storedProcedure id [{}]", (Object)collectionLink, (Object)storedProcedure.getId());
        DocumentServiceRequest request = this.getStoredProcedureRequest(collectionLink, storedProcedure, options, OperationType.Upsert);
        return new ResourceResponse<StoredProcedure>(this.doUpsert(request), StoredProcedure.class);
    }

    private DocumentServiceRequest getStoredProcedureRequest(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (storedProcedure == null) {
            throw new IllegalArgumentException("storedProcedure");
        }
        DocumentClient.validateResource(storedProcedure);
        String path = Utils.joinPath(collectionLink, "sprocs");
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(operationType, ResourceType.StoredProcedure, path, storedProcedure, requestHeaders);
        return request;
    }

    public ResourceResponse<StoredProcedure> replaceStoredProcedure(StoredProcedure storedProcedure, RequestOptions options) throws DocumentClientException {
        if (storedProcedure == null) {
            throw new IllegalArgumentException("storedProcedure");
        }
        logger.debug("Replacing a StoredProcedure. storedProcedure id [{}]", (Object)storedProcedure.getId());
        DocumentClient.validateResource(storedProcedure);
        String path = Utils.joinPath(storedProcedure.getSelfLink(), null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Replace, ResourceType.StoredProcedure, path, storedProcedure, requestHeaders);
        return new ResourceResponse<StoredProcedure>(this.doReplace(request), StoredProcedure.class);
    }

    public ResourceResponse<StoredProcedure> deleteStoredProcedure(String storedProcedureLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)storedProcedureLink)) {
            throw new IllegalArgumentException("storedProcedureLink");
        }
        logger.debug("Deleting a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
        String path = Utils.joinPath(storedProcedureLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Delete, ResourceType.StoredProcedure, path, requestHeaders);
        return new ResourceResponse<StoredProcedure>(this.doDelete(request), StoredProcedure.class);
    }

    public ResourceResponse<StoredProcedure> readStoredProcedure(String storedProcedureLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)storedProcedureLink)) {
            throw new IllegalArgumentException("storedProcedureLink");
        }
        logger.debug("Reading a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
        String path = Utils.joinPath(storedProcedureLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.StoredProcedure, path, requestHeaders);
        return new ResourceResponse<StoredProcedure>(this.doRead(request), StoredProcedure.class);
    }

    public FeedResponse<StoredProcedure> readStoredProcedures(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        logger.debug("Reading StoredProcedures. collectionLink [{}]", (Object)collectionLink);
        String path = Utils.joinPath(collectionLink, "sprocs");
        return new FeedResponse<StoredProcedure>(new QueryIterable<StoredProcedure>(this, ResourceType.StoredProcedure, StoredProcedure.class, path, options));
    }

    public FeedResponse<StoredProcedure> queryStoredProcedures(String collectionLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        return this.queryStoredProcedures(collectionLink, new SqlQuerySpec(query, null), options);
    }

    public FeedResponse<StoredProcedure> queryStoredProcedures(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        logger.debug("Querying StoredProcedures. collectionLink [{}], querySpec [{}]", (Object)collectionLink, (Object)querySpec);
        String path = Utils.joinPath(collectionLink, "sprocs");
        return new FeedResponse<StoredProcedure>(new QueryIterable<StoredProcedure>(this, ResourceType.StoredProcedure, StoredProcedure.class, path, querySpec, options));
    }

    public StoredProcedureResponse executeStoredProcedure(String storedProcedureLink, Object[] procedureParams) throws DocumentClientException {
        return this.executeStoredProcedure(storedProcedureLink, null, procedureParams);
    }

    public StoredProcedureResponse executeStoredProcedure(String storedProcedureLink, RequestOptions options, Object[] procedureParams) throws DocumentClientException {
        logger.debug("Executing a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
        String path = Utils.joinPath(storedProcedureLink, null);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Accept", "application/json");
        if (options != null) {
            if (options.getPartitionKey() != null) {
                requestHeaders.put("x-ms-documentdb-partitionkey", options.getPartitionKey().toString());
            }
            if (options.getPartitionKeyRangeId() != null) {
                requestHeaders.put("x-ms-documentdb-partitionkeyrangeid", options.getPartitionKeyRangeId());
            }
            if (options.isScriptLoggingEnabled()) {
                requestHeaders.put("x-ms-documentdb-script-enable-logging", String.valueOf(true));
            }
        }
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.ExecuteJavaScript, ResourceType.StoredProcedure, path, procedureParams != null ? DocumentClient.serializeProcedureParams(procedureParams, this.objectMapper) : "", requestHeaders);
        if (options != null && options.getPartitionKeyRangeId() != null) {
            PartitionKeyRangeIdentity partitionKeyRangeId = new PartitionKeyRangeIdentity(options.getPartitionKeyRangeId());
            request.setPartitionKeyRangeIdentity(partitionKeyRangeId);
        } else {
            this.addPartitionKeyInformation(request, null, options);
        }
        return new StoredProcedureResponse(this.doCreate(request));
    }

    public ResourceResponse<Trigger> createTrigger(String collectionLink, Trigger trigger, RequestOptions options) throws DocumentClientException {
        logger.debug("Creating a Trigger. collectionLink [{}], trigger id [{}]", (Object)collectionLink, (Object)trigger.getId());
        DocumentServiceRequest request = this.getTriggerRequest(collectionLink, trigger, options, OperationType.Create);
        return new ResourceResponse<Trigger>(this.doCreate(request), Trigger.class);
    }

    public ResourceResponse<Trigger> upsertTrigger(String collectionLink, Trigger trigger, RequestOptions options) throws DocumentClientException {
        logger.debug("Upserting a Trigger. collectionLink [{}], trigger id [{}]", (Object)collectionLink, (Object)trigger.getId());
        DocumentServiceRequest request = this.getTriggerRequest(collectionLink, trigger, options, OperationType.Upsert);
        return new ResourceResponse<Trigger>(this.doUpsert(request), Trigger.class);
    }

    private DocumentServiceRequest getTriggerRequest(String collectionLink, Trigger trigger, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (trigger == null) {
            throw new IllegalArgumentException("trigger");
        }
        DocumentClient.validateResource(trigger);
        String path = Utils.joinPath(collectionLink, "triggers");
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(operationType, ResourceType.Trigger, path, trigger, requestHeaders);
        return request;
    }

    public ResourceResponse<Trigger> replaceTrigger(Trigger trigger, RequestOptions options) throws DocumentClientException {
        if (trigger == null) {
            throw new IllegalArgumentException("trigger");
        }
        logger.debug("Replacing a Trigger. trigger id [{}]", (Object)trigger.getId());
        DocumentClient.validateResource(trigger);
        String path = Utils.joinPath(trigger.getSelfLink(), null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Replace, ResourceType.Trigger, path, trigger, requestHeaders);
        return new ResourceResponse<Trigger>(this.doReplace(request), Trigger.class);
    }

    public ResourceResponse<Trigger> deleteTrigger(String triggerLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)triggerLink)) {
            throw new IllegalArgumentException("triggerLink");
        }
        logger.debug("Deleting a Trigger. triggerLink [{}]", (Object)triggerLink);
        String path = Utils.joinPath(triggerLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Delete, ResourceType.Trigger, path, requestHeaders);
        return new ResourceResponse<Trigger>(this.doDelete(request), Trigger.class);
    }

    public ResourceResponse<Trigger> readTrigger(String triggerLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)triggerLink)) {
            throw new IllegalArgumentException("triggerLink");
        }
        logger.debug("Reading a Trigger. triggerLink [{}]", (Object)triggerLink);
        String path = Utils.joinPath(triggerLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.Trigger, path, requestHeaders);
        return new ResourceResponse<Trigger>(this.doRead(request), Trigger.class);
    }

    public FeedResponse<Trigger> readTriggers(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        logger.debug("Reading Triggers. collectionLink [{}]", (Object)collectionLink);
        String path = Utils.joinPath(collectionLink, "triggers");
        return new FeedResponse<Trigger>(new QueryIterable<Trigger>(this, ResourceType.Trigger, Trigger.class, path, options));
    }

    public FeedResponse<Trigger> queryTriggers(String collectionLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        return this.queryTriggers(collectionLink, new SqlQuerySpec(query, null), options);
    }

    public FeedResponse<Trigger> queryTriggers(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        logger.debug("Querying Triggers. collectionLink [{}], querySpec [{}]", (Object)collectionLink, (Object)querySpec);
        String path = Utils.joinPath(collectionLink, "triggers");
        return new FeedResponse<Trigger>(new QueryIterable<Trigger>(this, ResourceType.Trigger, Trigger.class, path, querySpec, options));
    }

    public FeedResponse<PartitionKeyRange> readPartitionKeyRanges(String collectionLink, FeedOptions options) {
        String path;
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        logger.trace("Reading PartitionKeyRanges. collectionLink [{}]", (Object)collectionLink);
        String string = path = collectionLink.endsWith("pkranges") ? collectionLink : Utils.joinPath(collectionLink, "pkranges");
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return new FeedResponse<PartitionKeyRange>(new QueryIterable<PartitionKeyRange>(this, ResourceType.PartitionKeyRange, PartitionKeyRange.class, path, options));
    }

    public FeedResponse<PartitionKeyRange> readPartitionKeyRanges(DocumentCollection documentCollection, FeedOptions options) {
        if (documentCollection == null) {
            throw new IllegalArgumentException("collection");
        }
        return this.readPartitionKeyRanges(documentCollection.getSelfLink(), options);
    }

    public Collection<PartitionKeyRange> readPartitionKeyRanges(String collectionLink, String query) throws DocumentClientException {
        String path = collectionLink;
        DocumentCollection collection = this.collectionCache.resolveByName(collectionLink);
        if (ServiceJNIWrapper.isServiceJNIAvailable()) {
            QueryPartitionProvider queryPartitionProvider = new QueryPartitionProvider(this.getDatabaseAccountConfigurationProvider().getQueryEngineConfiguration());
            PartitionedQueryExecutionInfo partitionedQueryExecutionInfo = queryPartitionProvider.getPartitionQueryExcecutionInfo(new SqlQuerySpec(query), collection.getPartitionKey());
            Collection<PartitionKeyRange> partitionKeyRanges = RoutingMapProviderHelper.getOverlappingRanges(this.getPartitionKeyRangeCache(), path, partitionedQueryExecutionInfo.getQueryRanges());
            return partitionKeyRanges;
        }
        SqlQuerySpec querySpec = new SqlQuerySpec(query, new SqlParameterCollection());
        FeedOptions options = new FeedOptions();
        options.setEnableCrossPartitionQuery(true);
        options.setMaxDegreeOfParallelism(Integer.MAX_VALUE);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-ms-documentdb-query-enablecrosspartition", String.valueOf(true));
        headers.put("x-ms-documentdb-query-parallelizecrosspartitionquery", String.valueOf(true));
        headers.put("x-ms-max-item-count", String.valueOf(1));
        Collection<Object> partitionKeyRanges = new ArrayList();
        try {
            String[] parts;
            DocumentServiceResponse response;
            String sessionToken;
            DocumentServiceRequest request = DocumentServiceRequest.create(ResourceType.Document, path, querySpec, QueryCompatibilityMode.Default, headers);
            if (!Utils.isCollectionPartitioned(collection).booleanValue()) {
                request.routeTo(new PartitionKeyRangeIdentity(collection.getResourceId(), "0"));
            }
            if (!(sessionToken = (response = this.doQuery(request)).getResponseHeaders().get("x-ms-session-token")).isEmpty() && (parts = StringUtils.split((String)sessionToken, (char)':')).length == 2) {
                PartitionKeyRange singleRange = new PartitionKeyRange();
                singleRange.setId(parts[0]);
                partitionKeyRanges.add(singleRange);
            }
            if (partitionKeyRanges.size() == 0) {
                partitionKeyRanges = this.readPartitionKeyRanges(collectionLink, (FeedOptions)null).getQueryIterable().toList();
            }
        }
        catch (DocumentClientException dce) {
            if (dce.getError() == null) {
                throw dce;
            }
            PartitionedQueryExecutionInfo partitionedQueryExecutionInfo = new PartitionedQueryExecutionInfo(dce.getError().getPartitionedQueryExecutionInfo());
            partitionKeyRanges = RoutingMapProviderHelper.getOverlappingRanges(this.getPartitionKeyRangeCache(), path, partitionedQueryExecutionInfo.getQueryRanges());
        }
        return partitionKeyRanges;
    }

    public ResourceResponse<UserDefinedFunction> createUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) throws DocumentClientException {
        logger.debug("Creating a UserDefinedFunction. collectionLink [{}], udf id [{}]", (Object)collectionLink, (Object)udf.getId());
        DocumentServiceRequest request = this.getUserDefinedFunctionRequest(collectionLink, udf, options, OperationType.Create);
        return new ResourceResponse<UserDefinedFunction>(this.doCreate(request), UserDefinedFunction.class);
    }

    public ResourceResponse<UserDefinedFunction> upsertUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) throws DocumentClientException {
        logger.debug("Upserting a UserDefinedFunction. collectionLink [{}], udf id [{}]", (Object)collectionLink, (Object)udf.getId());
        DocumentServiceRequest request = this.getUserDefinedFunctionRequest(collectionLink, udf, options, OperationType.Upsert);
        return new ResourceResponse<UserDefinedFunction>(this.doUpsert(request), UserDefinedFunction.class);
    }

    private DocumentServiceRequest getUserDefinedFunctionRequest(String collectionLink, UserDefinedFunction udf, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (udf == null) {
            throw new IllegalArgumentException("udf");
        }
        DocumentClient.validateResource(udf);
        String path = Utils.joinPath(collectionLink, "udfs");
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(operationType, ResourceType.UserDefinedFunction, path, udf, requestHeaders);
        return request;
    }

    public ResourceResponse<UserDefinedFunction> replaceUserDefinedFunction(UserDefinedFunction udf, RequestOptions options) throws DocumentClientException {
        if (udf == null) {
            throw new IllegalArgumentException("udf");
        }
        logger.debug("Replacing a UserDefinedFunction. udf id [{}]", (Object)udf.getId());
        DocumentClient.validateResource(udf);
        String path = Utils.joinPath(udf.getSelfLink(), null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Replace, ResourceType.UserDefinedFunction, path, udf, requestHeaders);
        return new ResourceResponse<UserDefinedFunction>(this.doReplace(request), UserDefinedFunction.class);
    }

    public ResourceResponse<UserDefinedFunction> deleteUserDefinedFunction(String udfLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)udfLink)) {
            throw new IllegalArgumentException("udfLink");
        }
        logger.debug("Deleting a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
        String path = Utils.joinPath(udfLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Delete, ResourceType.UserDefinedFunction, path, requestHeaders);
        return new ResourceResponse<UserDefinedFunction>(this.doDelete(request), UserDefinedFunction.class);
    }

    public ResourceResponse<UserDefinedFunction> readUserDefinedFunction(String udfLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)udfLink)) {
            throw new IllegalArgumentException("udfLink");
        }
        logger.debug("Reading a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
        String path = Utils.joinPath(udfLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.UserDefinedFunction, path, requestHeaders);
        return new ResourceResponse<UserDefinedFunction>(this.doRead(request), UserDefinedFunction.class);
    }

    public FeedResponse<UserDefinedFunction> readUserDefinedFunctions(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        logger.debug("Reading UserDefinedFunctions. collectionLink [{}]", (Object)collectionLink);
        String path = Utils.joinPath(collectionLink, "udfs");
        return new FeedResponse<UserDefinedFunction>(new QueryIterable<UserDefinedFunction>(this, ResourceType.UserDefinedFunction, UserDefinedFunction.class, path, options));
    }

    public FeedResponse<UserDefinedFunction> queryUserDefinedFunctions(String collectionLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        return this.queryUserDefinedFunctions(collectionLink, new SqlQuerySpec(query, null), options);
    }

    public FeedResponse<UserDefinedFunction> queryUserDefinedFunctions(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        logger.debug("Querying UserDefinedFunctions. collectionLink [{}], querySpec [{}]", (Object)collectionLink, (Object)querySpec);
        String path = Utils.joinPath(collectionLink, "udfs");
        return new FeedResponse<UserDefinedFunction>(new QueryIterable<UserDefinedFunction>(this, ResourceType.UserDefinedFunction, UserDefinedFunction.class, path, querySpec, options));
    }

    public ResourceResponse<Attachment> createAttachment(String documentLink, Attachment attachment, RequestOptions options) throws DocumentClientException {
        logger.debug("Creating a Attachment. documentLink [{}], attachment id [{}]", (Object)documentLink, (Object)attachment.getId());
        DocumentServiceRequest request = this.getAttachmentRequest(documentLink, attachment, options, OperationType.Create);
        return new ResourceResponse<Attachment>(this.doCreate(request), Attachment.class);
    }

    public ResourceResponse<Attachment> upsertAttachment(String documentLink, Attachment attachment, RequestOptions options) throws DocumentClientException {
        logger.debug("Upserting a Attachment. documentLink [{}], attachment id [{}]", (Object)documentLink, (Object)attachment.getId());
        DocumentServiceRequest request = this.getAttachmentRequest(documentLink, attachment, options, OperationType.Upsert);
        return new ResourceResponse<Attachment>(this.doUpsert(request), Attachment.class);
    }

    private DocumentServiceRequest getAttachmentRequest(String documentLink, Attachment attachment, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        if (attachment == null) {
            throw new IllegalArgumentException("attachment");
        }
        DocumentClient.validateResource(attachment);
        String path = Utils.joinPath(documentLink, "attachments");
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(operationType, ResourceType.Attachment, path, attachment, requestHeaders);
        this.addPartitionKeyInformation(request, null, options);
        return request;
    }

    public ResourceResponse<Attachment> replaceAttachment(Attachment attachment, RequestOptions options) throws DocumentClientException {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment");
        }
        logger.debug("Replacing a Attachment. attachment id [{}]", (Object)attachment.getId());
        DocumentClient.validateResource(attachment);
        String path = Utils.joinPath(attachment.getSelfLink(), null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Replace, ResourceType.Attachment, path, attachment, requestHeaders);
        this.addPartitionKeyInformation(request, null, options);
        return new ResourceResponse<Attachment>(this.doReplace(request), Attachment.class);
    }

    public ResourceResponse<Attachment> deleteAttachment(String attachmentLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)attachmentLink)) {
            throw new IllegalArgumentException("attachmentLink");
        }
        logger.debug("Deleting a Attachment. attachmentLink [{}]", (Object)attachmentLink);
        String path = Utils.joinPath(attachmentLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Delete, ResourceType.Attachment, path, requestHeaders);
        this.addPartitionKeyInformation(request, null, options);
        return new ResourceResponse<Attachment>(this.doDelete(request), Attachment.class);
    }

    public ResourceResponse<Attachment> readAttachment(String attachmentLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)attachmentLink)) {
            throw new IllegalArgumentException("attachmentLink");
        }
        logger.debug("Reading a Attachment. attachmentLink [{}]", (Object)attachmentLink);
        String path = Utils.joinPath(attachmentLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.Attachment, path, requestHeaders);
        this.addPartitionKeyInformation(request, null, options);
        return new ResourceResponse<Attachment>(this.doRead(request), Attachment.class);
    }

    public FeedResponse<Attachment> readAttachments(String documentLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        logger.debug("Reading Attachments. attachmentLink [{}]", (Object)documentLink);
        String path = Utils.joinPath(documentLink, "attachments");
        return new FeedResponse<Attachment>(new QueryIterable<Attachment>(this, ResourceType.Attachment, Attachment.class, path, options));
    }

    public FeedResponse<Attachment> queryAttachments(String documentLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        return this.queryAttachments(documentLink, new SqlQuerySpec(query, null), options);
    }

    public FeedResponse<Attachment> queryAttachments(String documentLink, SqlQuerySpec querySpec, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        logger.debug("Querying Attachments. attachmentLink [{}], querySpec [{}]", (Object)documentLink, (Object)querySpec);
        String path = Utils.joinPath(documentLink, "attachments");
        return new FeedResponse<Attachment>(new QueryIterable<Attachment>(this, ResourceType.Attachment, Attachment.class, path, querySpec, options));
    }

    public ResourceResponse<Attachment> createAttachment(String documentLink, InputStream mediaStream, MediaOptions options) throws DocumentClientException {
        logger.debug("Creating a Attachment. attachmentLink [{}]", (Object)documentLink);
        DocumentServiceRequest request = this.getAttachmentRequest(documentLink, mediaStream, options, OperationType.Create);
        return new ResourceResponse<Attachment>(this.doCreate(request), Attachment.class);
    }

    public ResourceResponse<Attachment> upsertAttachment(String documentLink, InputStream mediaStream, MediaOptions options) throws DocumentClientException {
        logger.debug("Upserting a Attachment. attachmentLink [{}]", (Object)documentLink);
        DocumentServiceRequest request = this.getAttachmentRequest(documentLink, mediaStream, options, OperationType.Upsert);
        return new ResourceResponse<Attachment>(this.doUpsert(request), Attachment.class);
    }

    private DocumentServiceRequest getAttachmentRequest(String documentLink, InputStream mediaStream, MediaOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        if (mediaStream == null) {
            throw new IllegalArgumentException("mediaStream");
        }
        String path = Utils.joinPath(documentLink, "attachments");
        Map<String, String> requestHeaders = this.getMediaHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(operationType, ResourceType.Attachment, path, mediaStream, requestHeaders);
        request.setIsMedia(true);
        this.addPartitionKeyInformation(request, null, null);
        return request;
    }

    public MediaResponse readMedia(String mediaLink) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)mediaLink)) {
            throw new IllegalArgumentException("mediaLink");
        }
        logger.debug("Reading a Media. mediaLink [{}]", (Object)mediaLink);
        String path = Utils.joinPath(mediaLink, null);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.Media, path, null);
        request.setIsMedia(true);
        return new MediaResponse(this.doRead(request), this.connectionPolicy.getMediaReadMode() == MediaReadMode.Buffered);
    }

    public MediaResponse updateMedia(String mediaLink, InputStream mediaStream, MediaOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)mediaLink)) {
            throw new IllegalArgumentException("mediaLink");
        }
        if (mediaStream == null) {
            throw new IllegalArgumentException("mediaStream");
        }
        logger.debug("Updating a Media. mediaLink [{}]", (Object)mediaLink);
        String path = Utils.joinPath(mediaLink, null);
        Map<String, String> requestHeaders = this.getMediaHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Replace, ResourceType.Media, path, mediaStream, requestHeaders);
        request.setIsMedia(true);
        return new MediaResponse(this.doReplace(request), this.connectionPolicy.getMediaReadMode() == MediaReadMode.Buffered);
    }

    public ResourceResponse<Conflict> readConflict(String conflictLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)conflictLink)) {
            throw new IllegalArgumentException("conflictLink");
        }
        logger.debug("Reading a Conflict. conflictLink [{}]", (Object)conflictLink);
        String path = Utils.joinPath(conflictLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.Conflict, path, requestHeaders);
        this.addPartitionKeyInformation(request, null, options);
        return new ResourceResponse<Conflict>(this.doRead(request), Conflict.class);
    }

    public FeedResponse<Conflict> readConflicts(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        logger.debug("Reading Conflicts. collectionLink [{}]", (Object)collectionLink);
        String path = Utils.joinPath(collectionLink, "conflicts");
        return new FeedResponse<Conflict>(new QueryIterable<Conflict>(this, ResourceType.Conflict, Conflict.class, path, options));
    }

    public FeedResponse<Conflict> queryConflicts(String collectionLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        return this.queryConflicts(collectionLink, new SqlQuerySpec(query, null), options);
    }

    public FeedResponse<Conflict> queryConflicts(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        logger.debug("Querying Conflicts. collectionLink [{}], querySpec [{}]", (Object)collectionLink, (Object)querySpec);
        String path = Utils.joinPath(collectionLink, "conflicts");
        return new FeedResponse<Conflict>(new QueryIterable<Conflict>(this, ResourceType.Conflict, Conflict.class, path, querySpec, options));
    }

    public ResourceResponse<Conflict> deleteConflict(String conflictLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)conflictLink)) {
            throw new IllegalArgumentException("conflictLink");
        }
        logger.debug("Deleting a Conflicts. conflictLink [{}]", (Object)conflictLink);
        String path = Utils.joinPath(conflictLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Delete, ResourceType.Conflict, path, requestHeaders);
        this.addPartitionKeyInformation(request, null, options);
        return new ResourceResponse<Conflict>(this.doDelete(request), Conflict.class);
    }

    public ResourceResponse<User> createUser(String databaseLink, User user, RequestOptions options) throws DocumentClientException {
        logger.debug("Creating a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
        DocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Create);
        return new ResourceResponse<User>(this.doCreate(request), User.class);
    }

    public ResourceResponse<User> upsertUser(String databaseLink, User user, RequestOptions options) throws DocumentClientException {
        logger.debug("Upserting a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
        DocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Upsert);
        return new ResourceResponse<User>(this.doUpsert(request), User.class);
    }

    private DocumentServiceRequest getUserRequest(String databaseLink, User user, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (user == null) {
            throw new IllegalArgumentException("user");
        }
        DocumentClient.validateResource(user);
        String path = Utils.joinPath(databaseLink, "users");
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(operationType, ResourceType.User, path, user, requestHeaders);
        return request;
    }

    public ResourceResponse<User> replaceUser(User user, RequestOptions options) throws DocumentClientException {
        if (user == null) {
            throw new IllegalArgumentException("user");
        }
        logger.debug("Replacing a User. user id [{}]", (Object)user.getId());
        DocumentClient.validateResource(user);
        String path = Utils.joinPath(user.getSelfLink(), null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Replace, ResourceType.User, path, user, requestHeaders);
        return new ResourceResponse<User>(this.doReplace(request), User.class);
    }

    public ResourceResponse<User> deleteUser(String userLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        logger.debug("Deleting a User. userLink [{}]", (Object)userLink);
        String path = Utils.joinPath(userLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Delete, ResourceType.User, path, requestHeaders);
        return new ResourceResponse<User>(this.doDelete(request), User.class);
    }

    public ResourceResponse<User> readUser(String userLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        logger.debug("Reading a User. userLink [{}]", (Object)userLink);
        String path = Utils.joinPath(userLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.User, path, requestHeaders);
        return new ResourceResponse<User>(this.doRead(request), User.class);
    }

    public FeedResponse<User> readUsers(String databaseLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        logger.debug("Reading Users. databaseLink [{}]", (Object)databaseLink);
        String path = Utils.joinPath(databaseLink, "users");
        return new FeedResponse<User>(new QueryIterable<User>(this, ResourceType.User, User.class, path, options));
    }

    public FeedResponse<User> queryUsers(String databaseLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        return this.queryUsers(databaseLink, new SqlQuerySpec(query, null), options);
    }

    public FeedResponse<User> queryUsers(String databaseLink, SqlQuerySpec querySpec, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        logger.debug("Querying Users. databaseLink [{}], querySpec [{}]", (Object)databaseLink, (Object)querySpec);
        String path = Utils.joinPath(databaseLink, "users");
        return new FeedResponse<User>(new QueryIterable<User>(this, ResourceType.User, User.class, path, querySpec, options));
    }

    public ResourceResponse<Permission> createPermission(String userLink, Permission permission, RequestOptions options) throws DocumentClientException {
        logger.debug("Creating a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
        DocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Create);
        return new ResourceResponse<Permission>(this.doCreate(request), Permission.class);
    }

    public ResourceResponse<Permission> upsertPermission(String userLink, Permission permission, RequestOptions options) throws DocumentClientException {
        logger.debug("Upserting a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
        DocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Upsert);
        return new ResourceResponse<Permission>(this.doUpsert(request), Permission.class);
    }

    private DocumentServiceRequest getPermissionRequest(String userLink, Permission permission, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        if (permission == null) {
            throw new IllegalArgumentException("permission");
        }
        DocumentClient.validateResource(permission);
        String path = Utils.joinPath(userLink, "permissions");
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(operationType, ResourceType.Permission, path, permission, requestHeaders);
        return request;
    }

    public ResourceResponse<Permission> replacePermission(Permission permission, RequestOptions options) throws DocumentClientException {
        if (permission == null) {
            throw new IllegalArgumentException("permission");
        }
        logger.debug("Replacing a Permission. permission id [{}]", (Object)permission.getId());
        DocumentClient.validateResource(permission);
        String path = Utils.joinPath(permission.getSelfLink(), null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Replace, ResourceType.Permission, path, permission, requestHeaders);
        return new ResourceResponse<Permission>(this.doReplace(request), Permission.class);
    }

    public ResourceResponse<Permission> deletePermission(String permissionLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)permissionLink)) {
            throw new IllegalArgumentException("permissionLink");
        }
        logger.debug("Deleting a Permission. permissionLink [{}]", (Object)permissionLink);
        String path = Utils.joinPath(permissionLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Delete, ResourceType.Permission, path, requestHeaders);
        return new ResourceResponse<Permission>(this.doDelete(request), Permission.class);
    }

    public ResourceResponse<Permission> readPermission(String permissionLink, RequestOptions options) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)permissionLink)) {
            throw new IllegalArgumentException("permissionLink");
        }
        logger.debug("Reading a Permission. permissionLink [{}]", (Object)permissionLink);
        String path = Utils.joinPath(permissionLink, null);
        Map<String, String> requestHeaders = DocumentClient.getRequestHeaders(options);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.Permission, path, requestHeaders);
        return new ResourceResponse<Permission>(this.doRead(request), Permission.class);
    }

    public FeedResponse<Permission> readPermissions(String userLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("permissionLink");
        }
        logger.debug("Reading Permissions. permissionLink [{}]", (Object)userLink);
        String path = Utils.joinPath(userLink, "permissions");
        return new FeedResponse<Permission>(new QueryIterable<Permission>(this, ResourceType.Permission, Permission.class, path, options));
    }

    public FeedResponse<Permission> queryPermissions(String userLink, String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("permissionLink");
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        return this.queryPermissions(userLink, new SqlQuerySpec(query, null), options);
    }

    public FeedResponse<Permission> queryPermissions(String permissionLink, SqlQuerySpec querySpec, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)permissionLink)) {
            throw new IllegalArgumentException("permissionLink");
        }
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        logger.debug("Querying Permissions. permissionLink [{}], querySpec [{}]", (Object)permissionLink, (Object)querySpec);
        String path = Utils.joinPath(permissionLink, "permissions");
        return new FeedResponse<Permission>(new QueryIterable<Permission>(this, ResourceType.Permission, Permission.class, path, querySpec, options));
    }

    public ResourceResponse<Offer> replaceOffer(Offer offer) throws DocumentClientException {
        if (offer == null) {
            throw new IllegalArgumentException("offer");
        }
        logger.debug("Replacing an Offer. offer id [{}]", (Object)offer.getId());
        DocumentClient.validateResource(offer);
        String path = Utils.joinPath(offer.getSelfLink(), null);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Replace, ResourceType.Offer, path, offer, null);
        return new ResourceResponse<Offer>(this.doReplace(request), Offer.class);
    }

    public ResourceResponse<Offer> readOffer(String offerLink) throws DocumentClientException {
        if (StringUtils.isEmpty((CharSequence)offerLink)) {
            throw new IllegalArgumentException("offerLink");
        }
        logger.debug("Reading an Offer. offerLink [{}]", (Object)offerLink);
        String path = Utils.joinPath(offerLink, null);
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.Offer, path, null);
        return new ResourceResponse<Offer>(this.doRead(request), Offer.class);
    }

    public FeedResponse<Offer> readOffers(FeedOptions options) {
        logger.debug("Reading Offers.");
        String path = Utils.joinPath("offers", null);
        return new FeedResponse<Offer>(new QueryIterable<Offer>(this, ResourceType.Offer, Offer.class, path, options));
    }

    public FeedResponse<Offer> queryOffers(String query, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query");
        }
        return this.queryOffers(new SqlQuerySpec(query, null), options);
    }

    public FeedResponse<Offer> queryOffers(SqlQuerySpec querySpec, FeedOptions options) {
        if (querySpec == null) {
            throw new IllegalArgumentException("querySpec");
        }
        logger.debug("Querying Offers. querySpec [{}]", (Object)querySpec);
        String path = Utils.joinPath("offers", null);
        return new FeedResponse<Offer>(new QueryIterable<Offer>(this, ResourceType.Offer, Offer.class, path, querySpec, options));
    }

    public DatabaseAccount getDatabaseAccount() throws DocumentClientException {
        logger.debug("Getting Database Account");
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.DatabaseAccount, "", null);
        DocumentServiceResponse response = this.doRead(request);
        DatabaseAccount account = response.getResource(DatabaseAccount.class);
        Map<String, String> responseHeader = response.getResponseHeaders();
        account.setMaxMediaStorageUsageInMB(Long.valueOf(responseHeader.get("x-ms-max-media-storage-usage-mb")));
        account.setMediaStorageUsageInMB(Long.valueOf(responseHeader.get("x-ms-media-storage-usage-mb")));
        return account;
    }

    private DocumentServiceResponse doCreate(DocumentServiceRequest request) throws DocumentClientException {
        this.putMoreContentIntoDocumentServiceRequest(request, "POST");
        RetryRequestDelegate createDelegate = new RetryRequestDelegate(){

            @Override
            public DocumentServiceResponse apply(DocumentServiceRequest requestInner) throws DocumentClientException {
                StoreModel proxy = DocumentClient.this.getStoreProxy(requestInner);
                return proxy.processMessage(requestInner);
            }
        };
        this.applySessionToken(request);
        DocumentServiceResponse response = RetryUtility.executeDocumentClientRequest(createDelegate, this, this.globalEndpointManager, request);
        this.captureSessionToken(request, response);
        return response;
    }

    private DocumentServiceResponse doUpsert(DocumentServiceRequest request) throws DocumentClientException {
        this.putMoreContentIntoDocumentServiceRequest(request, "POST");
        RetryRequestDelegate upsertDelegate = new RetryRequestDelegate(){

            @Override
            public DocumentServiceResponse apply(DocumentServiceRequest requestInner) throws DocumentClientException {
                return DocumentClient.this.getStoreProxy(requestInner).processMessage(requestInner);
            }
        };
        this.applySessionToken(request);
        Map<String, String> headers = request.getHeaders();
        assert (headers != null);
        if (headers != null) {
            headers.put("x-ms-documentdb-is-upsert", "true");
        }
        DocumentServiceResponse response = RetryUtility.executeDocumentClientRequest(upsertDelegate, this, this.globalEndpointManager, request);
        this.captureSessionToken(request, response);
        return response;
    }

    private DocumentServiceResponse doReplace(DocumentServiceRequest request) throws DocumentClientException {
        this.putMoreContentIntoDocumentServiceRequest(request, "PUT");
        RetryRequestDelegate replaceDelegate = new RetryRequestDelegate(){

            @Override
            public DocumentServiceResponse apply(DocumentServiceRequest requestInner) throws DocumentClientException {
                return DocumentClient.this.getStoreProxy(requestInner).processMessage(requestInner);
            }
        };
        this.applySessionToken(request);
        DocumentServiceResponse response = RetryUtility.executeDocumentClientRequest(replaceDelegate, this, this.globalEndpointManager, request);
        this.captureSessionToken(request, response);
        return response;
    }

    private DocumentServiceResponse doDelete(DocumentServiceRequest request) throws DocumentClientException {
        RetryRequestDelegate deleteDelegate = new RetryRequestDelegate(){

            @Override
            public DocumentServiceResponse apply(DocumentServiceRequest requestInner) throws DocumentClientException {
                return DocumentClient.this.getStoreProxy(requestInner).processMessage(requestInner);
            }
        };
        this.putMoreContentIntoDocumentServiceRequest(request, "DELETE");
        this.applySessionToken(request);
        DocumentServiceResponse response = RetryUtility.executeDocumentClientRequest(deleteDelegate, this, this.globalEndpointManager, request);
        this.captureSessionToken(request, response);
        return response;
    }

    private DocumentServiceResponse doRead(DocumentServiceRequest request) throws DocumentClientException {
        this.putMoreContentIntoDocumentServiceRequest(request, "GET");
        RetryRequestDelegate readDelegate = new RetryRequestDelegate(){

            @Override
            public DocumentServiceResponse apply(DocumentServiceRequest requestInner) throws DocumentClientException {
                return DocumentClient.this.getStoreProxy(requestInner).processMessage(requestInner);
            }
        };
        this.applySessionToken(request);
        DocumentServiceResponse response = RetryUtility.executeDocumentClientRequest(readDelegate, this, this.globalEndpointManager, request);
        this.captureSessionToken(request, response);
        return response;
    }

    DocumentServiceResponse doReadFeed(DocumentServiceRequest request) throws DocumentClientException {
        RetryRequestDelegate readDelegate = new RetryRequestDelegate(){

            @Override
            public DocumentServiceResponse apply(DocumentServiceRequest requestInner) throws DocumentClientException {
                return DocumentClient.this.getStoreProxy(requestInner).processMessage(requestInner);
            }
        };
        this.putMoreContentIntoDocumentServiceRequest(request, "GET");
        if (!request.isChangeFeedRequest()) {
            this.applySessionToken(request);
        }
        DocumentServiceResponse response = RetryUtility.executeDocumentClientRequest(readDelegate, this, this.globalEndpointManager, request);
        this.captureSessionToken(request, response);
        return response;
    }

    DocumentServiceResponse doQuery(DocumentServiceRequest request) throws DocumentClientException {
        RetryRequestDelegate readDelegate = new RetryRequestDelegate(){

            @Override
            public DocumentServiceResponse apply(DocumentServiceRequest requestInner) throws DocumentClientException {
                return DocumentClient.this.getStoreProxy(requestInner).processMessage(requestInner);
            }
        };
        this.putMoreContentIntoDocumentServiceRequest(request, "POST");
        this.applySessionToken(request);
        DocumentServiceResponse response = RetryUtility.executeDocumentClientRequest(readDelegate, this, this.globalEndpointManager, request);
        this.captureSessionToken(request, response);
        return response;
    }

    DatabaseAccount getDatabaseAccountFromEndpoint(URI endpoint) throws DocumentClientException {
        DocumentServiceRequest request = DocumentServiceRequest.create(OperationType.Read, ResourceType.DatabaseAccount, "", null);
        this.putMoreContentIntoDocumentServiceRequest(request, "GET");
        DocumentServiceResponse response = null;
        try {
            request.setEndpointOverride(endpoint);
            response = this.gatewayProxy.doRead(request);
        }
        catch (IllegalStateException e) {
            String message = "Failed to retrieve database account information. %s";
            Throwable cause = e.getCause();
            message = cause != null ? String.format(message, cause.toString()) : String.format(message, e.toString());
            logger.warn(message);
        }
        if (response != null) {
            return response.getResource(DatabaseAccount.class);
        }
        return null;
    }

    void applySessionToken(DocumentServiceRequest request) throws DocumentClientException {
        String sessionToken;
        String consistency = StringUtils.defaultString((String)request.getHeaders().get("x-ms-consistency-level"), this.desiredConsistencyLevel != null ? this.desiredConsistencyLevel.name() : null);
        boolean isSessionConsistency = ConsistencyLevel.Session.name().equals(consistency);
        if (!isSessionConsistency || request.getResourceType().isMasterResource()) {
            request.getHeaders().remove("x-ms-session-token");
            return;
        }
        Map<String, String> headers = request.getHeaders();
        if (headers != null && !StringUtils.isEmpty((CharSequence)headers.get("x-ms-session-token")) && request.getResourceType().isMasterResource()) {
            headers.remove("x-ms-session-token");
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)request.getResourceAddress()) && request.isReadOnlyRequest() && !StringUtils.isEmpty((CharSequence)(sessionToken = this.sessionContainer.resolveSessionToken(request)))) {
            headers.put("x-ms-session-token", sessionToken);
        }
    }

    void captureSessionToken(DocumentServiceRequest request, DocumentServiceResponse response) {
        SessionTokenHelper.captureSessionToken(this.sessionContainer, request, response.getResponseHeaders());
    }

    static Map<String, String> getRequestHeaders(RequestOptions options) {
        if (options == null) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        Map<String, String> customOptions = options.getCustomRequestOptions();
        if (customOptions != null) {
            headers.putAll(customOptions);
        }
        if (options.getAccessCondition() != null) {
            if (options.getAccessCondition().getType() == AccessConditionType.IfMatch) {
                headers.put("If-Match", options.getAccessCondition().getCondition());
            } else {
                headers.put("If-None-Match", options.getAccessCondition().getCondition());
            }
        }
        if (options.getConsistencyLevel() != null) {
            headers.put("x-ms-consistency-level", options.getConsistencyLevel().name());
        }
        if (options.getIndexingDirective() != null) {
            headers.put("x-ms-indexing-directive", options.getIndexingDirective().name());
        }
        if (options.getPostTriggerInclude() != null && options.getPostTriggerInclude().size() > 0) {
            String postTriggerInclude = StringUtils.join(options.getPostTriggerInclude(), (String)",");
            headers.put("x-ms-documentdb-post-trigger-include", postTriggerInclude);
        }
        if (options.getPreTriggerInclude() != null && options.getPreTriggerInclude().size() > 0) {
            String preTriggerInclude = StringUtils.join(options.getPreTriggerInclude(), (String)",");
            headers.put("x-ms-documentdb-pre-trigger-include", preTriggerInclude);
        }
        if (options.getSessionToken() != null && !options.getSessionToken().isEmpty()) {
            headers.put("x-ms-session-token", options.getSessionToken());
        }
        if (options.getResourceTokenExpirySeconds() != null) {
            headers.put("x-ms-documentdb-expiry-seconds", String.valueOf(options.getResourceTokenExpirySeconds()));
        }
        if (options.getOfferThroughput() != null && options.getOfferThroughput() >= 0) {
            headers.put("x-ms-offer-throughput", options.getOfferThroughput().toString());
        } else if (options.getOfferType() != null) {
            headers.put("x-ms-offer-type", options.getOfferType());
        }
        if (options.getPartitionKey() != null) {
            headers.put("x-ms-documentdb-partitionkey", options.getPartitionKey().toString());
        }
        if (options.isPopulateQuotaInfo()) {
            headers.put("x-ms-documentdb-populatequotainfo", String.valueOf(true));
        }
        if (options.getOfferEnableRUPerMinuteThroughput()) {
            headers.put("x-ms-offer-is-ru-per-minute-throughput-enabled", String.valueOf(true));
        }
        if (options.getDisableRUPerMinuteUsage()) {
            headers.put("x-ms-documentdb-disable-ru-per-minute-usage", String.valueOf(true));
        }
        if (options.isPopulatePartitionKeyRangeStatistics()) {
            headers.put("x-ms-documentdb-populatepartitionstatistics", String.valueOf(true));
        }
        return headers;
    }

    private Map<String, String> getMediaHeaders(MediaOptions options) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (options == null || options.getContentType().isEmpty()) {
            requestHeaders.put("Content-Type", "application/octet-stream");
        }
        if (options != null) {
            if (!options.getContentType().isEmpty()) {
                requestHeaders.put("Content-Type", options.getContentType());
            }
            if (!options.getSlug().isEmpty()) {
                requestHeaders.put("Slug", options.getSlug());
            }
        }
        return requestHeaders;
    }

    private void addPartitionKeyInformation(AbstractDocumentServiceRequest request, Document document, RequestOptions options) {
        PartitionKeyInternal partitionKeyInternal;
        if (options != null && options.getPartitionKey() != null) {
            partitionKeyInternal = options.getPartitionKey().getInternalPartitionKey();
        } else {
            DocumentCollection collection = this.collectionCache.resolveCollection(request);
            PartitionKeyDefinition partitionKeyDefinition = collection.getPartitionKey();
            if (partitionKeyDefinition == null || partitionKeyDefinition.getPaths().size() == 0) {
                partitionKeyInternal = PartitionKeyInternal.getEmpty();
            } else if (document != null) {
                partitionKeyInternal = DocumentClient.extractPartitionKeyValueFromDocument(document, partitionKeyDefinition);
            } else {
                throw new UnsupportedOperationException("PartitionKey value must be supplied for this operation.");
            }
        }
        request.getHeaders().put("x-ms-documentdb-partitionkey", DocumentClient.escapeNonAscii(partitionKeyInternal.toJson()));
    }

    private static String escapeNonAscii(String partitionKeyJson) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < partitionKeyJson.length(); ++i) {
            char val = partitionKeyJson.charAt(i);
            if (val > '\u007f') {
                sb.append("\\u" + String.format("%04X", val));
                continue;
            }
            sb.append(partitionKeyJson.charAt(i));
        }
        return sb.toString();
    }

    private static PartitionKeyInternal extractPartitionKeyValueFromDocument(Document document, PartitionKeyDefinition partitionKeyDefinition) {
        String path;
        Collection<String> parts;
        if (partitionKeyDefinition != null && (parts = PathParser.getPathParts(path = partitionKeyDefinition.getPaths().iterator().next())).size() >= 1) {
            Object value = document.getObjectByPath(parts);
            if (value == null || value.getClass() == JSONObject.class) {
                value = Undefined.Value();
            }
            return PartitionKeyInternal.fromObjectArray(Arrays.asList(value), false);
        }
        return null;
    }

    private StoreModel getStoreProxy(DocumentServiceRequest request) {
        DocumentCollection collection;
        ResourceType resourceType = request.getResourceType();
        OperationType operationType = request.getOperationType();
        if (resourceType == ResourceType.PartitionKeyRange || resourceType == ResourceType.DatabaseAccount || request.getIsMedia()) {
            return this.gatewayProxy;
        }
        if (Utils.isCollectionChild(request.getResourceType()) && (collection = this.collectionCache.resolveCollection(request)) != null && Utils.isCollectionPartitioned(collection).booleanValue() && operationType == OperationType.Query && !ServiceJNIWrapper.isServiceJNIAvailable() && request.getPartitionKeyRangeIdentity() == null) {
            return this.gatewayProxy;
        }
        if (resourceType == ResourceType.Offer || resourceType.isScript() && operationType != OperationType.ExecuteJavaScript) {
            return this.gatewayProxy;
        }
        if (operationType == OperationType.Create || operationType == OperationType.Upsert) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection || resourceType == ResourceType.Permission) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Delete) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Replace) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Read) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        return this.storeModel;
    }

    private void putMoreContentIntoDocumentServiceRequest(DocumentServiceRequest request, String httpMethod) {
        if (this.masterKey != null) {
            String xDate = Utils.getCurrentTimeGMT();
            request.getHeaders().put("x-ms-date", xDate);
        }
        if (this.masterKey != null || this.resourceTokens != null) {
            String resourceName = request.getResourceFullName();
            String authorization = this.getAuthorizationToken(resourceName, request.getPath(), request.getResourceType(), httpMethod, request.getHeaders(), this.masterKey, this.resourceTokens);
            try {
                authorization = URLEncoder.encode(authorization, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Failed to encode authtoken.", e);
            }
            request.getHeaders().put("authorization", authorization);
        }
        if (("POST".equals(httpMethod) || "PUT".equals(httpMethod)) && !request.getHeaders().containsKey("Content-Type")) {
            request.getHeaders().put("Content-Type", "application/json");
        }
        if (!request.getHeaders().containsKey("Accept")) {
            request.getHeaders().put("Accept", "application/json");
        }
    }

    private String getAuthorizationToken(String resourceOrOwnerId, String path, ResourceType resourceType, String requestVerb, Map<String, String> headers, String masterKey, Map<String, String> resourceTokens) {
        if (masterKey != null) {
            return this.authorizationTokenProvider.generateKeyAuthorizationSignature(requestVerb, resourceOrOwnerId, resourceType, headers);
        }
        if (resourceTokens != null) {
            return this.authorizationTokenProvider.getAuthorizationTokenUsingResourceTokens(resourceTokens, path, resourceOrOwnerId);
        }
        return null;
    }

    StoreModel getStoreModel() {
        return this.storeModel;
    }

    AddressCache getReadAddressCache() {
        return this.readAddressCache;
    }

    AddressCache getWriteAddressCache() {
        return this.writeAddressCache;
    }

    AddressCache getAlternateWriteAddressCache() {
        return this.alternateWriteAddressCache;
    }

    TransportClient getTransportClient() {
        return this.transportClient;
    }

    DatabaseAccountConfigurationProvider getDatabaseAccountConfigurationProvider() {
        return this.databaseAccountConfigurationProvider;
    }

    @Override
    public void close() {
        logger.info("Closing DocumentClient");
        this.poolingHttpClientConnectionManager.shutdown();
        this.globalEndpointManager.close();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    PartitionKeyRangeCache createPartitionKeyRangeCache() {
        return new PartitionKeyRangeCache(new DocumentQueryClientInternal(this));
    }

    static class DocumentDBThreadPoolExecutor
    extends ThreadPoolExecutor {
        private static final Logger LOGGER = LoggerFactory.getLogger(DocumentDBThreadPoolExecutor.class);

        DocumentDBThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        @Override
        public void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t == null && r instanceof Future) {
                try {
                    ((Future)((Object)r)).get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException e) {
                    t = e.getCause();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (t != null) {
                LOGGER.error("Runnable execution exception", t);
            }
        }
    }
}

