/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.Error;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DocumentClientException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Error error;
    private String resourceAddress;
    private int statusCode;
    private Map<String, String> responseHeaders;

    public DocumentClientException(int statusCode) {
        this.statusCode = statusCode;
    }

    public DocumentClientException(int statusCode, String errorMessage) {
        Error error = new Error();
        error.set("message", errorMessage);
        this.statusCode = statusCode;
        this.error = error;
    }

    public DocumentClientException(int statusCode, Exception innerException) {
        super(innerException);
        this.statusCode = statusCode;
    }

    @Deprecated
    public DocumentClientException(int statusCode, Exception innerException, Map<String, String> responseHeaders) {
        super(innerException);
        this.statusCode = statusCode;
        this.responseHeaders = responseHeaders;
    }

    public DocumentClientException(int statusCode, Error errorResource, Map<String, String> responseHeaders) {
        this(null, statusCode, errorResource, responseHeaders);
    }

    public DocumentClientException(String resourceAddress, int statusCode, Error errorResource, Map<String, String> responseHeaders) {
        super(errorResource.getMessage());
        this.resourceAddress = resourceAddress;
        this.statusCode = statusCode;
        this.error = errorResource;
        this.responseHeaders = responseHeaders;
    }

    public String getActivityId() {
        if (this.responseHeaders != null) {
            return this.responseHeaders.get("x-ms-activity-id");
        }
        return null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Integer getSubStatusCode() {
        String subStatusString;
        Integer code = null;
        if (this.responseHeaders != null && StringUtils.isNotEmpty((CharSequence)(subStatusString = this.responseHeaders.get("x-ms-substatus")))) {
            try {
                code = Integer.valueOf(subStatusString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return code;
    }

    public Error getError() {
        return this.error;
    }

    public long getRetryAfterInMilliseconds() {
        String header;
        long retryIntervalInMilliseconds = 0L;
        if (this.responseHeaders != null && StringUtils.isNotEmpty((CharSequence)(header = this.responseHeaders.get("x-ms-retry-after-ms")))) {
            try {
                retryIntervalInMilliseconds = Long.parseLong(header);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retryIntervalInMilliseconds;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    String getResourceAddress() {
        return this.resourceAddress;
    }
}

