/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.IndexingPolicy;
import com.microsoft.azure.documentdb.PartitionKeyDefinition;
import com.microsoft.azure.documentdb.PartitionKeyRangeStatistics;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.UniqueKeyPolicy;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public final class DocumentCollection
extends Resource {
    private IndexingPolicy indexingPolicy;
    private UniqueKeyPolicy uniqueKeyPolicy;

    public DocumentCollection() {
    }

    public DocumentCollection(String jsonString) {
        super(jsonString);
    }

    public DocumentCollection(JSONObject jsonObject) {
        super(jsonObject);
    }

    public IndexingPolicy getIndexingPolicy() {
        if (this.indexingPolicy == null) {
            this.indexingPolicy = super.has("indexingPolicy") ? super.getObject("indexingPolicy", IndexingPolicy.class) : new IndexingPolicy();
        }
        return this.indexingPolicy;
    }

    public void setIndexingPolicy(IndexingPolicy indexingPolicy) {
        if (indexingPolicy == null) {
            throw new IllegalArgumentException("IndexingPolicy cannot be null.");
        }
        this.indexingPolicy = indexingPolicy;
    }

    public PartitionKeyDefinition getPartitionKey() {
        if (super.has("partitionKey")) {
            return super.getObject("partitionKey", PartitionKeyDefinition.class);
        }
        this.setPartitionKey(new PartitionKeyDefinition());
        return this.getPartitionKey();
    }

    public void setPartitionKey(PartitionKeyDefinition partitionKey) {
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKey cannot be null.");
        }
        super.set("partitionKey", partitionKey);
    }

    public Collection<PartitionKeyRangeStatistics> getCollectionPartitionStatistics() {
        if (super.has("statistics")) {
            return super.getCollection("statistics", PartitionKeyRangeStatistics.class);
        }
        return null;
    }

    public Integer getDefaultTimeToLive() {
        if (super.has("defaultTtl")) {
            return super.getInt("defaultTtl");
        }
        return null;
    }

    public void setDefaultTimeToLive(Integer timeToLive) {
        if (timeToLive != null) {
            super.set("defaultTtl", timeToLive);
        } else if (super.has("defaultTtl")) {
            super.remove("defaultTtl");
        }
    }

    public UniqueKeyPolicy getUniqueKeyPolicy() {
        if (this.uniqueKeyPolicy == null) {
            this.uniqueKeyPolicy = super.getObject("uniqueKeyPolicy", UniqueKeyPolicy.class);
            if (this.uniqueKeyPolicy == null) {
                this.uniqueKeyPolicy = new UniqueKeyPolicy();
            }
        }
        return this.uniqueKeyPolicy;
    }

    public void setUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        if (uniqueKeyPolicy == null) {
            throw new IllegalArgumentException("uniqueKeyPolicy cannot be null.");
        }
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        super.set("uniqueKeyPolicy", uniqueKeyPolicy);
    }

    public String getDocumentsLink() {
        return String.format("%s/%s", StringUtils.stripEnd((String)super.getSelfLink(), (String)"/"), super.getString("_docs"));
    }

    public String getStoredProceduresLink() {
        return String.format("%s/%s", StringUtils.stripEnd((String)super.getSelfLink(), (String)"/"), super.getString("_sprocs"));
    }

    public String getTriggersLink() {
        return StringUtils.removeEnd((String)this.getSelfLink(), (String)"/") + "/" + super.getString("_triggers");
    }

    public String getUserDefinedFunctionsLink() {
        return StringUtils.removeEnd((String)this.getSelfLink(), (String)"/") + "/" + super.getString("_udfs");
    }

    public String getConflictsLink() {
        return StringUtils.removeEnd((String)this.getSelfLink(), (String)"/") + "/" + super.getString("_conflicts");
    }

    @Override
    void populatePropertyBag() {
        if (this.indexingPolicy == null) {
            this.getIndexingPolicy();
        }
        this.indexingPolicy.populatePropertyBag();
        super.set("indexingPolicy", this.indexingPolicy);
        if (this.uniqueKeyPolicy == null) {
            this.getUniqueKeyPolicy();
        }
        this.uniqueKeyPolicy.populatePropertyBag();
        super.set("uniqueKeyPolicy", this.uniqueKeyPolicy);
        if (this.getCollectionPartitionStatistics() != null) {
            for (PartitionKeyRangeStatistics pkRangeStats : this.getCollectionPartitionStatistics()) {
                pkRangeStats.populatePropertyBag();
            }
            super.set("statistics", this.getCollectionPartitionStatistics());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !DocumentCollection.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        DocumentCollection typedObj = (DocumentCollection)obj;
        return typedObj.getResourceId().equals(this.getResourceId());
    }

    public int hashCode() {
        return this.getResourceId().hashCode();
    }
}

