/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.DatabaseAccount;
import com.microsoft.azure.documentdb.DatabaseAccountLocation;
import com.microsoft.azure.documentdb.DatabaseAccountManagerInternal;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GlobalEndpointManager
implements EndpointManager {
    private final Logger logger = LoggerFactory.getLogger(GlobalEndpointManager.class);
    private final DatabaseAccountManagerInternal client;
    private final Collection<String> preferredLocations;
    private final boolean enableEndpointDiscovery;
    private final URI defaultEndpoint;
    private Map<String, URI> availableReadableLocations;
    private Map<String, URI> availableWritableLocations;
    private ConcurrentMap<String, Long> unavailableRegions;
    private URI currentWriteLocation;
    private URI currentReadLocation;
    private URI alternateWriteLocation;
    private boolean initialized;
    private DocumentClient documentClient;
    private Future endpointRefreshTaskFuture;
    private static final long DEFAULT_UNAVAILABLE_LOCATION_EXPIRATION_TIME = 300000L;
    private static final long DEFAULT_BACKGROUND_REFRESH_LOCATION_TIME_INTERVAL_IN_MS = 300000L;

    public GlobalEndpointManager(final DocumentClient client) {
        this(new DatabaseAccountManagerInternal(){

            @Override
            public URI getServiceEndpoint() {
                return client.getServiceEndpoint();
            }

            @Override
            public DatabaseAccount getDatabaseAccountFromEndpoint(URI endpoint) throws DocumentClientException {
                return client.getDatabaseAccountFromEndpoint(endpoint);
            }

            @Override
            public ConnectionPolicy getConnectionPolicy() {
                return client.getConnectionPolicy();
            }
        });
        String candidateRegion;
        this.documentClient = client;
        boolean preferredLocationValid = false;
        String mostPreferredRegion = null;
        if (this.preferredLocations != null && this.preferredLocations.size() > 0 && StringUtils.isNotEmpty((CharSequence)(candidateRegion = this.preferredLocations.iterator().next()))) {
            preferredLocationValid = true;
            mostPreferredRegion = candidateRegion;
        }
        final boolean preferredLocationValidFinal = preferredLocationValid;
        final String mostPreferredRegionFinal = mostPreferredRegion;
        final GlobalEndpointManager that = this;
        if (this.enableEndpointDiscovery) {
            this.endpointRefreshTaskFuture = client.getExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            Thread.sleep(300000L);
                            boolean shouldRefreshEndpoints = preferredLocationValidFinal && that.availableReadableLocations != null && that.availableReadableLocations.get(mostPreferredRegionFinal) == null;
                            if (!(shouldRefreshEndpoints |= that.getAlternateWriteEndpoint() != null)) continue;
                            GlobalEndpointManager.this.logger.debug("Refreshing endpoints list");
                            that.refreshEndpointList();
                        }
                    }
                    catch (InterruptedException e) {
                        GlobalEndpointManager.this.logger.warn("Preferred location background task was interrupted");
                        return;
                    }
                }
            });
        }
    }

    @Override
    public void close() {
        if (this.endpointRefreshTaskFuture != null) {
            this.endpointRefreshTaskFuture.cancel(true);
        }
    }

    @Override
    public void markReadEndpointUnavailable() {
        if (this.getReadEndpoint() != this.getWriteEndpoint()) {
            Long currentMs = System.currentTimeMillis();
            this.unavailableRegions.putIfAbsent(this.getReadEndpoint().toString(), currentMs);
            this.logger.debug("Added read endpoint {} to unavailable regions with timestamp {}, write endpoint {}", new Object[]{this.getReadEndpoint(), currentMs, this.getWriteEndpoint()});
        }
    }

    public GlobalEndpointManager(DatabaseAccountManagerInternal client) {
        this.client = client;
        this.preferredLocations = client.getConnectionPolicy().getPreferredLocations() != null ? Collections.unmodifiableCollection(client.getConnectionPolicy().getPreferredLocations()) : null;
        this.enableEndpointDiscovery = client.getConnectionPolicy().getEnableEndpointDiscovery();
        this.currentReadLocation = this.defaultEndpoint = client.getServiceEndpoint();
        this.currentWriteLocation = this.defaultEndpoint;
        this.initialized = false;
        this.unavailableRegions = new ConcurrentHashMap<String, Long>();
    }

    @Override
    public URI getWriteEndpoint() {
        return this.currentWriteLocation;
    }

    @Override
    public URI getReadEndpoint() {
        return this.currentReadLocation;
    }

    @Override
    public URI getAlternateWriteEndpoint() {
        return this.alternateWriteLocation;
    }

    @Override
    public URI resolveServiceEndpoint(DocumentServiceRequest request) {
        URI endpoint = request.useWriteEndpoint() || Utils.isWriteOperation(request.getOperationType()) ? (!request.useAlternateWriteEndpoint() || this.getAlternateWriteEndpoint() == null ? this.currentWriteLocation : this.alternateWriteLocation) : this.currentReadLocation;
        if (endpoint == null) {
            endpoint = this.defaultEndpoint;
        }
        return endpoint;
    }

    @Override
    public DatabaseAccount getDatabaseAccountFromAnyEndpoint() {
        DatabaseAccount databaseAccount = null;
        try {
            databaseAccount = this.client.getDatabaseAccountFromEndpoint(this.defaultEndpoint);
        }
        catch (DocumentClientException e) {
            this.logger.warn("Failed to retrieve database account information. {}", (Object)e.toString());
        }
        if (databaseAccount == null && this.preferredLocations != null && this.preferredLocations.size() > 0) {
            for (String regionName : this.preferredLocations) {
                URI regionalUri = this.getRegionalEndpoint(regionName);
                if (regionalUri == null) continue;
                try {
                    databaseAccount = this.client.getDatabaseAccountFromEndpoint(regionalUri);
                    break;
                }
                catch (DocumentClientException e) {
                    this.logger.warn("Failed to retrieve database account information. {}", (Object)e.toString());
                }
            }
        }
        return databaseAccount;
    }

    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.refreshEndpointList();
    }

    private boolean checkAndUpdateIfEndpointIsUnavailable(String endpoint) {
        Long addedTimestamp = (Long)this.unavailableRegions.get(endpoint);
        if (addedTimestamp == null) {
            return false;
        }
        if (System.currentTimeMillis() - addedTimestamp > 300000L) {
            if (this.unavailableRegions.remove(endpoint) != null) {
                this.logger.debug("Remove endpoint {} from unavailable endpoint", (Object)endpoint);
            }
            return false;
        }
        this.logger.debug("Endpoint {} is present in unvailable regions list", (Object)endpoint);
        return true;
    }

    @Override
    public synchronized void refreshEndpointList() {
        DatabaseAccount databaseAccount;
        HashMap<String, URI> writableLocations = new HashMap<String, URI>();
        HashMap<String, URI> readableLocations = new HashMap<String, URI>();
        if (this.enableEndpointDiscovery && (databaseAccount = this.getDatabaseAccountFromAnyEndpoint()) != null) {
            URI regionUri;
            if (databaseAccount.getWritableLocations() != null) {
                for (DatabaseAccountLocation location : databaseAccount.getWritableLocations()) {
                    if (StringUtils.isEmpty((CharSequence)location.getName())) continue;
                    try {
                        regionUri = new URI(location.getEndpoint());
                        writableLocations.put(location.getName(), regionUri);
                    }
                    catch (URISyntaxException e) {
                        this.logger.debug("Unable to parse write endpoint URI {}", (Object)location.getEndpoint());
                    }
                }
            }
            if (databaseAccount.getReadableLocations() != null) {
                for (DatabaseAccountLocation location : databaseAccount.getReadableLocations()) {
                    if (StringUtils.isEmpty((CharSequence)location.getName())) continue;
                    if (!this.checkAndUpdateIfEndpointIsUnavailable(location.getEndpoint())) {
                        try {
                            regionUri = new URI(location.getEndpoint());
                            readableLocations.put(location.getName(), regionUri);
                        }
                        catch (URISyntaxException e) {
                            this.logger.debug("Unable to parse read endpoint URI {}", (Object)location.getEndpoint());
                        }
                        continue;
                    }
                    this.logger.debug("Skipping readable location [{} - {}]", (Object)location.getName(), (Object)location.getEndpoint());
                }
            }
        }
        this.updateEndpointsCache(writableLocations, readableLocations, this.preferredLocations);
        if (this.documentClient != null && this.documentClient.getReadAddressCache() != null && this.documentClient.getWriteAddressCache() != null) {
            this.documentClient.getReadAddressCache().retargetEndpoint(this.getReadEndpoint().toString());
            this.documentClient.getWriteAddressCache().retargetEndpoint(this.getWriteEndpoint().toString());
            if (this.getAlternateWriteEndpoint() != null) {
                this.documentClient.getAlternateWriteAddressCache().retargetEndpoint(this.getAlternateWriteEndpoint().toString());
            }
        }
    }

    private synchronized void updateEndpointsCache(Map<String, URI> writableLocations, Map<String, URI> readableLocations, Collection<String> preferredLocations) {
        this.availableWritableLocations = writableLocations;
        this.availableReadableLocations = readableLocations;
        URI nextWriteEndpoint = null;
        URI nextReadEndpoint = null;
        URI alternateWriteEndpoint = null;
        if (!this.enableEndpointDiscovery || this.availableReadableLocations.isEmpty()) {
            nextReadEndpoint = this.defaultEndpoint;
        }
        if (!this.enableEndpointDiscovery || this.availableWritableLocations.isEmpty()) {
            nextWriteEndpoint = this.defaultEndpoint;
        }
        for (Map.Entry<String, URI> writeEndpointEntry : this.availableWritableLocations.entrySet()) {
            if (nextWriteEndpoint == null) {
                nextWriteEndpoint = writeEndpointEntry.getValue();
                continue;
            }
            alternateWriteEndpoint = writeEndpointEntry.getValue();
            break;
        }
        if (nextReadEndpoint == null) {
            if (preferredLocations == null || preferredLocations.isEmpty()) {
                nextReadEndpoint = nextWriteEndpoint;
            } else {
                String regionName;
                Iterator<Object> iterator = preferredLocations.iterator();
                while (iterator.hasNext() && (!StringUtils.isNotEmpty((CharSequence)(regionName = (String)iterator.next())) || (nextReadEndpoint = this.availableReadableLocations.get(regionName)) == null)) {
                }
                if (nextReadEndpoint == null) {
                    iterator = preferredLocations.iterator();
                    while (iterator.hasNext() && (nextReadEndpoint = this.availableWritableLocations.get(regionName = (String)iterator.next())) == null) {
                    }
                }
            }
            if (nextReadEndpoint == null) {
                nextReadEndpoint = nextWriteEndpoint;
            }
        }
        this.currentReadLocation = nextReadEndpoint;
        this.currentWriteLocation = nextWriteEndpoint;
        this.alternateWriteLocation = alternateWriteEndpoint;
        this.logger.debug("Endpoint cache update: write location {}, read location {}, alternative write location {}", new Object[]{this.currentWriteLocation, this.currentReadLocation, this.alternateWriteLocation});
    }

    URI getRegionalEndpoint(String regionName) {
        if (StringUtils.isNotEmpty((CharSequence)regionName)) {
            String databaseAccountName = this.defaultEndpoint.getHost();
            int indexOfDot = this.defaultEndpoint.getHost().indexOf(46);
            if (indexOfDot >= 0) {
                databaseAccountName = databaseAccountName.substring(0, indexOfDot);
            }
            String regionalAccountName = databaseAccountName + "-" + regionName.replace(" ", "");
            String regionalUrl = this.defaultEndpoint.toString().replaceFirst(databaseAccountName, regionalAccountName);
            try {
                return new URI(regionalUrl);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }
}

