/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.HashIndex;
import com.microsoft.azure.documentdb.Index;
import com.microsoft.azure.documentdb.IndexKind;
import com.microsoft.azure.documentdb.JsonSerializable;
import com.microsoft.azure.documentdb.RangeIndex;
import com.microsoft.azure.documentdb.SpatialIndex;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.text.WordUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class IncludedPath
extends JsonSerializable {
    private Collection<Index> indexes;

    public IncludedPath() {
    }

    public IncludedPath(String jsonString) {
        super(jsonString);
    }

    public IncludedPath(JSONObject jsonObject) {
        super(jsonObject);
    }

    public String getPath() {
        return super.getString("path");
    }

    public void setPath(String path) {
        super.set("path", path);
    }

    public Collection<Index> getIndexes() {
        if (this.indexes == null) {
            this.indexes = this.getIndexCollection();
            if (this.indexes == null) {
                this.indexes = new ArrayList<Index>();
            }
        }
        return this.indexes;
    }

    public void setIndexes(Collection<Index> indexes) {
        this.indexes = indexes;
    }

    private Collection<Index> getIndexCollection() {
        if (this.propertyBag != null && this.propertyBag.has("indexes")) {
            JSONArray jsonArray = this.propertyBag.getJSONArray("indexes");
            ArrayList<Index> result = new ArrayList<Index>();
            block5: for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                IndexKind indexKind = IndexKind.valueOf(WordUtils.capitalize((String)jsonObject.getString("kind")));
                switch (indexKind) {
                    case Hash: {
                        result.add(new HashIndex(jsonObject.toString()));
                        continue block5;
                    }
                    case Range: {
                        result.add(new RangeIndex(jsonObject.toString()));
                        continue block5;
                    }
                    case Spatial: {
                        result.add(new SpatialIndex(jsonObject.toString()));
                    }
                }
            }
            return result;
        }
        return null;
    }

    @Override
    void populatePropertyBag() {
        if (this.indexes != null) {
            for (Index index : this.indexes) {
                index.populatePropertyBag();
            }
            super.set("indexes", this.indexes);
        }
    }
}

