/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.Attachment;
import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.internal.DocumentServiceResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StoredProcedureResponse {
    private final Logger logger = LoggerFactory.getLogger(StoredProcedureResponse.class);
    private DocumentServiceResponse response;

    StoredProcedureResponse(DocumentServiceResponse response) {
        this.response = response;
    }

    public String getActivityId() {
        return this.response.getResponseHeaders().get("x-ms-activity-id");
    }

    public String getSessionToken() {
        return this.response.getResponseHeaders().get("x-ms-session-token");
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public String getMaxResourceQuota() {
        return this.response.getResponseHeaders().get("x-ms-resource-quota");
    }

    public String getCurrentResourceQuotaUsage() {
        return this.response.getResponseHeaders().get("x-ms-resource-usage");
    }

    public double getRequestCharge() {
        String value = this.response.getResponseHeaders().get("x-ms-request-charge");
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            this.logger.warn("Invalid x-ms-request-charge value {}.", (Object)value);
            return 0.0;
        }
    }

    public Map<String, String> getResponseHeaders() {
        return this.response.getResponseHeaders();
    }

    public Document getResponseAsDocument() {
        return this.response.getResource(Document.class);
    }

    public Attachment getResponseAsAttachment() {
        return this.response.getResource(Attachment.class);
    }

    public String getResponseAsString() {
        return this.response.getReponseBodyAsString();
    }

    public String getScriptLog() {
        String scriptLog = this.response.getResponseHeaders().get("x-ms-documentdb-script-log-results");
        if (scriptLog != null) {
            try {
                scriptLog = URLDecoder.decode(scriptLog, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                this.logger.warn("Unable to decode script log results.", (Throwable)e);
            }
        }
        return scriptLog;
    }
}

