/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.EndpointManager;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EndpointDiscoveryRetryPolicy
implements RetryPolicy {
    private static final int MAX_RETRY_COUNT = 120;
    private static final int RETRY_INTERVAL_IN_MS = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointDiscoveryRetryPolicy.class);
    private final EndpointManager globalEndpointManager;
    private final ConnectionPolicy connectionPolicy;
    private final DocumentServiceRequest request;
    private int failoverRetryCount = 0;

    public EndpointDiscoveryRetryPolicy(ConnectionPolicy connectionPolicy, EndpointManager globalEndpointManager, DocumentServiceRequest request) {
        this.connectionPolicy = connectionPolicy;
        this.globalEndpointManager = globalEndpointManager;
        this.request = request;
    }

    @Override
    public long getRetryAfterInMilliseconds() {
        if (!this.request.isReadOnlyRequest() && this.globalEndpointManager.getAlternateWriteEndpoint() != null) {
            return this.failoverRetryCount <= 1 ? 0L : 1000L;
        }
        return 1000L;
    }

    @Override
    public boolean shouldRetry(DocumentClientException exception) {
        if (!this.connectionPolicy.getEnableEndpointDiscovery()) {
            return false;
        }
        if (this.failoverRetryCount >= 120) {
            return false;
        }
        ++this.failoverRetryCount;
        if (this.request.isReadOnlyRequest()) {
            this.globalEndpointManager.markReadEndpointUnavailable();
        }
        if (!this.request.isReadOnlyRequest() && this.globalEndpointManager.getAlternateWriteEndpoint() != null) {
            this.request.setUseAlternateWriteEndpoint(!this.request.useAlternateWriteEndpoint());
            LOGGER.debug("Failover happening. UseAlternateWriteEndpoint {} RetryCount {}", (Object)this.request.useAlternateWriteEndpoint(), (Object)this.failoverRetryCount);
        } else {
            LOGGER.debug("Encountered endpoint error. Refreshing enpoint list and retry now. RetryCount {}", (Object)this.failoverRetryCount);
            this.globalEndpointManager.refreshEndpointList();
        }
        return true;
    }
}

