/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.SessionContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTokenHelper {
    private static final Logger logger = LoggerFactory.getLogger(SessionTokenHelper.class);

    public static void setPartitionLocalSessionToken(DocumentServiceRequest request, SessionContainer sessionContainer) throws DocumentClientException {
        Long sessionLsn;
        String originalSessionToken = request.getHeaders().get("x-ms-session-token");
        String partitionKeyRangeId = request.getResolvedPartitionKeyRange().getId();
        if (StringUtils.isNotEmpty((CharSequence)originalSessionToken)) {
            sessionLsn = SessionTokenHelper.getLocalSessionToken(request, originalSessionToken, partitionKeyRangeId);
            if (sessionLsn != null) {
                request.setSessionLsn(sessionLsn);
            }
        } else {
            sessionLsn = sessionContainer.resolvePartitionLocalSessionToken(request, partitionKeyRangeId);
            if (sessionLsn != null) {
                request.setSessionLsn(sessionLsn);
            }
        }
        if (request.getSessionLsn() == -1L) {
            request.getHeaders().remove("x-ms-session-token");
            logger.trace("Removed partition local session token, partitionKeyRangeId: {}", (Object)partitionKeyRangeId);
        } else {
            String localSessionToken = String.format("%s:%d", partitionKeyRangeId != null ? partitionKeyRangeId : "0", request.getSessionLsn());
            request.getHeaders().put("x-ms-session-token", localSessionToken);
            logger.trace("Set partition local session token partitionKeyRangeId: {}, sessionToken: {}", (Object)partitionKeyRangeId, (Object)localSessionToken);
        }
    }

    private static Long getLocalSessionToken(DocumentServiceRequest request, String sessionToken, String partitionKeyRangeId) throws DocumentClientException {
        if (partitionKeyRangeId == null || partitionKeyRangeId.isEmpty()) {
            throw new IllegalStateException("Partition key range Id is absent in the context.");
        }
        String[] localTokens = StringUtils.split((String)sessionToken, (char)',');
        HashSet<String> partitionKeyRangeSet = new HashSet<String>();
        partitionKeyRangeSet.add(partitionKeyRangeId);
        Long maxLsn = null;
        if (request.getResolvedPartitionKeyRange() != null && request.getResolvedPartitionKeyRange().getParents() != null) {
            partitionKeyRangeSet.addAll(request.getResolvedPartitionKeyRange().getParents());
        }
        for (String localToken : localTokens) {
            String[] items = StringUtils.split((String)localToken, (char)':');
            Long tokenLsn = null;
            if (items.length == 2) {
                try {
                    tokenLsn = Long.parseLong(items[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (tokenLsn == null) {
                throw new DocumentClientException(400, "Invalid session token value.");
            }
            if (!partitionKeyRangeSet.contains(items[0]) || maxLsn != null && maxLsn >= tokenLsn) continue;
            maxLsn = tokenLsn;
        }
        return maxLsn;
    }

    static Long resolvePartitionLocalSessionToken(DocumentServiceRequest request, String partitionKeyRangeId, ConcurrentHashMap<String, Long> rangeIdToTokenMap) {
        if (rangeIdToTokenMap != null) {
            if (rangeIdToTokenMap.containsKey(partitionKeyRangeId)) {
                return rangeIdToTokenMap.get(partitionKeyRangeId);
            }
            Collection<String> parents = request.getResolvedPartitionKeyRange().getParents();
            if (parents != null) {
                ArrayList<String> parentsList = new ArrayList<String>(parents);
                for (int i = parentsList.size() - 1; i >= 0; --i) {
                    String parentId = (String)parentsList.get(i);
                    if (!rangeIdToTokenMap.containsKey(parentId)) continue;
                    return rangeIdToTokenMap.get(parentId);
                }
            }
        }
        return null;
    }

    public static void captureSessionToken(SessionContainer sessionContainer, DocumentServiceRequest request, Map<String, String> responseHeaders) {
        if (request.getResourceType() != ResourceType.DocumentCollection || request.getOperationType() != OperationType.Delete) {
            sessionContainer.setSessionToken(request, responseHeaders);
        } else {
            sessionContainer.clearToken(request);
        }
    }

    public static void updateSession(SessionContainer sessionContainer, DocumentServiceRequest request, DocumentClientException dce) {
        if (request.getIsNameBased() && 404 == dce.getStatusCode() && dce.getSubStatusCode() != null && 1002 == dce.getSubStatusCode() && request.shouldClearSessionTokenOnSessionReadFailure()) {
            logger.debug("Clear the token for request {}", (Object)request.getResourceAddress());
            sessionContainer.clearToken(request);
        } else if (!request.getResourceType().isMasterResource() && (dce.getStatusCode() == 412 || dce.getStatusCode() == 409 || dce.getStatusCode() == 404 && dce.getSubStatusCode() != null && dce.getSubStatusCode() != 1002)) {
            SessionTokenHelper.captureSessionToken(sessionContainer, request, dce.getResponseHeaders());
        }
    }
}

